/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.channelservice.service.impl;

import com.thebeastshop.pegasus.channelservice.constants.PegasusConstants;
import com.thebeastshop.pegasus.channelservice.dao.ChnserAccountMapper;
import com.thebeastshop.pegasus.channelservice.model.ChnserAccount;
import com.thebeastshop.pegasus.channelservice.model.ChnserAccountExample;
import com.thebeastshop.pegasus.channelservice.service.ChnserAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Royan
 * @version $Id: AccountServiceImpl.java, v 0.1 2015-07-14 上午11:31
 */
@Service("accountService")
public class ChnserAccountServiceImpl implements ChnserAccountService {

    private final Logger logger = LoggerFactory.getLogger(ChnserAccountServiceImpl.class);

    @Autowired
    private ChnserAccountMapper chnserAccountMapper;

    /**
     * 根据账号编码查找有效账号
     *
     * @param code 账号编码
     * @return 账号
     */
    @Override
    public ChnserAccount findAvailableAccountByCode(String code) {
        ChnserAccountExample example = new ChnserAccountExample();
        example.createCriteria().andCodeEqualTo(code).andAccountStatusEqualTo(PegasusConstants.STATUS_AVAILABLE);
        List<ChnserAccount> result = chnserAccountMapper.selectByExample(example);
        return (result != null && !result.isEmpty()) ? result.get(0) : null;
    }

	@Override
	public ChnserAccount login(String code, String signKey) {
		
        ChnserAccountExample example = new ChnserAccountExample();
        example.createCriteria().andCodeEqualTo(code).andAccountStatusEqualTo(PegasusConstants.STATUS_AVAILABLE).andCodeEqualTo(code).andSignKeyEqualTo(signKey);
        List<ChnserAccount> result = chnserAccountMapper.selectByExample(example);
        return (result != null && !result.isEmpty()) ? result.get(0) : null;
	}
}