package com.thebeastshop.pegasus.channelservice.service;

import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.param.SendCouponGroupParam;
import com.thebeastshop.pegasus.channelservice.param.SendCouponParam;

import java.util.List;

/**
 * 发券逻辑下层
 * create by com.thebeastshop.pegasus.channelservice.service trunk :author lijing
 * User:lijing
 * DATE : 2016/9/19
 * TIME : 16:44
 * trunk.
 */
public interface SendCouponService {
    /***
     * 发券service 接口  不发 短信
     * @param sendCouponParam 发券的参数
     * @return
     */
    public JsonApiResult sendCoupon(SendCouponParam sendCouponParam);

    /**
     * 发送组合券   就是 给一个人发送多张券
     * @param sendCouponGroupParam 套券参数
     * @return
     */
    public JsonApiResult sendCouponGroup(SendCouponGroupParam sendCouponGroupParam);


    /**
     * 查询现在正在进行的 卡券活动
     * @return
     */
    public List<Long> findCouponSampleIdsNowActivity();
}
