package com.thebeastshop.pegasus.channelservice.service;

import java.util.Collection;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;

/**
 * FF
 * @author Paul-xiong
 *
 */
public interface ProductCouponService {
	/**
	 * 判断商品是否满足优惠券
	 * 
	 * @param product
	 * @param coupon
	 * @return
	 */
	Boolean checkProductInCoupon(PsProductVO product, CpCouponVO coupon);

	/**
	 * 判断商品包是否满足优惠券
	 * 
	 * @param sourcePacks
	 * @param coupon
	 * @param accessWay
	 * @return
	 */
	boolean checkCoupon(Collection<? extends ProductPack> sourcePacks, CpCouponVO coupon, AccessWayEnum accessWay);
	
	/**
	 * 判断商品包是否满足优惠券
	 * 
	 * @param sourcePacks
	 * @param coupon
	 * @param accessWay
	 * @return
	 */
	boolean checkCoupon(Collection<? extends ProductPack> sourcePacks, CpCouponVO coupon, AccessWayEnum accessWay,MemberVO member,OpChannelVO opChannel);

}
