package com.thebeastshop.pegasus.channelservice.service;

import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.cart.ProductPack;

import java.math.BigDecimal;
import java.util.List;

/**
 * 价格服务，计算商品价格折扣
 * 
 * @author Paul-xiong
 *
 */
public interface PriceService {

	/**
	 * 计算商品包折扣
	 * 
	 * @param dto
	 * @return
	 */
	public PriceResult calculateProductPackPrice(CalculateProductPackDTO dto);

	/**
	 * 定制价格
	 * 
	 * @param dto
	 * @return
	 */
	public BigDecimal calculateCustomizePrice(CalculateProductPackDTO dto);

	/**
	 * 计算主商品包商品活动后价格价格 获取商品包，活动后，会员折扣、生日折扣后价格
	 *
	 * @param dto
	 * @return
	 */
	public List<? extends ProductPack> calculateRawProductPackPrice(CalculateProductPackDTO dto);

	/**
	 * 计算礼品卡步骤
	 * 
	 * @param dto
	 * @return
	 */
	public List<OpSalesOrderGiftCardVO> calculateGiftPrice(List<GiftCardVO> giftCards, BigDecimal orderPrice);

}
