package com.thebeastshop.pegasus.channelservice.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.model.OrderFeeVO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.model.ServiceFeeStep;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;

/**
 * 邮费服务
 * 
 * @author Paul-xiong
 *
 */
public interface PostageService {

	/**
	 * 计算邮费
	 * 
	 * @param packs
	 *            商品包
	 * @param price
	 *            价格
	 * @param member
	 *            会员
	 * @return
	 */
	BigDecimal calculatePostageNew(Collection<? extends ProductPack> packs, BigDecimal price, MemberVO member,boolean hasOverSea);
	/**
	 * 计算邮费
	 * 
	 * @param packs
	 *            商品包
	 * @param price
	 *            价格
	 * @param member
	 *            会员
	 * @return
	 */
	BigDecimal calculatePostage(Collection<? extends ProductPack> packs, BigDecimal price, MemberVO member);

	/**
	 * 计算邮费
	 * 
	 * @param hasOverSea
	 *            是否有海淘商品
	 * @param price
	 *            价格
	 * @return
	 */
	BigDecimal calculatePostage(boolean hasOverSea, BigDecimal price, MemberVO member);

	/**
	 * 邮费及服务费计算
	 * 
	 */
	List<PriceStepVO> calculatePostageWithStep(BigDecimal customizePrice, int timeSlot, PostageVO postageVO, Collection<? extends CartProductPack> packs, BigDecimal price, MemberVO member, AccessWayEnum accessWay,OpChannelVO opChannelVO);
	
	List<PriceStepVO> calculatePostageWithStepNew(BigDecimal customizePrice, int timeSlot, PostageVO postageVO, Collection<? extends CartProductPack> packs, BigDecimal price, MemberVO member, AccessWayEnum accessWay,OpChannelVO opChannelVO,boolean hasOverSea);

	/**
	 * 邮费及服务费计算
	 * 
	 */
	List<PriceStepVO> calculatePostageWithSteps(BigDecimal customizePrice, int timeSlot, PostageVO postageVO, Collection<? extends ProductPack> packs, BigDecimal price, MemberVO member, AccessWayEnum accessWay,OpChannelVO opChannelVO);

	/**
	 * 邮费及服务费计算 （优先使用免邮卡）
	 */
//	List<PriceStepVO> calculatePostageWithStep(BigDecimal customizePrice, int timeSlot, PostageVO postageVO, boolean hasOverSea, BigDecimal price, MemberVO member, AccessWayEnum accessWay, List<String> productCodes);

	/**
	 * 服务费详情计算
	 */
	OrderFeeVO calculateServiceFee(BigDecimal customizePrice, int timeSlot, PostageVO postageVO, Collection<? extends ProductPack> packs, BigDecimal price, BigDecimal remoteFee, MemberVO member, AccessWayEnum accessWay);
	
	/**
	 * 服务费详情计算
	 */
	OrderFeeVO calculateServiceFeeNew(BigDecimal customizePrice, int timeSlot, PostageVO postageVO, Collection<? extends ProductPack> packs, BigDecimal price, BigDecimal remoteFee, MemberVO member, AccessWayEnum accessWay,boolean hasOverSea);

	/**
	 * 邮费及服务费计算 （优先使用免邮卡）
	 */
	//OrderFeeVO calculateServiceFee(BigDecimal customizePrice, int timeSlot, PostageVO postageVO, boolean hasOverSea, BigDecimal price, BigDecimal remoteFee, MemberVO member, AccessWayEnum accessWay, List<String> productCodes);

	/**
	 * 价格步骤整理
	 */
	List<PriceStepVO> switchPriceSteps(PriceResult priceResult, List<PriceStepVO> serviceSteps);

	/**
	 * 计算支付价 后端实体用
	 */
	BigDecimal calculatePayment(PriceResult priceResult, List<ServiceFeeStep> serviceSteps);

	// /**
	// * 计算支付价 前端实体用
	// */
	// BigDecimal calculatePayment(PriceResult priceResult, List<PriceStepVO>
	// serviceSteps);
}
