package com.thebeastshop.pegasus.channelservice.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;

/**
 * @author Liang Wenjian
 */
public interface OverseaService {

	/**
	 * 判断是否是海淘商品
	 * 
	 * @param product
	 * @return
	 */
	boolean isOversea(PsProductVO product);

	/**
	 * 判断是否是海淘商品
	 * 
	 * @param spv
	 * @return
	 */
	boolean isOversea(PsSpvVO spv);

	/**
	 * 判断是否是海淘商品
	 * 批量接口
	 * @param spvs
	 * @return
	 */
	boolean isOverseas(List<PsSpvVO> spvs);

	/**
	 * 判断是否有海淘商品
	 * 
	 * @param packs
	 * @return
	 */
	boolean isOversea(List<? extends ProductPack> packs);
	int isOverseaOrPhoto(List<? extends ProductPack> packs);

	/**
	 * 批量判断是否是海淘商品，并组成map
	 * 
	 * @param products
	 * @return
	 */
	Map<PsProductVO, Boolean> mapProductsIsOversea(Collection<PsProductVO> products);

	/**
	 * 通过productIds 批量返回 是否是海外购
	 * 
	 * @author lijing
	 * @param productIds
	 * @return
	 */
	Map<Long, Boolean> mapProductIdsIsOversea(List<Long> productIds);

	/**
	 * 批量判断是否是海淘spv，并组成map
	 * 
	 * @param spvs
	 * @return
	 */
	Map<PsSpvVO, Boolean> mapSpvsIsOversea(Collection<PsSpvVO> spvs);
}
