package com.thebeastshop.pegasus.channelservice.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.Label;

/**
 * 
 * @author Paul-xiong
 *
 */
public interface LabelService {
	/**
	 * 获取商品的标签
	 * 
	 * @param products
	 * @param channel
	 * @param accessWay
	 * @return
	 */
	Map<PsProductVO, List<Label>> getProductLabels(Collection<PsProductVO> products);

	/**
	 * 获取spv的标签
	 * 
	 * @param spvs
	 * @param channel
	 * @param accessWay
	 * @return
	 */
	Map<PsSpvVO, List<Label>> getSpvLabels(Collection<PsSpvVO> spvs, AccessWayEnum accessWay);

	/**
	 * 获取购物车的标签
	 * 
	 * @param campaignResults
	 * @param channel
	 * @return
	 */
	List<Label> getCartLabels(List<CampaignResult> campaignResults, AccessWayEnum accessWay);

	List<Label> getLabels(ProductPack pack, List<CampaignResult> campaignResults, AccessWayEnum accessWay);

	/**
	 * 获取邮费标签
	 * 
	 * @param price
	 * @param hasOverSea
	 * @param channel
	 * @param accessWay
	 * @return
	 */
	List<Label> getPostageLabel(BigDecimal price, boolean hasOverSea, AccessWayEnum accessWay);
}
