package com.thebeastshop.pegasus.channelservice.service;


import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.vo.CpCouponSampleVO;

/**
 * 优惠券模板规则校验服务
 * Created by GFL on 2017/5/24.
 */
public interface CouponSampleVerifyService {


    /**
     * 校验模板是否可用于指定商品
     * @param sourcePacks
     * @param couponSample
     * @param accessWay
     * @return
     */
    boolean verifySampleUsableForProducts(Collection<? extends ProductPack> sourcePacks, CpCouponSampleVO couponSample, AccessWayEnum accessWay);


    /**
     * 获取可用优惠券模板
     * @param sourcePacks
     * @param couponSample
     * @param accessWay
     * @return 返回Map<模板id,模板>
     */
    Map<Long,CpCouponSampleVO> getUsableSampleForProducts(Collection<? extends ProductPack> sourcePacks, List<CpCouponSampleVO> couponSample, AccessWayEnum accessWay);


    /**
     * 获取指定商品可用默认优惠券模板
     * @param sourcePacks
     * @param couponSample
     * @param accessWay
     * @return 返回Map<模板id,模板>
     */
    Map<Long,CpCouponSampleVO> getUsableSampleDefaultForProducts(Collection<? extends ProductPack> sourcePacks, List<CpCouponSampleVO> couponSample, AccessWayEnum accessWay);

}
