package com.thebeastshop.pegasus.channelservice.service.Benefit.impl;


import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.coupon.service.CpCouponSetService;

import com.thebeastshop.member.constant.MemberPointConstant;
import com.thebeastshop.member.cron.MemberIntegralCron;
import com.thebeastshop.member.cron.ReferenceIntegral;
import com.thebeastshop.member.service.point.MemberShipIntegralService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.service.Benefit.BenefitRedeemService;

import com.thebeastshop.pegasus.service.operation.exception.OperationException;
import com.thebeastshop.privilege.service.InterestFreeService;
import com.thebeastshop.privilege.service.PrivilegeService;
import com.thebeastshop.privilege.vo.InterestFreeProvideVO;
import com.thebeastshop.privilege.vo.PrivilegeInstanceVO;
import com.thebeastshop.privilege.vo.PrivilegeRecordVO;
import com.thebeastshop.privilege.vo.PrivilegeTemplateVO;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.vo.benefit.RedeemDetailVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * Created by feilong.gao on 2017/4/18.
 */
@Service
public class BenefitRedeemServiceImpl implements BenefitRedeemService {

    private Logger logger = LoggerFactory.getLogger(BenefitRedeemService.class);


    @Autowired
    private CpCouponSetService cpCouponSetService;

    @Autowired
    private MemberShipIntegralService memberShipIntegralService;
    @Autowired
    private PrivilegeService privilegeService;
    @Autowired
    private InterestFreeService interestFreeService;

    @Override
    public RedeemDetailVO redeemPrivilegeById(MemberVO member, Integer benefitId) {
        RedeemDetailVO result = new RedeemDetailVO();
        ServiceResp<PrivilegeTemplateVO> templateResp = privilegeService.getUserPrivilegeDetail(member.getId().intValue(), benefitId, member.getLastLevelUpdateTime
                ());
        if (templateResp.isSuccess()) {
            PrivilegeTemplateVO templateVO = templateResp.getBean();
            // 0 未领取 1 已领取  2 已过期 -1 未满足条件
            if (0 != templateVO.getIsRecieve()) {
                if (1 == templateVO.getPrivilegeType()) {
                    throw new ChannelException(400,"礼包不能领取");
                } else if (4 == templateVO.getPrivilegeType()) {
                    throw new ChannelException(400,"福利不能领取");
                }
            }
            // 1、 获取特权模板对应的领取信息
            ServiceResp<List<PrivilegeInstanceVO>> resp = privilegeService.queryByTemplateId(benefitId, member.getId().intValue());
            if (resp.isSuccess()) {
                List<PrivilegeInstanceVO> instanceVOs = resp.getBean();
                //实例类型 1.折扣 2.积分 3.线上券 4.线下券 5.第三方券 6.积分兑换 7.每月免邮 8:礼包免邮 9.海淘免邮 10.商品权益 11.每日求签
                // 2、 发放特权
                // 3、 保存发放信息
                for (PrivilegeInstanceVO instanceVO : instanceVOs) {
                    boolean flag = false;
                    Integer bussinessId = null;
                    if (7 == instanceVO.getType() || 8 == instanceVO.getType() || 9 == instanceVO.getType()) {
                        bussinessId = this.redeemInterest(member, Integer.parseInt(instanceVO.getBingdingValue()));
                        if (!NumberUtil.isNullOrZero(bussinessId)) {
                            flag = true;
                        }
                        this.saveRedeemRecod(member, flag, bussinessId, instanceVO, benefitId);
                    }
                    if (3 == instanceVO.getType()) {
                        flag = this.redeemCouponSet(member, Long.parseLong(instanceVO.getBingdingValue()));
                        bussinessId = Integer.parseInt(instanceVO.getBingdingValue());
                        this.saveRedeemRecod(member, flag, bussinessId, instanceVO, benefitId);
                    }
                    if (2 == instanceVO.getType()) {
                        flag = this.redeemPoints(member, Integer.parseInt(instanceVO.getBingdingValue()));
                        bussinessId = Integer.parseInt(instanceVO.getBingdingValue());
                        this.saveRedeemRecod(member, flag, bussinessId, instanceVO, benefitId);
                    }
                }
            }

            // 4、 返回领取详细描述
            String boxMsg = templateVO.getBoxMsg();
            if (StringUtils.isNotEmpty(boxMsg)) {
                result = new GsonBuilder().create().fromJson(boxMsg, RedeemDetailVO.class);
            } else {
                result.setTitle(templateVO.getName());
            }
            result.setIcon(FileConstant.BASE_URL +  templateResp.getBean().getBoxIcon());
        }
        return result;
    }


    /**
     * 领取免邮权益
     *
     * @param member         会员
     * @param interestFreeId 免邮权益id
     * @return provideId  返回null 表示插入失败
     */
    private Integer redeemInterest(MemberVO member, Integer interestFreeId) {
        Integer provideId = null;
        logger.info("发放特权免邮权益入参：memeberId={} interestFreeId={} ", member.getId(), interestFreeId);
        try {
            ServiceResp<InterestFreeProvideVO> resp = interestFreeService.giveInterestFree(member.getId().intValue(), interestFreeId);
            if(resp.isFailure()){
                throw new ChannelException(400,resp.getRespMsg());
            }
            provideId = resp.getBean().getId();
        } catch (Exception e) {
            logger.error("发放特权免邮权益失败", e);
        }
        logger.info("发放特权免邮权益结果：{}", provideId);
        return provideId;
    }

    /**
     * 领取套券
     *
     * @param member
     * @param couponSetId
     * @return
     */

    private Boolean redeemCouponSet(MemberVO member, Long couponSetId) {
        Boolean flag = true;
        logger.info("发放特权套券入参：memeberId={} couponSetId={} ", member.getId(), couponSetId);
        try {
            List<Long> couponSetIds = Lists.newArrayList(couponSetId);
            List<Long> memeberIds = Lists.newArrayList(member.getId());
             ServiceResp<Boolean>  resp = cpCouponSetService.sendCouponsToMemberIds(couponSetIds, memeberIds);
             if (resp.isFailure() || !resp.getBean()) {
                throw new OperationException(resp.getRespMsg());
            }
        } catch (Exception e) {
            flag = false;
            logger.error("发放特权套券失败", e);
        }
        logger.info("发放特权套券结果：{}", flag);
        return flag;
    }


    /**
     * 领取会员积分
     *
     * @param member
     * @param points
     * @return
     */

    private Boolean redeemPoints(MemberVO member, Integer points) {
        Boolean flag;
        logger.info("发放特权积分入参：memeberId={} points={}", member.getId(), points);
        try {
            MemberIntegralCron memberIntegralCron = new MemberIntegralCron();
            memberIntegralCron.setMemberCode(member.getCode());
            memberIntegralCron.setMemberId(member.getId());
            
            ReferenceIntegral referenceIntegral = new ReferenceIntegral();
            referenceIntegral.setMemberPointType(MemberPointConstant.Pont_Type_Id.TYPE_MEMEBER_PACKAGE_ADD);
            referenceIntegral.setPoints(new BigDecimal(points));
            referenceIntegral.setReferenceCode("LB" + com.thebeastshop.common.utils.DateUtil.getCurrDate_YYYY_MM_DD());
            
            memberIntegralCron.setReferenceIntegrals(Lists.newArrayList(referenceIntegral));
            flag = memberShipIntegralService.addMemberCommonPoint(memberIntegralCron);
        } catch (Exception e) {
            flag = false;
            logger.error("发放特权积分异常", e);
        }
        logger.info("发放特权积分结果：{}", flag);
        return flag;
    }


    /**
     * 保存领取记录
     *
     * @param member
     * @param flag
     * @param bussinessId
     * @param instanceVO
     * @param benefitId
     * @return
     */

    private void saveRedeemRecod(MemberVO member, Boolean flag, Integer bussinessId, PrivilegeInstanceVO instanceVO, Integer benefitId) {
        logger.info("保存发放记录入参：memeberId={} flag={} bussinessId={} instanceId={} benefitId={}", member.getId(), flag, bussinessId, instanceVO.getId(), benefitId);
        try {
            PrivilegeRecordVO recordVO = new PrivilegeRecordVO();
            recordVO.setMemberId(member.getId().intValue());
            recordVO.setBussinessId(bussinessId);
            recordVO.setInstanceId(instanceVO.getId());
            recordVO.setMemberLevel(member.getMemberLevel());
            recordVO.setStatus(flag ? 0 : 1);
            recordVO.setTemplateId(benefitId);
            recordVO.setCreateTime(DateUtil.getNow());
            ServiceResp<Boolean> resp = privilegeService.receivePrivilege(recordVO);
            logger.info("保存发放记录入结果：{}", resp.isSuccess());
        } catch (Exception e) {
            logger.error("保存发放记录异常", e);
        }
    }

}
