package com.thebeastshop.pegasus.channelservice.service.Benefit.impl;

import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.privilege.enumeration.*;
import com.thebeastshop.privilege.service.InterestFreeService;
import com.thebeastshop.privilege.vo.InterestFreeVO;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.service.Benefit.BenefitQueryService;
import com.thebeastshop.privilege.cond.PrivilegeInstanceCond;
import com.thebeastshop.privilege.service.PrivilegeService;
import com.thebeastshop.privilege.vo.PrivilegeInstanceVO;
import com.thebeastshop.privilege.vo.PrivilegeTemplateVO;
import com.thebeastshop.support.enums.PointLevel;
import com.thebeastshop.support.enums.benefit.BenefitStateEnum;
import com.thebeastshop.support.enums.benefit.ReminderBtnEnum;
import com.thebeastshop.support.enums.benefit.ReminderTypeEnum;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.vo.benefit.BenefitQuota;
import com.thebeastshop.support.vo.benefit.BenefitVO;
import com.thebeastshop.support.vo.benefit.DetailDesc;
import com.thebeastshop.support.vo.benefit.ReminderVO;
import com.thebeastshop.support.vo.benefit.StateVO;
import com.thebeastshop.support.vo.benefit.VipBenefitVO;

/**
 * Created by feilong.gao on 2017/4/18.
 */
@Service
public class BenefitQueryServiceImpl implements BenefitQueryService {
    @Autowired
    private PrivilegeService privilegeService;
    @Autowired
    private InterestFreeService interestFreeService;

    @Override
    public List<BenefitVO> getVIPPrivilegeByLevel(Integer memberLevel) {
        List<BenefitVO> benefitVOs = new ArrayList<>();
        if (MemberLevelEnum.NORMAL.getCode().equals(memberLevel)) {
            memberLevel = MemberLevelEnum.VIP.getCode();
        }
        ServiceResp<List<PrivilegeTemplateVO>> result = privilegeService.getUserPrivilege(memberLevel);
        if (result.isSuccess()) {
            List<PrivilegeTemplateVO> privilegeTemplateVOs = result.getBean();
            for (PrivilegeTemplateVO templateVO : privilegeTemplateVOs) {
                BenefitVO benefitVO = BenefitVO.createSimpleBenefit(templateVO.getId(), templateVO.getIcon(), templateVO.getPressedIcon(), templateVO.getName());
                benefitVOs.add(benefitVO);
            }
        }
        return benefitVOs;
    }

    @Override
    public List<VipBenefitVO> getAllVIPPrivilege() {
        List<VipBenefitVO> result = new ArrayList<>();
        for (MemberLevelEnum level : MemberLevelEnum.values()) {
            if (MemberLevelEnum.NORMAL.getCode().equals(level.getCode())) {
                //跳过注册用户
                continue;
            }
            VipBenefitVO vipBenefitVO = new VipBenefitVO();
            vipBenefitVO.setIcon(level.getAvatarUrl());
            vipBenefitVO.setName(level.getName());
            vipBenefitVO.setLevel(level.getCode());
            vipBenefitVO.setMinPoint(PointLevel.getLevelPointByLevel(level.getCode()).getMinPoint().intValue());
            List<BenefitVO> list = this.getVIPPrivilegeByLevel(level.getCode());
            vipBenefitVO.setBenefits(list);
            result.add(vipBenefitVO);
        }
        return result;
    }

    @Override
    public List<ReminderVO> getBenefitReminders(MemberVO member) {
        List<ReminderVO> rt = new ArrayList<ReminderVO>();
        ServiceResp<List<PrivilegeTemplateVO>> result = privilegeService.getRemindPrivilege(member.getMemberLevel(), member.getId().intValue(), member.getLastLevelUpdateTime());
        if (result.isSuccess()) {
            List<PrivilegeTemplateVO> privilegeTemplateVOs = result.getBean();
            for (PrivilegeTemplateVO templateVO : privilegeTemplateVOs) {
                String link = "";
                String linkType = "";
                if (StringUtils.isNotBlank(templateVO.getDescription())) {
                    DetailDesc detailDesc = new GsonBuilder().create().fromJson(templateVO.getDescription(), DetailDesc.class);
                    if (null != detailDesc && CollectionUtils.isNotEmpty(detailDesc.getList())) {
                        link = detailDesc.getList().get(0).getLink();
                        linkType = detailDesc.getList().get(0).getLinkType();
                    }

                }
                ReminderVO reminderVO = new ReminderVO();
                reminderVO.setName(templateVO.getName());
                reminderVO.setBenefitId(templateVO.getId());
                reminderVO.setBtnText(ReminderBtnEnum.getBtnTextByPrivilegeTypeId(templateVO.getPrivilegeType()));
                // 模板动作: 1.显示 2:跳转 3:领取
                if (2 == templateVO.getAction()) {
                    reminderVO.setType(ReminderTypeEnum.DEEPLINK);
                    reminderVO.setLink(link);
                    reminderVO.setLinkType(linkType);
                }
                if (3 == templateVO.getAction()) {
                    reminderVO.setType(ReminderTypeEnum.VIP_BENEFIT);
                }
                if (PrivilegTypeEnum.BD_GIFT_BAG.getId().equals(templateVO.getPrivilegeType())) {
                    if (null == member.getBirthday()) {
                        reminderVO.setName("你的生日还没设置");
                        reminderVO.setType(ReminderTypeEnum.DEEPLINK);
                        reminderVO.setLink(link);
                        reminderVO.setLinkType(linkType);
                        rt.add(reminderVO);
                    }
                    continue;
                }
                rt.add(reminderVO);
            }
        }
        return rt;
    }

    @Override
    public BenefitVO getBenefitDetails(MemberVO member, Integer benefitId) {
        BenefitVO rt = new BenefitVO();
        ServiceResp<PrivilegeTemplateVO> result = privilegeService.getUserPrivilegeDetail(member.getId().intValue(), benefitId, member.getLastLevelUpdateTime());
        if (result.isSuccess()) {
            PrivilegeTemplateVO templateVO = result.getBean();
            String desc = templateVO.getDescription();
            DetailDesc detailDesc = new GsonBuilder().create().fromJson(desc, DetailDesc.class);
            // 获取状态和按钮
            StateVO stateVO = new StateVO();
            stateVO.setType(BenefitStateEnum.INVALID);
            //设置能否领取
            Boolean redeemable = false;
            // 设置跳转链接
            String link = "";
            String linkType = "";
            String btnText = "";
            // 注册会员无特权
            if (!MemberLevelEnum.NORMAL.getCode().equals(member.getMemberLevel())) {
                // 模板动作: 1.显示 2:跳转 3:领取
                switch (templateVO.getAction()) {
                    case 1:
                        stateVO = StateVO.getStateVO(templateVO.getPrivilegeType(), templateVO.getStatus(), templateVO.getIsRecieve(), templateVO.getAction());
                        if (PrivilegTypeEnum.BD_GIFT_BAG.getId().equals(templateVO.getPrivilegeType()) && null == member.getBirthday()) {
                            stateVO.setType(BenefitStateEnum.PRE);
                            stateVO.setDesc("去设置");
                            link = detailDesc.getList().get(0).getLink();
                            linkType = detailDesc.getList().get(0).getLinkType();
                        }
                        break;
                    case 2:
                        if (null != detailDesc) {
                            link = detailDesc.getList().get(0).getLink();
                            linkType = detailDesc.getList().get(0).getLinkType();
                            btnText = detailDesc.getList().get(0).getBtnText();
                        }
                        stateVO=StateVO.getStateVO(templateVO.getPrivilegeType(), templateVO.getStatus(), templateVO.getIsRecieve(), templateVO.getAction(),btnText);
                        break;
                    case 3:
                        if (templateVO.getIsRecieve() == 0) {
                            redeemable = true;
                        }
                        stateVO = StateVO.getStateVO(templateVO.getPrivilegeType(), templateVO.getStatus(), templateVO.getIsRecieve(), templateVO.getAction());
                        break;
                    default:
                        stateVO.setType(BenefitStateEnum.INVALID);
                }

            }
            rt = BenefitVO.createVipBenefit(templateVO.getId(), templateVO.getDetailIcon(), templateVO.getName(), stateVO, redeemable, detailDesc, link,linkType);
        }
        return rt;
    }

    @Override
    public Page<BenefitVO> queryRecordList(MemberVO member, Integer currPage, Integer pageNum) {
        Page<BenefitVO> page = new Page<>();
        List<BenefitVO> myBenefits = Lists.newArrayList();
        PrivilegeInstanceCond cond = new PrivilegeInstanceCond();
        cond.setMemberId(member.getId().intValue());
        cond.setMemberLevel(member.getMemberLevel());
        cond.setCurrpage(currPage);
        cond.setPagenum(pageNum);
        ServiceResp<PageQueryResp<PrivilegeInstanceVO>> resp = privilegeService.getUserBenefits(cond);
        if (resp.isSuccess()) {
            PageQueryResp<PrivilegeInstanceVO> pageQueryResp = resp.getBean();
            page.setTotal(resp.getBean().getTotalCnt());
            page.setOffset(resp.getBean().getPageNo());
            for (PrivilegeInstanceVO prvInstance : pageQueryResp.getBeanList()) {
                //实例类型 1.折扣 2.积分 3.线上券 4.线下券 5.第三方券 6.积分兑换 7.每月免邮 8:礼包免邮 9.海淘免邮 10.商品权益 11.每日求签
                BenefitQuota quota = new BenefitQuota();
                List<String> briefDesc = Lists.newArrayList();
                if (InstanceTypeEnum.MONTH_FREE.getId().equals(prvInstance.getType()) || InstanceTypeEnum.PACKAGE_FREE.getId().equals(prvInstance.getType()) || InstanceTypeEnum.CROSS_FREE.getId().equals(prvInstance.getType())) {
                    ServiceResp<InterestFreeVO> freeResp = interestFreeService.findInterestFreeFullInfoByProvideId(prvInstance.getBussinessId());
                    if(freeResp.isFailure()){
                        throw new ChannelException(400,freeResp.getRespMsg());
                    }
                    InterestFreeVO interestFreeVO = freeResp.getBean();
                    quota.setTotal(freeResp.getBean().getFreePostNum());
                    quota.setLeft(interestFreeVO.getUseTotal());
                    StringBuffer redeemDesc = new StringBuffer();
                    if (1 == interestFreeVO.getFreePostNum()) {
                        redeemDesc.append("可免1次邮费");
                    } else if (0 == interestFreeVO.getFreePostNum()) {
                        redeemDesc.append("无限次");
                    } else {
                        redeemDesc.append("剩余免邮次数：").append(interestFreeVO.getFreePostNum() - interestFreeVO.getUseTotal()).append("/").append(interestFreeVO.getFreePostNum());
                    }
                    quota.setDesc(redeemDesc.toString());
                    //1、有效期 2、使用地鼠 3、使用商品
                    StringBuffer validPeriod = new StringBuffer();
                    validPeriod.append("有效期：");
                    if (InstanceTypeEnum.CROSS_FREE.getId().equals(prvInstance.getType())) {
                        validPeriod.append("当前会员等级有效期");
                    } else {
                        if (0 == interestFreeVO.getUseTimeType()) {
                            DateUtil.format(interestFreeVO.getUseBeginDate(), DateUtil.DEFAULT_DATE_FORMAT);
                            validPeriod.append(DateUtil.format(interestFreeVO.getUseBeginDate(), DateUtil.DEFAULT_DATE_FORMAT))
                                    .append("至")
                                    .append(DateUtil.format(interestFreeVO.getUseEndDate(), DateUtil.DEFAULT_DATE_FORMAT));
                        } else {
                            validPeriod.append("领取即日起").append(interestFreeVO.getProvideAfterDay()).append("天");
                        }
                    }
                    briefDesc.add(validPeriod.toString());
                    //2.使用次数
                    StringBuffer useTimes = new StringBuffer();
                    useTimes.append("使用次数：");
                    if (0 == interestFreeVO.getFreePostNum()) {
                        useTimes.append("无限次");
                    } else {
                        useTimes.append(interestFreeVO.getFreePostNum()).append("次");
                    }
                    briefDesc.add(useTimes.toString());

                    // 3 适用用平台 PC APP M站
                    String accessWay = interestFreeVO.getAccessWay();
                    if (StringUtils.isNotBlank(accessWay)) {
                        StringBuffer accessWayDesc = new StringBuffer();
                        accessWayDesc.append("适用平台：");
                        List<String> accessWays = Lists.newArrayList(accessWay.split(","));
                        for (String way : accessWays) {
                            if (AccessWayEnum.APP.getId().equals(Integer.parseInt(way))) {
                                accessWayDesc.append(" ").append("APP");
                            } else if (AccessWayEnum.PC.getId().equals(Integer.parseInt(way))) {
                                accessWayDesc.append(" ").append("PC");
                            } else if (AccessWayEnum.WAP.getId().equals(Integer.parseInt(way))) {
                                accessWayDesc.append(" ").append("M站");
                            }
                        }
                        briefDesc.add(accessWayDesc.toString());
                    }
                    // 4 适用商品
                    StringBuffer productScope = new StringBuffer();
                    productScope.append("适用商品：");
                    if (1 == interestFreeVO.getProductScope()) {
                        productScope.append("全场商品");
                    } else {
                        productScope.append("指定商品");
                    }
                    briefDesc.add(productScope.toString());
                    // 5 适用商品  海淘 非海淘
                    Integer crossFlag = interestFreeVO.getCrossBorderFlag();
                    if (!CrossBorderEnum.UNLIMITED.getId().equals(crossFlag)) {
                        StringBuffer crossDesc = new StringBuffer();
                        crossDesc.append("海淘/非海淘：");
                        if (CrossBorderEnum.OVERSEAS.getId().equals(crossFlag)) {
                            crossDesc.append("仅限海淘商品");
                        } else if (CrossBorderEnum.INLAND.getId().equals(crossFlag)) {
                            crossDesc.append("仅限非海淘商品");
                        }
                        briefDesc.add(crossDesc.toString());
                    }

                    StateVO stateVO = new StateVO();
                    if (FreeStatusEnum.VALID.getId().equals(interestFreeVO.getFreeStatus())) {
                        stateVO.setType(BenefitStateEnum.VALID);
                        stateVO.setDesc("已领取");
                    } else if (FreeStatusEnum.EXPIRED.getId().equals(interestFreeVO.getFreeStatus())) {
                        stateVO.setType(BenefitStateEnum.EXPIRED);
                        stateVO.setDesc("已过期");
                    } else if (FreeStatusEnum.USE_UP.getId().equals(interestFreeVO.getFreeStatus())) {
                        stateVO.setType(BenefitStateEnum.USED);
                        stateVO.setDesc("已用完");
                    } else {
                        stateVO.setType(BenefitStateEnum.INVALID);
                        stateVO.setDesc("已失效");
                    }
                    BenefitVO myBenefit = BenefitVO.createMyBenefit(prvInstance.getId(), prvInstance.getIcon(), prvInstance.getName(), stateVO, true, quota, briefDesc);
                    myBenefits.add(myBenefit);
                }
            }
        }
        page.setItems(myBenefits);
        return page;
    }
}
