package com.thebeastshop.pegasus.channelservice.service.Benefit;

import java.util.List;

import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.vo.benefit.BenefitVO;
import com.thebeastshop.support.vo.benefit.ReminderVO;
import com.thebeastshop.support.vo.benefit.VipBenefitVO;

/**
 * 特权领取服务
 * Created by feilong.gao on 2017/4/18.
 */
public interface BenefitQueryService {


    /**
     * 获取等级特权
     * @param memberLevel
     * @return
     */
    List<BenefitVO> getVIPPrivilegeByLevel(Integer memberLevel);


    /**
     * 获取所有vip特权
     * @return
     */
    List<VipBenefitVO> getAllVIPPrivilege();

    /**
     * 获取特权提醒
     * @param member
     * @return
     */
    List<ReminderVO> getBenefitReminders(MemberVO member);

    /**
     * 查询特权详情
     * @param member
     * @param benefitId
     * @return
     */
    BenefitVO getBenefitDetails(MemberVO member,Integer benefitId);


    /**
     * 查询用户福利记录列表
     * @param member
     * @param currPage
     * @param pageNum
     * @return
     */
    Page<BenefitVO> queryRecordList(MemberVO member , Integer currPage , Integer pageNum);

}
