package com.thebeastshop.pegasus.channelservice.model;

import java.math.BigDecimal;

import com.thebeastshop.support.enums.PriceType;

/**
 * 服务费计算步骤类
 * 
 * @author WangYawei
 *
 */
public class ServiceFeeStep {
	/**
	 * 价格类型
	 */
	private PriceType priceType;

	/**
	 * 名字
	 */
	private String name;
	/**
	 * 价格
	 */
	private BigDecimal price;
	/**
	 * 描述
	 */
	private String desc;

	public ServiceFeeStep() {
		super();
	}

	public ServiceFeeStep(String name, BigDecimal price, PriceType priceType) {
		super();
		this.name = name;
		this.price = price;
		this.priceType = priceType;
	}

	public ServiceFeeStep(String name, BigDecimal price, String desc, PriceType priceType) {
		this(name, price, priceType);
		this.desc = desc;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public PriceType getPriceType() {
		return priceType;
	}

	public void setPriceType(PriceType priceType) {
		this.priceType = priceType;
	}

	@Override
	public String toString() {
		return "PriceStep [name=" + name + ", price=" + price + ", desc=" + desc + ", priceType=" + priceType + "]";
	}

}
