package com.thebeastshop.pegasus.channelservice.model;

import java.math.BigDecimal;
import java.util.Map;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.support.enums.PriceType;

/**
 * 价格计算步骤
 * 
 * @author Paul-xiong
 *
 */
public class PriceStep {
	/**
	 * 价格类型
	 */
	private PriceType priceType;
	/**
	 * 价格计算相关的ID 价格类型：会员折扣 --> 会员ID 价格类型：活动类型 --> 活动ID 价格类型：优惠券类型 --> 优惠券ID
	 */
	private Long extId;
	/**
	 * 计算前商品包价格(单件)
	 */
	private Map<ProductPack, BigDecimal> originalPackPrice;
	/**
	 * 计算后商品包价格(单件)
	 */
	private Map<ProductPack, BigDecimal> finalPackPrice;
	/**
	 * 计算前的价格
	 */
	private BigDecimal calculatingPrice;
	/**
	 * 计算后的价格
	 */
	private BigDecimal calculatedPrice;

	public PriceType getPriceType() {
		return priceType;
	}

	public void setPriceType(PriceType priceType) {
		this.priceType = priceType;
	}

	public Long getExtId() {
		return extId;
	}

	public void setExtId(Long extId) {
		this.extId = extId;
	}

	public Map<ProductPack, BigDecimal> getOriginalPackPrice() {
		return originalPackPrice;
	}

	public void setOriginalPackPrice(Map<ProductPack, BigDecimal> originalPackPrice) {
		this.originalPackPrice = originalPackPrice;
	}

	public Map<ProductPack, BigDecimal> getFinalPackPrice() {
		return finalPackPrice;
	}

	public void setFinalPackPrice(Map<ProductPack, BigDecimal> finalPackPrice) {
		this.finalPackPrice = finalPackPrice;
	}

	public BigDecimal getCalculatingPrice() {
		return calculatingPrice;
	}

	public void setCalculatingPrice(BigDecimal calculatingPrice) {
		this.calculatingPrice = calculatingPrice;
	}

	public BigDecimal getCalculatedPrice() {
		return calculatedPrice;
	}

	public void setCalculatedPrice(BigDecimal calculatedPrice) {
		this.calculatedPrice = calculatedPrice;
	}

	/**
	 * 总共优惠的金额
	 * 
	 * @return
	 */
	public BigDecimal getSavedPrice() {
		return getCalculatingPrice().subtract(getCalculatedPrice());
	}

	@Override
	public String toString() {
		return "PriceStep [priceType=" + priceType + ", originalPackPrice=" + originalPackPrice + ", finalPackPrice="
				+ finalPackPrice + ", savedPrice=" + getSavedPrice() + "]";
	}

}
