package com.thebeastshop.pegasus.channelservice.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.collections.CollectionUtils;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.cart.ProductPack;

/**
 * 价格计算结果
 * 
 * @author Paul-xiong
 *
 */
public class PriceResult {
	/**
	 * 优惠步骤
	 */
	private List<PriceStep> steps;

	private List<CampaignResult> campaignResults;

	public List<PriceStep> getSteps() {
		return steps;
	}

	public void setSteps(List<PriceStep> steps) {
		this.steps = steps;
	}

	public List<CampaignResult> getCampaignResults() {
		return campaignResults;
	}

	public void setCampaignResults(List<CampaignResult> campaignResults) {
		this.campaignResults = campaignResults;
	}

	/**
	 * 总原价
	 * 
	 * @return
	 */
	public BigDecimal getTotalPrice() {
		BigDecimal totalOriginPrice = BigDecimal.ZERO;
		if (CollectionUtils.isNotEmpty(steps)) {
			List<ProductPack> packs = Lists.newLinkedList();
			for (PriceStep priceStep : steps) {
				Map<ProductPack, BigDecimal> originalPackPrice = priceStep.getOriginalPackPrice();
				for (Entry<ProductPack, BigDecimal> entry : originalPackPrice.entrySet()) {
					ProductPack pack = entry.getKey();
					if (!packs.contains(pack)) {
						packs.add(pack);
						totalOriginPrice = totalOriginPrice
								.add(entry.getValue().multiply(BigDecimal.valueOf(pack.getCount())));
					}
				}
			}
		}
		return totalOriginPrice;
	}

	/**
	 * 总共优惠的金额
	 * 
	 * @return
	 */
	public BigDecimal getSavedPrice() {
		BigDecimal savedPrice = BigDecimal.ZERO;
		if (CollectionUtils.isNotEmpty(steps)) {
			for (PriceStep priceStep : steps) {
				savedPrice = savedPrice.add(priceStep.getSavedPrice());
			}
		}
		return savedPrice;
	}

	@Override
	public String toString() {
		return "PriceResult [totalPrice=" + getTotalPrice() + ", savedPrice=" + getSavedPrice() + ", steps=" + steps
				+ "]";
	}

}
