package com.thebeastshop.pegasus.channelservice.model;

import java.util.List;

import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;

/**
 * 订单快照dto
 * 
 * @author Paul-xiong
 *
 */
public class OrderSnapshotDTO {
	private Long orderId;

	private List<? extends ProductPack> packs;

	private Long couponId;

	private MemberVO member;

	private AccessWayEnum accessWay;

	//private Channel channel;
	private OpChannelVO opChannel;
	private boolean birthday = true;

	public boolean isBirthday() {
		return birthday;
	}

	public void setBirthday(boolean birthday) {
		this.birthday = birthday;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public List<? extends ProductPack> getPacks() {
		return packs;
	}

	public void setPacks(List<? extends ProductPack> packs) {
		this.packs = packs;
	}

	public MemberVO getMember() {
		return member;
	}

	public void setMember(MemberVO member) {
		this.member = member;
	}

	public AccessWayEnum getAccessWay() {
		return accessWay;
	}

	public void setAccessWay(AccessWayEnum accessWay) {
		this.accessWay = accessWay;
	}

	
	public OpChannelVO getOpChannel() {
		return opChannel;
	}

	public void setOpChannel(OpChannelVO opChannel) {
		this.opChannel = opChannel;
	}

	@Override
	public String toString() {
		return "OrderSnapshotDTO [orderId=" + orderId + ", packs=" + packs + ", couponId=" + couponId + ", member=" + member + ", accessWay=" + accessWay + ", channel=" + opChannel + "]";
	}

}
