/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.channelservice.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

/**
 * 订单服务费详情vo
 * 
 * @author WangYawei
 *
 */
public class OrderFeeVO {
	// 普通运费价格步骤
	private List<ServiceFeeStep> postageSteps;

	// 海淘运费价格步骤
	private List<ServiceFeeStep> overseasSteps;

	// 定制费价格步骤
	private List<ServiceFeeStep> customizeSteps;

	// 礼品卡价格步骤
	private List<ServiceFeeStep> giftCardSteps;

	// 权益
	private Integer interest;

	public List<ServiceFeeStep> getGiftCardSteps() {
		return giftCardSteps;
	}

	public void setGiftCardSteps(List<ServiceFeeStep> giftCardSteps) {
		this.giftCardSteps = giftCardSteps;
	}

	public Integer getInterest() {
		return interest;
	}

	public void setInterest(Integer interest) {
		this.interest = interest;
	}

	public List<ServiceFeeStep> getPostageSteps() {
		return postageSteps;
	}

	public void setPostageSteps(List<ServiceFeeStep> postageSteps) {
		this.postageSteps = postageSteps;
	}

	public List<ServiceFeeStep> getOverseasSteps() {
		return overseasSteps;
	}

	public void setOverseasSteps(List<ServiceFeeStep> overseasSteps) {
		this.overseasSteps = overseasSteps;
	}

	public List<ServiceFeeStep> getCustomizeSteps() {
		return customizeSteps;
	}

	public void setCustomizeSteps(List<ServiceFeeStep> customizeSteps) {
		this.customizeSteps = customizeSteps;
	}

	/**
	 * 运费
	 * 
	 * @return
	 */
	public BigDecimal getPostageFee() {
		BigDecimal postageFee = BigDecimal.ZERO;
		if (CollectionUtils.isNotEmpty(postageSteps)) {
			for (ServiceFeeStep postageStep : postageSteps) {
				postageFee = postageFee.add(postageStep.getPrice());
			}
		}
		return postageFee;
	}

	/**
	 * 定制费
	 * 
	 * @return
	 */
	public BigDecimal getCustomizeFee() {
		BigDecimal customizeFee = BigDecimal.ZERO;
		if (CollectionUtils.isNotEmpty(customizeSteps)) {
			for (ServiceFeeStep customizeStep : customizeSteps) {
				customizeFee = customizeFee.add(customizeStep.getPrice());
			}
		}
		return customizeFee;
	}

	/**
	 * 海淘费
	 * 
	 * @return
	 */
	public BigDecimal getOverseasFee() {
		BigDecimal overseasFee = BigDecimal.ZERO;
		if (CollectionUtils.isNotEmpty(overseasSteps)) {
			for (ServiceFeeStep overseasStep : overseasSteps) {
				overseasFee = overseasFee.add(overseasStep.getPrice());
			}
		}
		return overseasFee;
	}

	/**
	 * 服务费步骤（不含礼品卡）
	 * 
	 * @return
	 */
	public List<ServiceFeeStep> getServiceStep() {
		List<ServiceFeeStep> serviceSteps = new ArrayList();
		if (CollectionUtils.isNotEmpty(overseasSteps)) {
			serviceSteps.addAll(overseasSteps);
		}
		if (CollectionUtils.isNotEmpty(customizeSteps)) {
			serviceSteps.addAll(customizeSteps);
		}
		if (CollectionUtils.isNotEmpty(postageSteps)) {
			serviceSteps.addAll(postageSteps);
		}

		return serviceSteps;
	}

	/**
	 * 服务费步骤（含礼品卡）
	 * 
	 * @return
	 */
	public List<ServiceFeeStep> getServiceStepContainGift() {
		List<ServiceFeeStep> serviceSteps = new ArrayList();
		if (CollectionUtils.isNotEmpty(overseasSteps)) {
			serviceSteps.addAll(overseasSteps);
		}
		if (CollectionUtils.isNotEmpty(customizeSteps)) {
			serviceSteps.addAll(customizeSteps);
		}
		if (CollectionUtils.isNotEmpty(postageSteps)) {
			serviceSteps.addAll(postageSteps);
		}
		if (CollectionUtils.isNotEmpty(giftCardSteps)) {
			serviceSteps.addAll(giftCardSteps);
		}
		return serviceSteps;
	}
}
