package com.thebeastshop.pegasus.channelservice.model;

import java.util.List;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;

/**
 * 计算商品包折扣DTO
 * 
 * @author Paul-xiong
 *
 */
public class CalculateProductPackDTO {
	private List<? extends ProductPack> packs;
	private Long couponId;
	private MemberVO member;
	private AccessWayEnum accessWay;
	//private Channel channel;
	private OpChannelVO opChannel;
	private boolean birthday = true;   // 是否使用生日折扣标志

	public boolean isBirthday() {
		return birthday;
	}

	public void setBirthday(boolean birthday) {
		this.birthday = birthday;
	}

	public List<? extends ProductPack> getPacks() {
		return packs;
	}

	public void setPacks(List<? extends ProductPack> packs) {
		this.packs = packs;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public MemberVO getMember() {
		return member;
	}

	public void setMember(MemberVO member) {
		this.member = member;
	}

	public AccessWayEnum getAccessWay() {
		return accessWay;
	}

	public void setAccessWay(AccessWayEnum accessWay) {
		this.accessWay = accessWay;
	}

	

	public OpChannelVO getOpChannel() {
		return opChannel;
	}

	public void setOpChannel(OpChannelVO opChannel) {
		this.opChannel = opChannel;
	}

	@Override
	public String toString() {
		return "CalculateProductPackDTO [packs=" + packs + ", couponId=" + couponId + ", member=" + member + ", accessWay=" + accessWay + ", channel=" + opChannel + ", birthday=" + birthday + "]";
	}

}
