package com.thebeastshop.pegasus.channelservice.kafka.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.thebeastshop.pegasus.channelservice.constants.PegasusConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.thebeastshop.campaign.enums.RowStateEnum;
import com.thebeastshop.campaign.service.GroupBuyService;
import com.thebeastshop.campaign.vo.GroupBuyRecordVO;
import com.thebeastshop.campaign.vo.GroupBuyResultVO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.kit.kafka.consumer.KafkaConsumerListener;
import com.thebeastshop.course.service.FrontBeastCourseService;
import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.payment.dto.PRefundDTO;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;
import com.thebeastshop.payment.enums.PPaymentChannelGroupEnum;
import com.thebeastshop.payment.enums.PPaymentStatusEnum;
import com.thebeastshop.payment.enums.PTransTypeEnum;
import com.thebeastshop.payment.service.PPaymentService;
import com.thebeastshop.payment.vo.PKafkaTradeVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OrderTypeEnum;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;

/**
 * @author tianqi.zhang
 * @date 2017年12月26日
 * @description 订单支付
 */
@Component("orderPayHandler")
public class OrderPayHandler extends KafkaConsumerListener<PKafkaTradeVO> {
	private final Logger logger = LoggerFactory.getLogger(OrderPayHandler.class);

	private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();
	@Autowired
	private PPaymentService pPaymentService;

	@Autowired
	private GroupBuyService groupBuyService;

	private ExecutorService threadPool = Executors.newFixedThreadPool(10);

	@Autowired
	private FrontBeastCourseService frontBeastCourseService;

	@Autowired
	private EmailSendService emailSendService;

	// private static IMetrics metrics = MetricsManager.getMetrics();
	@Override
	public void processMessage(final String arg0, final PKafkaTradeVO arg1) {
		logger.info("订单支付消息处理,订单号:" + arg1.getOutTradeCode());

		threadPool.submit(new Runnable() {
			public void run() {

				// 团购
				// 如果该订单是支付成功时
				if (arg1.getStatus() != null && PPaymentStatusEnum.SUCCESS.getCode().equals(arg1.getStatus())) {

					Integer paymentType = -1;

					if (arg1.getPaymentChannel() != null) {

						//
						if (PPaymentChannelEnum.CASH.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_CASH;
						} else if (PPaymentChannelEnum.DEBIT_CARD.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_DEBIT_CARD;
						} else if (PPaymentChannelEnum.CREDIT_CARD.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_CREDIT_CARD;
						} else if (PPaymentChannelEnum.WEIXIN_MOBILE.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_WEIXIN;
						} else if (PPaymentChannelEnum.WEIXIN_MINI_PROGRAM.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_WEIXIN;
						} else if (PPaymentChannelEnum.ALIPAY_MOBILE.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.ALI_CROSS_BORDER_MOBILE.getCode()
								.equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.ALIPAY_DIRECT.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.TRANSFER.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_TRANSFER;
						} else if (PPaymentChannelEnum.YCK.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.PRE_DEPOSIT;
						} else if (PPaymentChannelEnum.YEZHU.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_PROPRIETOR;
						} else if (PPaymentChannelEnum.ALI_BANK.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.WEIXIN_SCAN.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_WEIXIN;
						} else if (PPaymentChannelEnum.ALIPAY_SCAN.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.WEIXIN_USER_SCAN.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_WEIXIN;
						} else if (PPaymentChannelEnum.ALIPAY_USER_SCAN.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.WEIXIN_OFFICIAL_ACCOUNT.getCode()
								.equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_WEIXIN;
						} else if (PPaymentChannelEnum.GIFT_CARD.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_GIFT_CARD;
						} else if (PPaymentChannelEnum.ALI_CROSS_BORDER_DIRECT.getCode()
								.equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.ALIPAY_WAP_DIRECT.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.ALI_WAP_CROSS_BORDER_DIRECT.getCode()
								.equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
						} else if (PPaymentChannelEnum.INTEGRAL.getCode().equals(arg1.getPaymentChannel())) {
							paymentType = PegasusConstants.Payment.TYPE_EXCHANGE;
						}

					}

					OpSalesOrder order = null;
					// 参团支付流程
					// 取订单信息
					logger.info("当前支付订单类型是：type={}", arg1.getTransType());
					Map<String, List<String>> groupMap = new HashMap<String, List<String>>();
					if (arg1.getTransType().equals(PTransTypeEnum.GROUP_PAY.getCode())) {
						logger.info("参团订单，进入参团逻辑");

						// 参团改状态
						ServiceResp<GroupBuyResultVO> resp = groupBuyService.updateRecordState(arg1.getOutTradeCode(),
								RowStateEnum.PAID.getId());

						if (!resp.isSuccess()) {
							logger.info("参团订单改状态失败 orderCode={},errMsg ={}", arg1.getOutTradeCode(), resp.getRespMsg());

							// 告诉支付撤销
							ServiceResp<Boolean> response = pPaymentService.cancel(arg1.getOutTradeCode());
							if (response.isFailure()) {
								logger.error("订单支付撤销失败：" + response.getRespMsg());
							}
							return;
						}

						GroupBuyResultVO orderGroupBuyResultVO = resp.getBean();

						// logger.info("剩余坑位 left={}",
						// orderGroupBuyResultVO.getLeftNumber());
						if (orderGroupBuyResultVO.getLeftNumber() == 1) {
							// logger.info("最后一单通知订单");

							List<String> codes = new ArrayList<>();
							for (GroupBuyRecordVO record : orderGroupBuyResultVO.getRecordVOS()) {
								logger.info("获取成团订单号 orderCode={}", record.getOrderCode());
								codes.add(record.getOrderCode());
							}
							groupMap.put(orderGroupBuyResultVO.getGroupId(), codes);

							logger.info("成团通知订单，groupId={}", orderGroupBuyResultVO.getGroupId());
						}

					} else {
						logger.info("不是参团订单，判断类型  支付渠道 channel={} ", arg1.getPaymentChannel());

						order = pcInstance.getOrderByCode(arg1.getOutTradeCode());

						if (order == null) {

							logger.info("不存在的订单：" + arg1.getOutTradeCode());
							return;
						}
						// 是拼团订时才去小飞哪里验证
						if (order.getOrderType() == OrderTypeEnum.ORDERTYPE_10.getCode()) {
							// 找小飞改状态
							ServiceResp<GroupBuyResultVO> resp = groupBuyService
									.updateRecordState(arg1.getOutTradeCode(), RowStateEnum.PAID.getId());
							if (resp.isSuccess()) {

								if (null == resp.getBean() || null == resp.getBean().getLeftNumber()) {
									logger.info("该订单是开团订单 orderCode={}", arg1.getOutTradeCode());
								} else {
									logger.info("参团订单更新状态成功 orderCode={}", arg1.getOutTradeCode());

									GroupBuyResultVO orderGroupBuyResultVO = resp.getBean();

									if (orderGroupBuyResultVO.getLeftNumber() == 1) {
										// logger.info("最后一单通知订单");

										List<String> codes = new ArrayList<>();
										for (GroupBuyRecordVO record : orderGroupBuyResultVO.getRecordVOS()) {
											logger.info("获取成团订单号 orderCode={}", record.getOrderCode());
											codes.add(record.getOrderCode());
										}
										groupMap.put(orderGroupBuyResultVO.getGroupId(), codes);

										logger.info("成团通知订单，groupId={}", orderGroupBuyResultVO.getGroupId());
									}

								}
							} else {
								logger.info("开团订单改状态失败 orderCode={},errMsg ={}", arg1.getOutTradeCode(),
										resp.getRespMsg());

								// 告诉支付撤销
								ServiceResp<Boolean> response = pPaymentService.cancel(arg1.getOutTradeCode());
								if (response.isFailure()) {
									logger.error("订单支付撤销失败：" + response.getRespMsg());
								}
								return;
							}

							// 野兽课堂
						} else if (order.getOrderType() == OrderTypeEnum.ORDERTYPE_13.getCode()) {
							// 如果是积分支付成功，暂不做处理
							if (PPaymentChannelEnum.INTEGRAL.getCode().equals(arg1.getPaymentChannel())) {
								logger.info("积分支付成功，暂不做处理:" + order.getCode());
								return;

							} else {

								// frontBeastCourseService.updateCourseReserveByOrderCode(order.getCode());

							}
						} else {
							if (PPaymentChannelEnum.INTEGRAL.getCode().equals(arg1.getPaymentChannel())
									&& order.getNeedToPayAmount().doubleValue() > 0) {

								logger.info("积分支付成功，暂不做处理:" + order.getCode());
								return;

							}

						}

					}

					try {

						if (order == null) {
							order = pcInstance.getOrderByCode(arg1.getOutTradeCode());

							if (order == null) {

								logger.info("不存在的订单：" + arg1.getOutTradeCode());
								return;
							}
						}

						// 订单已取消时，通知支付服务，进行退款处理
						if (order.getSalesOrderStatus() != null && order.getSalesOrderStatus() == 0) {
							logger.info(arg1.getOutTradeCode() + ":订单已取消，通知支付服务！");
							// 调用撤销方法
							PRefundDTO dto = new PRefundDTO();
							dto.setRefundChannel(PPaymentChannelGroupEnum.getEnumByCode(arg1.getPaymentChannel()));
							dto.setMemberId(arg1.getMemberId());
							dto.setAccessWay(AccessWayEnum.getEnumByCode(arg1.getAccessWay()));
							dto.setChannelCode(arg1.getChannelCode());
							dto.setOutTradeCode(arg1.getOutTradeCode());
							dto.setPaymentAmount(arg1.getPaymentAmount());
							dto.setTransType(PTransTypeEnum.ORDER_REFUND);
							ServiceResp<Boolean> response = pPaymentService.refund(dto);
							if (response.isFailure()) {
								logger.error("订单支付撤销失败：" + response.getRespMsg());
							}
						} else {
							logger.info(arg1.getOutTradeCode() + ":订单已支付，修改订单状态！");

							if (order.getOrderType() == OrderTypeEnum.ORDERTYPE_9.getCode()) {

								BigDecimal needToPay = order.getNeedToPayAmount();
								
								if (PPaymentChannelEnum.INTEGRAL.getCode().equals(arg1.getPaymentChannel())){
									needToPay = order.getPointOnLine();
								}
								
								if (arg1.getPaymentAmount().compareTo(needToPay) == 0) {
									boolean result = pcInstance.orderPay(arg1.getOutTradeCode(), paymentType,
											arg1.getPaymentAmount(), "", arg1.getThirdPartyTradeCode());
									if (result == false) {
										logger.error("订单支付消息处理失败！订单号：" + arg1.getOutTradeCode());
									} else {
										logger.info("订单支付消息处理成功！");
									}

								} else {
									logger.error("订单支付金额不相付！订单号：" + arg1.getOutTradeCode());
									logger.error("订单支付金额不相付！PaymentAmount：" + arg1.getPaymentAmount());
									logger.error("订单支付金额不相付！NeedToPayAmount：" + needToPay);
									// 异常通知邮件
									List<String> toAddressList = new ArrayList<>();
									toAddressList.add("tianqi.zhang@thebeastshop.com");
									EmailVO emailVO = new EmailVO();
									emailVO.setSubject("支付成功，更改订单状态异常");
									emailVO.setToAddressList(toAddressList);
									emailVO.setContent("订单号：" + arg1.getOutTradeCode() + ",PaymentAmount:"
											+ arg1.getPaymentAmount() + ",NeedToPayAmount:"
											+ order.getNeedToPayAmount());
									emailSendService.send(emailVO);

								}

							} else {
								if (arg1.getPaymentAmount().compareTo(order.getNeedToPayAmount()) == 0) {
									boolean result = pcInstance.orderPay(arg1.getOutTradeCode(), paymentType,
											arg1.getPaymentAmount(), "", arg1.getThirdPartyTradeCode());
									if (result == false) {
										logger.error("订单支付消息处理失败！订单号：" + arg1.getOutTradeCode());
									} else {
										logger.info("订单支付消息处理成功！");
									}
									if (order.getOrderType() == OrderTypeEnum.ORDERTYPE_13.getCode()) {

										logger.info("订单支付消息处理成功,通知课堂服务,订单号：" + arg1.getOutTradeCode());
										ServiceResp<Boolean> resp = frontBeastCourseService
												.updateCourseReserveByOrderCode(order.getCode());
										if (resp != null && resp.isFailure()) {
											logger.error("通知课堂服务理失败！errorMessage：" + resp.getRespMsg());
										}

									}
								} else {
									logger.error("订单支付金额不相付！订单号：" + arg1.getOutTradeCode());
									logger.error("订单支付金额不相付！PaymentAmount：" + arg1.getPaymentAmount());
									logger.error("订单支付金额不相付！NeedToPayAmount：" + order.getNeedToPayAmount());
									// 异常通知邮件
									List<String> toAddressList = new ArrayList<>();
									toAddressList.add("tianqi.zhang@thebeastshop.com");
									EmailVO emailVO = new EmailVO();
									emailVO.setSubject("支付成功，更改订单状态异常");
									emailVO.setToAddressList(toAddressList);
									emailVO.setContent("订单号：" + arg1.getOutTradeCode() + ",PaymentAmount:"
											+ arg1.getPaymentAmount() + ",NeedToPayAmount:"
											+ order.getNeedToPayAmount());
									emailSendService.send(emailVO);

								}
							}

							// metrics.record("beast.cs.order",
							// order.getNeedToPayAmount(), TagBuilder.create().
							// append("paymentType",order.getPaymentType()).
							// append("channelCode",order.getChannelCode()).append("orderType",order.getOrderType()).
							// append("crossBorder",order.getCrossBorderFlag()).build());
						}

						// 修改订单状态之后在统一处理当前团的所有订单
						if (groupMap.size() > 0) {
							boolean succ = pcInstance.updateGrouponOrderStatus(groupMap, true);
							logger.info("成团啦， 成团状态state={}", succ);
						}

					} catch (Exception e) {
						logger.error("订单支付消息处理失败！订单号：" + arg1.getOutTradeCode());

						logger.error("订单支付消息处理失败！错误信息：" + e.getMessage());
						logger.error("订单支付消息处理失败！错误信息：" + e);
					}

					logger.info("订单支付消息处理结束！");

				}
			}
		});

	}

}
