package com.thebeastshop.pegasus.channelservice.kafka.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.thebeastshop.campaign.vo.GroupBuyRecordVO;
import com.thebeastshop.campaign.vo.GroupBuyResultMsgVO;
import com.thebeastshop.kit.kafka.consumer.KafkaConsumerListener;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;

public class OrderGrouponHandler  extends KafkaConsumerListener<GroupBuyResultMsgVO>{
	private final Logger logger = LoggerFactory.getLogger(OrderPayHandler.class);

	private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();
	@Override
	public void processMessage(String arg0, GroupBuyResultMsgVO arg1) {

		logger.info("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@OrderGrouponSucessHandler,参数："+arg1.toString());


		if(arg1 != null && CollectionUtils.isNotEmpty(arg1.getRecordVOS())){
			Map<String,List<String>> groupMap = new HashMap<>();
			for(GroupBuyRecordVO groupBuyRecordVO:arg1.getRecordVOS()){
				List<String> orderList = groupMap.get(groupBuyRecordVO.getGroupId());
				if(orderList != null){
					logger.info("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@OrderGrouponSucessHandler,参数："+groupBuyRecordVO.getOrderCode());
					orderList.add(groupBuyRecordVO.getOrderCode());
					groupMap.put(groupBuyRecordVO.getGroupId(), orderList);
				}else{
					logger.info("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@OrderGrouponSucessHandler,参数："+groupBuyRecordVO.getOrderCode());
					orderList = new ArrayList<>();
					orderList.add(groupBuyRecordVO.getOrderCode());
					groupMap.put(groupBuyRecordVO.getGroupId(), orderList);
				}


			}

			pcInstance.updateGrouponOrderStatus(groupMap, arg1.getSuccess());

		}


	}

}
