package com.thebeastshop.pegasus.channelservice.interceptor;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.model.ChnserAccount;
import com.thebeastshop.pegasus.channelservice.service.ChnserAccountService;

public class ApiAuthInterceptor extends HandlerInterceptorAdapter {

    private static final Logger log = LoggerFactory.getLogger(ApiAuthInterceptor.class);

    private String apiPath;

    private Long expiredMinutes;

    private Boolean debug = false;


    private List<String> excludePathList = new ArrayList<String>();
    @Autowired
    private ChnserAccountService chnserAccountService;

    public Boolean getDebug() {
        return debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response,
                             Object handler) throws Exception {

        if (debug) {
            return true;
        }

        if (!needAuth(request.getServletPath())) {
            return true;
        }

        HandlerMethod handler2 = (HandlerMethod) handler;
//        ApiAuth apiAuth = handler2.getMethodAnnotation(ApiAuth.class);
        ApiAuth apiAuth = null;

 //       String errorCode;
        ErrorCode errorCode;
        if (apiAuth == null
                || (errorCode = auth(request)) == ErrorCode.OPERATION_OK) {
            return true;
        } else {
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/html;charset=UTF-8");
            OutputStream out = response.getOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, "utf-8"));
            pw.println(JSONObject.toJSON(JsonApiResult.ofErrorResult(errorCode.getCode(),errorCode.getMesage())));
            pw.flush();
            pw.close();
            return false;
        }

    }

    
    @Override
	public void postHandle(HttpServletRequest request,HttpServletResponse response, Object handler,ModelAndView modelAndView) throws Exception {
		super.postHandle(request, response, handler, modelAndView);
	}


	private ErrorCode auth(HttpServletRequest request) {
        String code = request.getParameter("CODE");
        String timestamp = request.getParameter("TIMESTAMP");
        String clientSign = request.getParameter("SIGN");
        
        if (StringUtils.isBlank(code) || StringUtils.isBlank(timestamp)
                || StringUtils.isBlank(clientSign)) {
            return ErrorCode.AUTHFAILED_MISS_PARAMS;
        }

        try {
            // 判断请求过期
            Long ts = Long.parseLong(timestamp);
            if (ts.longValue() < new Date().getTime() - expiredMinutes * 60 * 1000) {
                return ErrorCode.AUTHFAILED_TIMESTAMP_EXPIRED;
            }

            // 验签
            ChnserAccount account = chnserAccountService.findAvailableAccountByCode(code);//SpringWebUtil.getBean(ChnserAccountService.class, request).findAvailableAccountByCode(code);
            if (account == null) {
                return  ErrorCode.USER_LOGIN_FAILED;
            }

            SortedMap<String, String[]> paramMap = sortMapByKey(request.getParameterMap());
            StringBuilder sb = new StringBuilder(128);
            for (Map.Entry<String, String[]> e : paramMap.entrySet()) {
                if (!"SIGN".equals(e.getKey())) {
                    String k = e.getKey();
                    String[] _v = e.getValue();
                    String v = (_v != null && _v.length != 0) ? _v[0] : "";
                    sb.append(k).append("=").append(v).append("&");
                }
            }

            String unsign = sb.length() != 0 ? sb.substring(0, sb.length() - 1) : "";
            String signKey = account.getSignKey();
            signKey=unsign+signKey;
            String serverSign = DigestUtils.md5Hex(signKey);
          if (!clientSign.equals(serverSign)) {
                 return ErrorCode.AUTHFAILED_SIGN_ILLEGAL;
            }

        } catch (Exception e) {
            log.debug("", e);
            return ErrorCode.DEFAULT_EXCEPTION;
        }

        return ErrorCode.OPERATION_OK;
    }

    private SortedMap<String, String[]> sortMapByKey(Map parameterMap) {
        SortedMap<String, String[]> res = new TreeMap<String, String[]>(new MapKeyComparator());
        res.putAll(parameterMap);
        return res;
    }

    private boolean needAuth(String path) {
        if (!path.startsWith(apiPath)) {
            return false;
        }

        boolean res = true;
        for (int i = 0; i < excludePathList.size(); i++) {
            String excludePath = excludePathList.get(i);
            if (excludePath.equals(path)
                    || (excludePath.endsWith("/*") && path.startsWith(excludePath.substring(0,
                    excludePath.length() - 1)))) {
                res = false;
                break;
            }
        }
        return res;
    }

    public void setExcludePathList(List<String> excludePathList) {
        this.excludePathList = excludePathList;
    }

    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public void setExpiredMinutes(Long expiredMinutes) {
        this.expiredMinutes = expiredMinutes;
    }

    private class MapKeyComparator implements Comparator<String> {
        @Override
        public int compare(String str1, String str2) {
            return str1.compareTo(str2);
        }
    }

}
