/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.channelservice.handler;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.wms.exception.WarehouseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongEntityException;
import com.thebeastshop.support.exception.WrongStateException;

/**
 * @author fs
 * @version $Id: ApiExceptionHandler.java, v 0.1 2015-08-05 16:31
 *          把BusinessException 转成json 返回
 */
@ControllerAdvice
public class ApiExceptionHandler extends ResponseEntityExceptionHandler {

	private final Logger logger = LoggerFactory.getLogger(ApiExceptionHandler.class);

	@ExceptionHandler({ Throwable.class })
	protected ResponseEntity<Object> handleInvalidRequest(Exception e, WebRequest request) {

		logger.error("====出错了e={}", e);
		e.printStackTrace();
		HttpHeaders headers = new HttpHeaders();
		headers.setContentType(MediaType.APPLICATION_JSON);
		List<Charset> charSets = new ArrayList<Charset>();
		charSets.add(Charset.forName("UTF-8"));
		headers.setAcceptCharset(charSets);
		if (e instanceof ChannelException) {
			return handleExceptionInternal(e,
					JsonApiResult.ofErrorResult(((ChannelException) e).getErrorCode(), e.getMessage()), headers,
					HttpStatus.OK, request);
		} else if (e instanceof WrongArgException) {
			return handleExceptionInternal(e, JsonApiResult.ofErrorResult(400, e.getMessage()), headers, HttpStatus.OK,
					request);
		} else if (e instanceof WrongEntityException) {
			return handleExceptionInternal(e, JsonApiResult.ofErrorResult(400, e.getMessage()), headers, HttpStatus.OK,
					request);
		} else if (e instanceof WrongStateException) {
			return handleExceptionInternal(e, JsonApiResult.ofErrorResult(409, e.getMessage()), headers, HttpStatus.OK,
					request);
		} else if (e instanceof WarehouseException){
			return handleExceptionInternal(e, JsonApiResult.ofErrorResult(400, e.getMessage()), headers, HttpStatus.OK,
					request);
		} else if (e instanceof com.thebeastshop.pegasus.service.operation.exception.ChannelException){
			return handleExceptionInternal(e, JsonApiResult.ofErrorResult(400, e.getMessage()), headers, HttpStatus.OK,
					request);
		}

		return handleExceptionInternal(e,
				JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), e.getMessage()), headers,
				HttpStatus.OK, request);
	}
}
