package com.thebeastshop.pegasus.channelservice.enums;

import com.thebeastshop.support.mark.State;

/**
 * @author Eric.Lou
 * @version $Id: OrderType.java, v 0.1 2016-05-26 下午4:00
 */
public enum OrderType implements State {
    SALES(1, "渠道销售单"),
    EXCHANGE(2, "渠道换货单"),
    GROUP(3, "集团订单"),
    GIFT(11, "礼品订单"),
    SAMPLE(12, "样品订单"),
    ;

    public final int id;
    public final String name;

    OrderType(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

}
