/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.channelservice.enums;

import com.thebeastshop.support.mark.State;

/**
 * @author Eric.Lou
 * @version $Id: PackageStatus.java, v 0.1 2016-05-27 下午1:44
 */
public enum  OrderParcelState implements State{
    UNSENT_CANCEL(-1, "未发货取消"),
    INIT(10, "初始状态"),
    INITIAL_HANG(1, "初始挂起"),
    MAKING_HANG(2, "制单挂起"),
    WAITING_MAKE(11, "待制单"),
    WAITING_SEND(12, "待发货"),
    WAITING_RECEIVE(13, "待收货"),
    ALREADY_RECEIVE(14, "已收货"),
    ALREADY_DELIVER(15, "已发货"),
    ;

    public final int id;
    public final String name;

    OrderParcelState(final int id, final String name) {
        this.id = id;
        this.name = name;
    }


    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
