package com.thebeastshop.pegasus.channelservice.enums;

import com.thebeastshop.support.mark.State;

/**
 * @author Eric.Lou
 * @version $Id: CardType.java, v 0.1 2016-05-27 下午1:41
 */
public enum CardType implements State {
    NULL(0, "不需要"),
    BLANK(1, "空白"),
    WRITE(2, "代写"),
    ;

    public final int id;
    public final String name;

    CardType(final int id, final String name) {
        this.id = id;
        this.name = name;
    }


    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

}
