package com.thebeastshop.pegasus.channelservice.convert;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.model.ScRequestPack;
import com.thebeastshop.cart.model.ScUserSingleCustomization;
import com.thebeastshop.cart.support.ScDeliveryVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.cart.DeliveryVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;

/**
 * Author : feilong.gao
 * email : feilong.gao.thebeastshop.com
 * date : 2019/12/31
 */
public class ScConvert {


    /**
     * 购物车对象转换为support对象
     *
     * @param sources
     * @return
     */
    public static List<ScRequestPack> convert2ScRequestPack(List<RequestPack> sources) {
        List<ScRequestPack> targets = Lists.newArrayList();
        if(CollectionUtils.isEmpty(sources)) return targets;
        for (RequestPack source : sources) {
            ScRequestPack target = new ScRequestPack();
            target.setId(source.getId());
            target.setSource(CartPackSourceEnum.getEnumByCode(source.getSource().getId()));
            target.setCount(source.getCount());
            target.setSpvId(source.getSpvId());
            target.setBindValue(source.getBindValue());
            List<ScUserSingleCustomization> customizations = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(source.getCustomizes())) {
                for (UserSingleCustomization customize : source.getCustomizes()) {
                    ScUserSingleCustomization userSingleCustomization = new ScUserSingleCustomization();
                    userSingleCustomization.setCode(customize.getCode());
                    userSingleCustomization.setValue(customize.getValue());
                    userSingleCustomization.setName(customize.getName());
                    customizations.add(userSingleCustomization);
                }

            }
            target.setCustomizes(customizations);
            targets.add(target);
        }
        return targets;
    }

    /**
     * 购物车对象转换为support对象
     *
     * @param sources
     * @return
     */
    public static List<RequestPack> convert4ScRequestPack(List<ScRequestPack> sources) {
        List<RequestPack> targets = Lists.newArrayList();
        if(CollectionUtils.isEmpty(sources)) return targets;
        for (ScRequestPack source : sources) {
            RequestPack target = new RequestPack();
            target.setId(source.getId());
            target.setSource(CartPackSource.valueOf(source.getSource().name()));
            target.setCount(source.getCount());
            target.setSpvId(source.getSpvId());
            target.setBindValue(source.getBindValue());
            List<UserSingleCustomization> customizations = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(source.getCustomizes())) {
                for (ScUserSingleCustomization customize : source.getCustomizes()) {
                    UserSingleCustomization userSingleCustomization = new UserSingleCustomization();
                    userSingleCustomization.setCode(customize.getCode());
                    userSingleCustomization.setValue(customize.getValue());
                    userSingleCustomization.setName(customize.getName());
                    customizations.add(userSingleCustomization);
                }

            }
            target.setCustomizes(customizations);
            targets.add(target);
        }
        return targets;
    }

    /**
     * 购物车对象转换为support对象
     *
     * @param sources
     * @return
     */
    public static List<ScDeliveryVO> convert2ScDelivery(List<DeliveryVO> sources) {
        List<ScDeliveryVO> targets = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sources)) {
            for (DeliveryVO source : sources) {
                ScDeliveryVO target = new ScDeliveryVO();
                target.setType(source.getType());
                target.setDate(source.getDate());
                target.setCount(source.getCount());
                target.setFee(source.getFee());
                targets.add(target);
            }
        }
        return targets;
    }


    /**
     * 购物车对象转换为support对象
     *
     * @param sources
     * @return
     */
    public static List<DeliveryVO> convert4ScDelivery(List<ScDeliveryVO> sources) {
        List<DeliveryVO> targets = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sources)) {
            for (ScDeliveryVO source : sources) {
                DeliveryVO target = new DeliveryVO();
                target.setType(source.getType());
                target.setDate(source.getDate());
                target.setCount(source.getCount());
                target.setFee(source.getFee());
                targets.add(target);
            }
        }
        return targets;
    }
}
