package com.thebeastshop.pegasus.channelservice.controller.wechat;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.controller.product.ProductController;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value = "/api/index-weapp")
public class WxIndexController {
    private Logger logger = LoggerFactory.getLogger(ProductController.class);

    private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();


    @RequestMapping(value = "/sendWeiXinTemplateMessage")
    @ResponseBody
    public JsonApiResult sendWeiXinTemplateMessage(@RequestParam("CODE") String code,
                                                   @RequestParam("DATA") String data) {

        JSONObject jsonData = JSONObject.parseObject(data);
        String openId = jsonData.getString("openId");
        String templateId = jsonData.getString("templateId");
        String url = jsonData.getString("url");
        String data2 = jsonData.getString("data");
        String memberCode = jsonData.getString("memberCode");

        logger.info("发送   微信 信息  toUser={},templateId={},url={},data={}", openId, templateId, url, data2);
        Boolean re = false;
        try {
            re = pcInstance.sendWeiXinTempleteMessage(openId, templateId, url, data2, memberCode);
            return JsonApiResult.ofSuccessResult(re);
        } catch (Exception e) {
            logger.info("错误 r={}", e);
            return JsonApiResult.ofSuccessResult(re);
        }

    }

}
