package com.thebeastshop.pegasus.channelservice.controller.website.user;


import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.common.utils.ValidationUtil;
import com.thebeastshop.message.vo.SingleSmsTemplateVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.dto.ChangePasswdDTO;
import com.thebeastshop.member.dto.LoginDTO;
import com.thebeastshop.member.dto.MemberLoginQueryCondDTO;
import com.thebeastshop.member.dto.RegisterDTO;
import com.thebeastshop.member.dto.SimilarMemberDTO;
import com.thebeastshop.member.dto.VerifyMobileDTO;
import com.thebeastshop.member.enums.BirthdayAddTypeEnum;
import com.thebeastshop.member.enums.ConstellationTypeEnum;
import com.thebeastshop.member.enums.DegreeTypeEnum;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.RegisterSourceEnum;
import com.thebeastshop.member.service.MemberLoginQueryService;
import com.thebeastshop.member.service.MemberMergeTaskService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.vo.MemberLoginVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.member.vo.VerifiedVO;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartInterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.interest.InterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.website.MemberAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.website.user.UserCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.website.user.UserEditVO;
import com.thebeastshop.pegasus.channelservice.vo.website.user.UserQueryVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;

@Controller
@RequestMapping("/api/website/user")
public class UserController {
	private final static Logger log = LoggerFactory.getLogger(UserController.class);
	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();

	private final static String INTERESTS_REGIESTER = "57";//注册发权益的权益id
	@Autowired
	private MemberService memberService;
	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private MemberLoginQueryService memberLoginQueryService;
	@Autowired
	MemberAdapter memberAdapter;

	@Autowired
	private MsgSendService msgSendService;

	/***
	 * 获取星座的id
	 * @return
	 */
	private Integer getConstellationId(String constellationStr){
		for(ConstellationTypeEnum e:ConstellationTypeEnum.values()){
			if(e.getName_en().equalsIgnoreCase(constellationStr)){
				return e.getCode();
			}
		}
		return ConstellationTypeEnum.UNKNOWN.getCode();
	}
	
	/***
	 * 获取学历id
	 * @param degreeStr
	 * @return
	 */
	private Integer getDsgreeId(String degreeStr){
		for(DegreeTypeEnum e:DegreeTypeEnum.values()){
			if(e.getName_en().equals(degreeStr)){
				return e.getCode();
			} 
		}
		return DegreeTypeEnum.OTHER.getCode();
	}
	

	@Autowired
	private InterestAdapter interestAdapter;//权益servcie
	@Autowired
	private CartInterestAdapter cartInterestAdapter;//权益购物车service

	/***
	 * 用户登录接口
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/user/login
	 */
	@ApiAuth
	@RequestMapping(value="/login")
	@ResponseBody
	public JsonApiResult login(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject json = JSONObject.parseObject(data);
		String userName = json.getString("username");
		String password = json.getString("password");
		if (StringUtils.isBlank(userName) || StringUtils.isBlank(password)) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		Integer loginType = getMemberType(userName);
		if (loginType < 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_NOT_EXIST.getCode(), ErrorCode.USER_LOGIN_NOT_EXIST.getMesage());
		}

		LoginDTO loginVO = new LoginDTO();
		loginVO.setLoginId(userName);
		loginVO.setPasswd(password);
		loginVO.setLoginType(loginType);
		loginVO.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<MemberVO> resp = memberService.login(loginVO);
		if (null == resp || !resp.isSuccess()) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), resp != null ? resp.getRespMsg() : ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		UserQueryVO userVO = memberAdapter.common2website(resp.getBean(), loginType);

		return JsonApiResult.ofSuccessResult(userVO);
	}

	/***
	 * 手机用户注册
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/user/mobile/reg
	 */
	@ApiAuth
	@RequestMapping(value="/mobile/register")
	@ResponseBody
	public JsonApiResult mobileRegister(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		UserCreateVO userCreateVO=JSONObject.parseObject(data,UserCreateVO.class);
		RegisterDTO memberRegisterVO = new RegisterDTO();
		memberRegisterVO.setGender(Integer.valueOf(userCreateVO.getSex()));
		memberRegisterVO.setMobile(userCreateVO.getMobile());
		memberRegisterVO.setLoginType(LoginTypeEnum.MOBILE.getCode());
		memberRegisterVO.setNickName(userCreateVO.getName());
		memberRegisterVO.setPassword(userCreateVO.getPassword());
		memberRegisterVO.setRegisterSource(RegisterSourceEnum.PC.getCode());
		memberRegisterVO.setTitle(userCreateVO.getTitle());
		memberRegisterVO.setLoginId(userCreateVO.getMobile());
		memberRegisterVO.setBirthday(userCreateVO.getBirthday());
		memberRegisterVO.setChannelCode(code);
		memberRegisterVO.setAccessWay(AccessWayEnum.PC.getCode());
		memberRegisterVO.setMobileCode(userCreateVO.getAreaCode());
		ServiceResp<MemberVO> resp = memberService.register(memberRegisterVO);
		if (resp == null || !resp.isSuccess()) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					resp != null ? resp.getRespMsg() : ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		MemberVO result = resp.getBean();
		UserQueryVO userVO = memberAdapter.common2website(result);
		// 发送权益
		try {
			if (ifInterstisRegister()) {
				InterestGoodsGetVO interestGoodsGetVO = interestAdapter.receiveInterest(userVO.getPartner_id(),
						INTERESTS_REGIESTER);
				boolean flag = cartInterestAdapter.saveInterest2Cart(userVO.getPartner_id(), interestGoodsGetVO);
				if (!flag) {
					log.error("注册发送权益购物车失败 权益id={},会员id={}", INTERESTS_REGIESTER, userVO.getPartner_id());
				}
			}
		} catch (Exception e) {
			log.error("注册发送权益失败 e={}权益id={},会员id={}", e, INTERESTS_REGIESTER, userVO.getPartner_id());
		}
		return JsonApiResult.ofSuccessResult(userVO);
	}

	private Boolean ifInterstisRegister(){
		long beginAt = 1497599880000L;
		//long beginAt = 1493963114727L;
		long endAt  = 1498147199000L;
		long nowAt = System.currentTimeMillis();
		if(nowAt >= beginAt && nowAt <= endAt){
			return true;
		}
		return false;
	}

	/***
	 * 更新用户信息接口
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/user/update
	 */
	@ApiAuth
	@RequestMapping(value="/update")
	@ResponseBody
	public JsonApiResult update(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		UserEditVO userEditVO=JSONObject.parseObject(data,UserEditVO.class);
		MemberVO memberUpdateVO=new MemberVO();
		memberUpdateVO.setAddress(userEditVO.getStreet());
		memberUpdateVO.setConstellation(getConstellationId(userEditVO.getConstellation()));
		memberUpdateVO.setDegree(getDsgreeId(userEditVO.getDegree()));
		memberUpdateVO.setId(userEditVO.getPartner_id());
		memberUpdateVO.setMobile(userEditVO.getMagento_mobile());
		memberUpdateVO.setNickName(userEditVO.getMagento_name());
		memberUpdateVO.setDistrictId(userEditVO.getDistrict_id());
		memberUpdateVO.setJob(userEditVO.getProfession());
		memberUpdateVO.setTitle(userEditVO.getTitle());
		memberUpdateVO.setZipCode(userEditVO.getZip());
		memberUpdateVO.setPhone(userEditVO.getMagento_phone());
		memberUpdateVO.setBirthday(userEditVO.getBirthday());
		memberUpdateVO.setBirthdayAddTime(new Date());
		memberUpdateVO.setBirthdayAddSource(BirthdayAddTypeEnum.PC.getCode());
		ServiceResp<Object> resp = memberService.modifyMember(memberUpdateVO);
		if(resp!=null && resp.isSuccess()){
			return JsonApiResult.ofSuccessResult(true);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
	}
	
	/***
	 * 根据用户id查询用户信息接口
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/user/info
	 */
	@ApiAuth
	@RequestMapping(value="/info")
	@ResponseBody
	public JsonApiResult userInfo(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		Long memberId=jsonData.getLong("partner_id");
		if(memberId==null||memberId<1){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		MemberVO memberVO = memberQueryService.getById(memberId);
		if(memberVO==null){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		UserQueryVO userVO=memberAdapter.common2website(memberVO);
		return JsonApiResult.ofSuccessResult(userVO);
	}
	
	/***
	 * 邮件账户重置密码验证链接
	 * @param code
	 * @param data
	 * @returgu
	 * 对应 /beast_site/mail/notice/resetpwd
	 */
	@ApiAuth
	@RequestMapping(value="/mail/resetpwd/link")
	@ResponseBody
	public JsonApiResult emailRestpwdLink(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String email=jsonData.getString("email");
		String emailContent=jsonData.getString("email_content");
		if(StringUtils.isBlank(email)||StringUtils.isBlank(emailContent)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		
		if(pcInstance.sendMail(email, emailContent)){
		    return JsonApiResult.ofSuccessResult(true);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}
	
	/***
	 * 邮件账户重置密码
	 * @param code
	 * @param data
	 * @return
	 * 对应 /beast_site/mail/resetpwd
	 */
	@ApiAuth
	@RequestMapping(value="/mail/resetpwd")
	@ResponseBody
	public JsonApiResult emailRestpwd(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String email=jsonData.getString("email");
		String newPwd=jsonData.getString("new_password");
		if(StringUtils.isBlank(email)||StringUtils.isBlank(newPwd)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		ChangePasswdDTO dto = new ChangePasswdDTO();
		dto.setLoginType(LoginTypeEnum.EMAIL.getCode());
		dto.setLoginId(email);
		dto.setNewPasswd(newPwd);
		dto.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<Boolean> resp = memberService.changePasswd(dto);
		if(resp != null && resp.isSuccess()){
			return JsonApiResult.ofSuccessResult(resp.getBean());
		}
		
		
		if (resp != null) {
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), resp.getRespMsg());
		}
		
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}
	
	
	/***
	 * 编辑信息 根据旧密码。重置密码 
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/user/resetpwd
	 */
	@ApiAuth
	@RequestMapping(value="/resetpwd")
	@ResponseBody
	public JsonApiResult restPwd(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String loginId=jsonData.getString("account");
		String oldPwd=jsonData.getString("old_password");
		String newPwd=jsonData.getString("new_password");
		if(StringUtils.isBlank(loginId)||StringUtils.isBlank(oldPwd)||StringUtils.isBlank(newPwd)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		Integer memberType=getMemberType(loginId);
		if(memberType !=-1){
			ChangePasswdDTO dto = new ChangePasswdDTO();
			dto.setLoginType(memberType);
			dto.setLoginId(loginId);
			dto.setOldPasswd(oldPwd);
			dto.setNewPasswd(newPwd);
			dto.setAccessWay(AccessWayEnum.PC.getCode());
			ServiceResp<Boolean> resp = memberService.changePasswd(dto);
			if(resp != null && resp.isSuccess() && resp.getBean()){
				return JsonApiResult.ofSuccessResult(true);
			}
			
			if (resp != null) {
				return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), resp.getRespMsg());
			}
		}
		
		
	
		return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
	}
	
	/***
	 * 根据手机号。重置密码 
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/user/mobile/resetpwd
	 */
	@ApiAuth
	@RequestMapping(value="/mobile/resetpwd")
	@ResponseBody
	public JsonApiResult mobileResetpwd(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String mobile=jsonData.getString("mobile");
		String newPwd=jsonData.getString("new_password");
		if(StringUtils.isBlank(mobile)||StringUtils.isBlank(newPwd)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		ChangePasswdDTO dto = new ChangePasswdDTO();
		dto.setLoginType(LoginTypeEnum.MOBILE.getCode());
		dto.setLoginId(mobile);
		dto.setNewPasswd(newPwd);
		dto.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<Boolean> resp = memberService.changePasswd(dto);
		if(resp != null && resp.isSuccess() && resp.getBean()){
			// 注册成功发送短信通知
			SingleSmsTemplateVO smsTemplateVO  = new SingleSmsTemplateVO();
			smsTemplateVO.setMsgTo(mobile);
			Map<String, Object> params = new HashMap<String, Object>();
	        params.put("passwd", newPwd);
			smsTemplateVO.setTemplateName("PASSWD_EDIT");
			smsTemplateVO.setParams(params);
			smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
			smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
			msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));
	    	return JsonApiResult.ofSuccessResult(true);
	    }
		
		if(resp!=null){
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), resp.getRespMsg());
		}
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}
	
	/***
	 *微博登陆
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/user/weibo/login
	 */
	@ApiAuth
	@RequestMapping(value="/weibo/login")
	@ResponseBody
	public JsonApiResult weiboLogin(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String weiboId=jsonData.getString("wb_id");
		if(StringUtils.isBlank(weiboId)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		LoginDTO loginVO = new LoginDTO();
		loginVO.setLoginId(weiboId);
		loginVO.setLoginType(LoginTypeEnum.WEIBO.getCode());
		loginVO.setChannelCode(code);
		loginVO.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<MemberVO> resp = memberService.login(loginVO);
		if (null == resp ) {
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
		}
		if (!resp.isSuccess()) {
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), resp.getRespMsg());
		}
		
		
		 UserQueryVO userVO=memberAdapter.common2website(resp.getBean());
		return JsonApiResult.ofSuccessResult(userVO);
	}
	
	/***
	 * 根据用户登陆名称，返回用户类型,只有手机用户和邮箱用户，可以根据旧密码，修改新密码
	 * @param loginId
	 * @return
	 */
	private Integer getMemberType(String loginId){
		if(ValidationUtil.isEmail(loginId)){
			return LoginTypeEnum.EMAIL.getCode();
		}
		if(ValidationUtil.isMobile(loginId)){
			return LoginTypeEnum.MOBILE.getCode();
		}
		return -1;
	}
	
	/***
	 *微信登陆
	 * @param code
	 * @param data
	 * @return
	 * 
	 */
	@ApiAuth
	@RequestMapping(value="/weixin/login")
	@ResponseBody
	public JsonApiResult weixinLogin(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		log.info("weixin.login.data:"+data);
		JSONObject jsonData=JSONObject.parseObject(data);
		String weixinId=jsonData.getString("wxId");
		String nickName=jsonData.getString("nickName");
		String unionId = jsonData.getString("unionId");
		
		if("null".equals(unionId)){
			unionId = null;
		}
		
		if(StringUtils.isBlank(weixinId)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		if(StringUtils.isBlank(nickName)){
			nickName="微信用户";
		}
		Boolean re = false;
		// 通过weixinId查找账号
		MemberLoginQueryCondDTO cond = new MemberLoginQueryCondDTO();
		cond.setLoginId(weixinId);
		List<MemberLoginVO> list = memberLoginQueryService.getByCond(cond);
		if (CollectionUtils.isEmpty(list)) {
			if (StringUtils.isNotBlank(unionId)) {
				// 通过unionId查找账号
				cond = new MemberLoginQueryCondDTO();
				cond.setUnionId(unionId);
				list = memberLoginQueryService.getByCond(cond);
				if (CollectionUtils.isEmpty(list)) {
					re = true;
				}
			} else {
				re = true;
			}
		}
		// ************************************
		LoginDTO loginVO = new LoginDTO();
		loginVO.setLoginId(weixinId);
		loginVO.setLoginType(LoginTypeEnum.WEIXIN.getCode());
		loginVO.setUnionId(unionId);
		loginVO.setNickName(nickName);
		loginVO.setChannelCode(code);
		loginVO.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<MemberVO> resp = memberService.login(loginVO);
		if (null == resp || !resp.isSuccess()) {
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
		}
		MemberVO memberVO = resp.getBean();
		UserQueryVO userVO = memberAdapter.common2website(memberVO);
		//发送权益
		try {
			if(ifInterstisRegister() && re) {
				InterestGoodsGetVO interestGoodsGetVO = interestAdapter.receiveInterest(userVO.getPartner_id(), INTERESTS_REGIESTER);
				boolean flag = cartInterestAdapter.saveInterest2Cart(userVO.getPartner_id(), interestGoodsGetVO);
				if (!flag) {
					log.error("注册发送权益购物车失败 权益id={},会员id={}", INTERESTS_REGIESTER, userVO.getPartner_id());
				}
			}
		}catch (Exception e){
			log.error("注册发送权益失败 e={}权益id={},会员id={}",e,INTERESTS_REGIESTER, userVO.getPartner_id());
		}
		return JsonApiResult.ofSuccessResult(userVO);
	}
	
	/***
	 * 查询类似是同一个用户的会员
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/similarMember")
	@ResponseBody
	public JsonApiResult similarMember(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject json=JSONObject.parseObject(data);
		String loginId=json.getString("loginId");
		if(StringUtils.isBlank(loginId)){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		
		Integer loginType = getMemberType(loginId);
		if(loginType<0){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		SimilarMemberDTO dto = new SimilarMemberDTO();
		dto.setLoginId(loginId);
		dto.setLoginType(loginType);
		dto.setChannelCode(code);
		dto.setAccessWay(AccessWayEnum.PC.getCode());
		MemberVO memberVo = memberQueryService.getSimilarMember(dto);
		if(null==memberVo){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		 UserQueryVO userVO=memberAdapter.common2website(memberVo);
		 return JsonApiResult.ofSuccessResult(userVO);
	}
	
	/***
	 * 查询类似是同一个用户的会员
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/getMemberByLoginId")
	@ResponseBody
	public JsonApiResult getMemberByLoginId(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject json=JSONObject.parseObject(data);
		String loginId=json.getString("loginId");
		if(StringUtils.isBlank(loginId)){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		Integer loginType=json.getInteger("loginType");
		 if(loginType==null){
			 loginType= getMemberType(loginId); 
		 } 
		if(loginType<0){
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		MemberVO memberVO = null;
        MemberLoginQueryCondDTO dto = new MemberLoginQueryCondDTO();
        dto.setLoginId(loginId);
        dto.setLoginType(loginType);
        List<MemberLoginVO> list = memberLoginQueryService.getByCond(dto);
        if(CollectionUtils.isNotEmpty(list)){
       	 MemberLoginVO memberLogin=list.get(0);
       	 memberVO = memberQueryService.getById(memberLogin.getMemberId());
        }
		if(null==memberVO){
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		 UserQueryVO userVO=memberAdapter.common2website(memberVO);
		 return JsonApiResult.ofSuccessResult(userVO);
	}
	
	/***
	 * 会员绑定手机号
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/bindCellphone")
	@ResponseBody
	public JsonApiResult bindCellphone(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		JSONObject json = JSONObject.parseObject(data);
		Long memberId = json.getLong("memberId");
		String cellphone = json.getString("cellphone");
		if (memberId == null || StringUtils.isBlank(cellphone)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					(ErrorCode.PARAMS_ILLEGAL.getMesage()));
		}
		VerifyMobileDTO dto = new VerifyMobileDTO();
		dto.setMemberId(memberId);
		dto.setVerifiedMobile(cellphone);
		dto.setChannelCode(code);
		dto.setAccessWay(AccessWayEnum.PC.getCode());
		ServiceResp<VerifiedVO> resp = memberService.verifyMobile(dto);
		if (null == resp || !resp.isSuccess()) {
			return JsonApiResult.ofSuccessResult(true);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), (ErrorCode.PARAMS_ILLEGAL.getMesage()));
	}
}

