package com.thebeastshop.pegasus.channelservice.controller.website.user;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.member.service.MemberAccodeService;
import com.thebeastshop.member.vo.MemberAccodeVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;

/**
 * create by com.thebeastshop.pegasus.channelservice.controller.website.user trunk :author lijing
 * User:lijing
 * DATE : 2017/3/15
 * TIME : 14:30
 * trunk.
 */
@Controller
@RequestMapping("/api/website/useraccode")
public class UserAccodeController {
    /**
     * 日志
     */
    private final static Logger logger = LoggerFactory.getLogger(UserAccodeController.class);

    @Autowired
    private MemberAccodeService memberAccodeService;

    /***
     * 保存用户accode
     * @param code
     * @param data
     * @return
     */
    @RequestMapping(value="/saveMemberAccode")
    @ResponseBody
    public JsonApiResult login(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
        logger.info("保存会员 的accode data={}",data);
        try {
            JSONObject json = JSONObject.parseObject(data);
            String memberCode = json.getString("memberCode");
            String acCode = json.getString("acCode");
            Integer channelType = json.getInteger("channelType");

            Boolean fa = false;

            if (StringUtils.isBlank(memberCode) || StringUtils.isBlank(acCode) || null == channelType) {
                return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), ErrorCode.USER_LOGIN_FAILED.getMesage());
            }

            MemberAccodeVO memberAccode = new MemberAccodeVO();
            memberAccode.setMemberCode(memberCode);
            memberAccode.setAcCode(acCode);
            memberAccode.setChannel(channelType);
            fa = memberAccodeService.create(memberAccode);

            if (fa) {
                return JsonApiResult.ofSuccessResult(true);
            } else {
                return JsonApiResult.ofErrorResult(2,"保存信息错误");
            }
        }catch(Exception e){
            logger.error("保存会员accode 报错={}", e);
            return JsonApiResult.ofErrorResult(1,"系统错误");

        }
    }
}
