package com.thebeastshop.pegasus.channelservice.controller.website.sms;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;

@Controller
@RequestMapping("/api/website/sms")
public class SMSController {
	
	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();
	/***
	 * 注册时发送验证码 
	 * @param code
	 * @param data
	 * @return
	 * /beast_site/mobile/checkreg
	 */
	@ApiAuth
	@RequestMapping(value="/regcode")
	@ResponseBody
	public JsonApiResult mobileRegister(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String mobile=jsonData.getString("mobile");
		String codeStr=jsonData.getString("code");
		if(StringUtils.isBlank(mobile)||StringUtils.isBlank(codeStr)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
	    Boolean result=pcInstance.sendSms(mobile, codeStr);
	    if(result){
	    	return JsonApiResult.ofSuccessResult(true);
	    }
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}

	/***
	 * 根据手机号，发送短信
	 * @param code
	 * @param data
	 * @return
	 * 对应/beast_site/mobile/sendsms
	 */
	@ApiAuth
	@RequestMapping(value="/send")
	@ResponseBody
	public JsonApiResult sendMsg(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		JSONObject jsonData=JSONObject.parseObject(data);
		String mobile=jsonData.getString("mobile");
		String content=jsonData.getString("content");
		if(StringUtils.isBlank(mobile)||StringUtils.isBlank(content)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
	    Boolean result=	pcInstance.sendSms(mobile, content);
	    if(result){
	    	return JsonApiResult.ofSuccessResult(true);
	    }
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}
	
}
