package com.thebeastshop.pegasus.channelservice.controller.website.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.pegasus.channelservice.constants.PegasusConstants;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.website.OrderAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.website.order.OrderCreateResponseVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.OrderCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.OrderQueryVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.OrderVO;
import com.thebeastshop.pegasus.channelservice.vo.website.order.SyncOrderPayStatusVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;

/***
 * 订单接口
 *
 * @author fs
 */
@Controller
@RequestMapping("/api/website/order")
public class OrderController {

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private OrderAdapter orderAdapter;
    private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

    /***
     * 订单创建接口
     *
     * @param code 渠道编码
     * @param data 业务参数
     * @return 对应原/beast_site/order/confirm
     * @throws Exception 
     */
//    @ApiAuth
//    @RequestMapping("/create")
//    @ResponseBody
//	@Deprecated
//    public JsonApiResult create(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data) throws Exception {
//        final OrderCreateVO orderCreateVO = JSON.parseObject(data, OrderCreateVO.class);
//        orderCreateVO.setChannel_code(code);
//        final OpSalesOrderVO opSalesOrderVO = orderAdapter.website2Common(orderCreateVO);
//        final OpSalesOrderResponseVO orderResp = pcInstance.orderAdd(opSalesOrderVO);
//
//        if (orderResp != null) {
//            final OrderCreateResponseVO vo = new OrderCreateResponseVO();
//            vo.setAmount(orderResp.getAmount().doubleValue());
//            vo.setOrder_no(orderResp.getOrderCode());
//            vo.setId(orderResp.getId());
//            return JsonApiResult.ofSuccessResult(vo);
//        }
//        LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
//        return JsonApiResult
//                .ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
//    }

//    @ApiAuth
//    @RequestMapping("/splitPackages")
//    @ResponseBody
//    public JsonApiResult splitPackages(@RequestParam("CODE") final String code,
//                                       @RequestParam("DATA") final String data) {
//        final OrderCreateVO orderCreateVO = JSON.parseObject(data, OrderCreateVO.class);
//        orderCreateVO.setChannel_code(code);
//        final OpSalesOrderVO opSalesOrderVO = orderAdapter.website2Common(orderCreateVO);
//        return JsonApiResult.ofSuccessResult(opSalesOrderVO);
//    }

    /***
     * 根据用户id，查询订单列表
     *
     * @param code
     * @param data
     * @return 对应原 /beast_site/order/list
     */
    @ApiAuth
    @RequestMapping("/list")
    @ResponseBody
    public JsonApiResult list(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data) {
        final JSONObject jsonData = JSON.parseObject(data);

        // 鍙栧緱浼氬憳Id
        final Long memberId = jsonData.getLong("partner_id");
        final Integer currpage = jsonData.getInteger("page");
        final int pagenum = jsonData.getIntValue("limit");

        if (memberId == null) {
            LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
            return JsonApiResult
                    .ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
        }

        final List<OpSalesOrderVO> list = pcInstance.orderlist(memberId, "", code, currpage, pagenum);

        final List<OrderQueryVO> orderQueryVOs = new ArrayList<OrderQueryVO>();

        if (list != null) {

            for (final OpSalesOrderVO entity : list) {
                final OrderQueryVO vo = orderAdapter.common2website(entity);
                orderQueryVOs.add(vo);

            }
            final Integer orderCount = pcInstance.orderCount(memberId, "", code);
            final OrderVO orderVO = new OrderVO();
            orderVO.setCount(orderCount);
            orderVO.setOrders(orderQueryVOs);
            return JsonApiResult.ofSuccessResult(orderVO);

        } else {
            LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
            return JsonApiResult
                    .ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());

        }

    }

    /***
     * 根据订单id，查询订单行详情
     *
     * @param code
     * @param data
     * @return 对应原 /beast_site/order/info
     */
    @ApiAuth
    @RequestMapping("/detail")
    @ResponseBody
    public JsonApiResult detail(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data) {

        final JSONObject jsonData = JSON.parseObject(data);
        // 取得订单Id
        final Long id = jsonData.getLong("order_id");
        if (id == null) {
            return JsonApiResult
                    .ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
        }

        // 取得订单内容
        // 取得订单内容
        final OpSalesOrderVO opSalesOrderVO = pcInstance.orderDetail(id);

        if (opSalesOrderVO == null) {
            LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
            return JsonApiResult
                    .ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
        }

        final OrderQueryVO vo = orderAdapter.common2website(opSalesOrderVO);
        return JsonApiResult.ofSuccessResult(vo);
    }

    /***
     * 根据订单号，更新支付状态为已支付
     *
     * @param code
     * @param data
     * @return 对应原 /beast_site/order/pay
     * @throws Exception 
     */
    @ApiAuth
    @RequestMapping("/pay")
    @ResponseBody
    public JsonApiResult pay(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data) throws Exception {
        final SyncOrderPayStatusVO vo = JSON.parseObject(data, SyncOrderPayStatusVO.class);

        // 取得会员IdSyncOrderPayStatusVO
        // String orderNo = jsonData.getString("orderNo");

        // Integer paymentType = jsonData.getInteger("paymentType");

        // BigDecimal totalAmount = jsonData.getBigDecimal("totalAmount");

        if (vo == null) {
            LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
            return JsonApiResult
                    .ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
        }
        // 判断订单编号，支付方式，总金额
        if (StringUtils.isBlank(vo.getOrder_no()) || StringUtils.isBlank(vo.getPay_method()) || vo.getTotal() == null) {
            LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
            return JsonApiResult
                    .ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
        }

        final Integer paymentType = getPaymentType(vo.getPay_method());

        final boolean result = pcInstance
                .orderPay(vo.getOrder_no(), paymentType, new BigDecimal(String.valueOf(vo.getTotal())), vo.getPay_account());

        if (result) {
            return JsonApiResult.ofSuccessResult(result);
        }
        LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
        return JsonApiResult
                .ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(), ErrorCode.DEFAULT_EXCEPTION.getMesage());
    }

    /***
     * 查询订是否取消
     *
     * @param code
     * @param data
     * @return 取消订单
     */
    @ApiAuth
    @RequestMapping("/specilOrderIsCancel")
    @ResponseBody
    public JsonApiResult specilOrderIsCancel(@RequestParam("CODE") final String code,
                                             @RequestParam("DATA") final String data) {
        final JSONObject jsonData = JSON.parseObject(data);

        // 取得订单号
        final String orderCode = jsonData.getString("order_no");
        final boolean result = pcInstance.orderSpecilIsCancel(orderCode);

        return JsonApiResult.ofSuccessResult(result);
    }

    private static Integer getPaymentType(final String payMethod) {
        Integer paymentType = null;
        if ("CASH".equals(payMethod)) {
            paymentType = PegasusConstants.Payment.TYPE_CASH;
        } else if ("BANK".equals(payMethod)) {
            paymentType = PegasusConstants.Payment.TYPE_DEBIT_CARD;
        } else if ("CRDT".equals(payMethod)) {
            paymentType = PegasusConstants.Payment.TYPE_CREDIT_CARD;
        } else if ("WXSQ".equals(payMethod)) {
            paymentType = PegasusConstants.Payment.TYPE_WEIXIN;
        } else if ("ZFBA".equals(payMethod)) {
            paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
        } else if ("CMB".equals(payMethod)) {
            paymentType = PegasusConstants.Payment.TYPE_CMB;
        } else if ("TRANSFER".equals(payMethod)) {
            paymentType = PegasusConstants.Payment.TYPE_TRANSFER;
        }

        return paymentType;

    }
}
