package com.thebeastshop.pegasus.channelservice.controller.website.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.website.ItemAdpter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.website.item.ItemVO;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SSkuStockVO;

@Controller
@RequestMapping("/api/website/item")
public class ItemController {

	private final static Logger log = LoggerFactory.getLogger(ItemController.class);

	// private PegasusWarehouseServiceFacade pwInstance=
	// PegasusWarehouseServiceFacade.getInstance();

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McOpChannelService mcOpChannelService;
	@Autowired
	private ItemAdpter itemAdpter;

	@Autowired
	private SPresaleService sPresaleService;

	@Autowired
	private SStockService sStockService;

	/**
	 * 获取多个商品的库存
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原：/beast_site/product/stockvirtual
	 */
	@ApiAuth
	@RequestMapping(value = "/product/stockvirtual")
	@ResponseBody
	public JsonApiResult stockvirtual(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		JSONObject jsonData = JSONObject.parseObject(data);

		List<String> skus = JSONObject.parseArray(jsonData.getString("product_ids"), String.class);

		if (skus == null || skus.size() <= 0) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		// 未取到渠道仓库
		if (opChannel == null || StringUtils.isBlank(opChannel.getWarehouseForSales())) {
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
		Map<String, Integer> map = new HashMap<String, Integer>();
		for (String skuCode : skus) {
			JSONObject jsonCode = JSONObject.parseObject(skuCode);

			// 根据sku,仓库code查出库存
			// WhInvVO whInvVO
			// =pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(jsonCode.getString("product_id"),
			// opChannel.getWarehouseForSales());
			// Integer quantity=whInvVO.getCanUseInv();

			Integer quantity = 0;
			SSkuStockVO sSkuStockVO = sStockService.getSkuStock(skuCode, opChannel.getWarehouseForSales());

			if (sSkuStockVO != null) {
				quantity = sSkuStockVO.getCanUseQuantity();
			}

			// 增加预售判断。先判断物理库存，再判断预售库存，返回的库存为两个值之和 added by fs 20151127
			// OpPresaleSaleInvVO
			// preSaleVO=poInstance.findCanUseQttBySkuCode(jsonCode.getString("product_id"),
			// null);

			SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(jsonCode.getString("product_id"),
					null);
			if (preSaleInvVO != null) {
				quantity = quantity + preSaleInvVO.getCanUseInv();
			}

			map.put(jsonCode.getString("product_id"), quantity);
		}

		return JsonApiResult.ofSuccessResult(map);
	}

	/**
	 * 增量同步产品信息
	 * 
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原： /beast_site/product/allfieldsync
	 */
	@ApiAuth
	@RequestMapping(value = "/allfieldsync")
	@ResponseBody
	public JsonApiResult allfieldsync(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		log.info(code + " ++++ " + data);

		Map<String, String> t = new HashMap<String, String>();
		t.put("timestamp", String.valueOf(System.currentTimeMillis()));
		t.put("sign", "test 12345");
		return JsonApiResult.ofSuccessResult(t);
	}

	@ApiAuth
	@RequestMapping(value = "/product/sync")
	@ResponseBody
	public JsonApiResult sync(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject json = JSONObject.parseObject(data);
		String last_sync_time = json.getString("last_sync_time");
		Integer page = json.getInteger("page");
		PsProductCond cond = new PsProductCond();
		cond.setChannelCode(code);
		cond.setCurrpage(page);
		// cond.setUpdateTime(last_sync_time);
		cond.setPrimaryUpdateTime(last_sync_time);
		List<PsProductVO> psProductVOs = mcPsProductService.findByCond(cond, false);

		List<ItemVO> list = new ArrayList<ItemVO>();
		if (CollectionUtils.isNotEmpty(psProductVOs)) {
			list = itemAdpter.common2website(psProductVOs, code);
		}
		return JsonApiResult.ofSuccessResult(list);
	}

}
