package com.thebeastshop.pegasus.channelservice.controller.website.coupon;



import java.math.BigDecimal;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;




import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.ConponVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.exception.OperationException;
@Controller
@RequestMapping("/api/website/coupon")
public class CouponController {

	private PegasusOperationServiceFacade poInstance=PegasusOperationServiceFacade.getInstance();
	/**
	 * 
	 * @param code 渠道编码
	 * @param data 业务参数
	 * @return
	 * 对应原：/beast_site/coupon/check 检查coupon
	 */
	@ApiAuth
	@RequestMapping(value="/check")
	@ResponseBody
	public JsonApiResult couponCheck(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		JSONObject jsonData=JSONObject.parseObject(data);
		Long memberId=jsonData.getLong("partner_id");//用户ID
		Double total=jsonData.getDouble("amount_total");//金额
		String couponCode=jsonData.getString("coupon_code");
		ConponVO coupon=new ConponVO();
		if(total==null|| StringUtils.isBlank(couponCode)){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		try{
			BigDecimal discount=poInstance.validByCouponCode(BigDecimal.valueOf(total), couponCode,memberId );
			coupon.setDiscount(discount.doubleValue());
			coupon.setValid(true);
		}catch(OperationException e){
			coupon.setDiscount(0d);
			coupon.setValid(false);
			coupon.setMessage(e.getMessage());
		}
		return JsonApiResult.ofSuccessResult(coupon);
	}
}
