package com.thebeastshop.pegasus.channelservice.controller.thirdparty;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.member.service.MemberThirdPartyService;
import com.thebeastshop.member.vo.WXJsConfigVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.util.HttpKit;
import com.thebeastshop.support.vo.weixin.WeiXinJsConfigVO;

/**
 * 微信相关接口
 * 
 * @author Paul-xiong
 *
 */
@Controller("WeiXinController")
@RequestMapping("api/weixin")
@ResponseBody
public class WeiXinController {

	@Resource
	private MemberThirdPartyService memberThirdPartyService;

	/**
	 * 获取微信签名
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
//	@ApiAuth
	@RequestMapping(value = "/signature")
	public JsonApiResult getSignature(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) {
		final JSONObject jsonData = JSON.parseObject(data);
		// 当前网页的URL
		final String url = jsonData.getString("url");
		if (StringUtils.isBlank(url)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		WXJsConfigVO config = memberThirdPartyService.getWXJsConfig(url);
		WeiXinJsConfigVO configVO = new WeiXinJsConfigVO();
		configVO.setAppId(config.getAppId());
		configVO.setNonceStr(config.getNonceStr());
		configVO.setSignature(config.getSignature());
		configVO.setTimestamp(config.getTimestamp());
		return JsonApiResult.ofSuccessResult(configVO);
	}
	
	/**
	 * 获取微信Token
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
//	@ApiAuth
//	@RequestMapping(value = "/takeToken")
//	public JsonApiResult takeToken(@RequestParam("CODE") final String code,
//			@RequestParam("DATA") final String data) {
//		
//		String token = weiXinService.takeToken();
//	
//		return JsonApiResult.ofSuccessResult(token);
//	}

	public static void main(String[] args) {
		String wxUrl="http://wx.thebeastshop.com/token/get?sign=efb4d0fca5fbf585b0ea96d0fcecb2fb";
		
		String resultJsonStr = HttpKit.post(wxUrl,"");
		if(StringUtils.isEmpty(resultJsonStr)){
		
		}else{
			final JSONObject jsonDa = JSON.parseObject(resultJsonStr);
			String accessToken = jsonDa.getString("token");
			System.out.print(accessToken);
		}
		
	}
}