package com.thebeastshop.pegasus.channelservice.controller.staff;

import java.util.List;

import com.thebeastshop.pegasus.channelservice.constants.PegasusConstants;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesVO;
import com.thebeastshop.pegasus.service.operation.model.OpSales;
import com.thebeastshop.support.vo.staff.StaffVO;

/**
 * 店员Controller (新)
 * @Class Name StaffController
 * @Author Xiang.Gao
 * @Create In 2017-9-26
 */
@Controller
@RequestMapping("/api/staff")
public class StaffController {

	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();
	
	@ApiAuth
	@RequestMapping(value="/login")
	@ResponseBody
	public JsonApiResult login(@RequestParam("CODE") String code,@RequestParam("DATA") String data){
		// 参数解析
		JSONObject jsonData = JSONObject.parseObject(data);
		String loginName = jsonData.getString("loginName");
		String loginPwd = jsonData.getString("loginPwd");
		if(StringUtils.isBlank(loginPwd) || StringUtils.isBlank(loginName)){
			return JsonApiResult.ofErrorResult(ErrorCode.AUTHFAILED_MISS_PARAMS.getCode(), 
					ErrorCode.AUTHFAILED_MISS_PARAMS.getMesage());
		}
		// 查询店员
		OpSalesVO opSalesVO = pcInstance.salesLogin(loginName, loginPwd);
		if (ObjectUtils.isEmpty(opSalesVO)) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_FAILED.getCode(), 
					ErrorCode.USER_LOGIN_FAILED.getMesage());
		}
		// 店员被禁用
		if(opSalesVO.getSalesStatus().intValue() == PegasusConstants.STATUS_UNAVAILABLE) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_DISABLED.getCode(),ErrorCode.USER_DISABLED.getMesage());
		}
		// 登陆成功
		StaffVO staff = new StaffVO(opSalesVO.getId().intValue(), opSalesVO.getSalesName(), opSalesVO.getSalesLevel());
		return JsonApiResult.ofSuccessResult(staff);
		
	}
	
	@ApiAuth
	@RequestMapping(value="/queryByChannel")
	@ResponseBody
	public JsonApiResult queryByChannel(@RequestParam("CODE") String code) {
		if (StringUtils.isBlank(code)) {
			return JsonApiResult.ofErrorResult(ErrorCode.CHANNEL_CODE_EMPTY.getCode(), ErrorCode.CHANNEL_CODE_EMPTY.getMesage());
		}
		List<OpSales> sales = pcInstance.findSalesByChannelCode(code);
		List<StaffVO> staffList = Lists.newArrayList();
		for (OpSales opSales : sales) {
			staffList.add(new StaffVO(opSales.getId().intValue(), opSales.getSalesName(), opSales.getSalesLevel()));
		}
		return JsonApiResult.ofSuccessResult(staffList);
	}
	
	@ApiAuth
	@RequestMapping(value = "/blocked-out")
	@ResponseBody
	public JsonApiResult blockedOut(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		OpSalesVO opSalesVO = pcInstance.findSaleById(jsonData.getLong("id"));
		// 店员不存在
		if (ObjectUtils.isEmpty(opSalesVO)) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_LOGIN_NOT_EXIST.getCode(), 
					ErrorCode.USER_LOGIN_NOT_EXIST.getMesage());
		}
		// 店员被禁用
		if(opSalesVO.getSalesStatus().intValue() == PegasusConstants.STATUS_UNAVAILABLE) {
			return JsonApiResult.ofErrorResult(ErrorCode.USER_DISABLED.getCode(),ErrorCode.USER_DISABLED.getMesage());
		}
		StaffVO staff = new StaffVO(opSalesVO.getId().intValue(), opSalesVO.getSalesName(), opSalesVO.getSalesLevel());
		return JsonApiResult.ofSuccessResult(staff);
	}

}
