package com.thebeastshop.pegasus.channelservice.controller.smartpos;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.service.smartpos.SmartPosService;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.service.operation.exception.ChannelException;
import com.thebeastshop.pegasus.service.operation.exception.ChannelExceptionErrorCode;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.cart.SmartPosPreviewVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.util.List;

/**
 * 智能POS 服务
 * Created by GFL on 2017/10/13.
 */
@Controller("smartPostController")
@RequestMapping("api/smartPost")
@ResponseBody
public class SmartPosController {


    private static Logger logger = LoggerFactory.getLogger(SmartPosController.class);

    @Autowired
    private MemberQueryService memberQueryService;

    @Autowired
    private SmartPosService smartPosService;

    @Autowired
    private McOpChannelService mcOpChannelService;


    /**
     * 线下收银购物车预览，目前只有source.RAW商品
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(value = "/cart/preview")
    public JsonApiResult preview(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        logger.info("api/smartPost/cart/preview 入参：code={} data={}");
        JSONObject jsonData = JSONObject.parseObject(data);
        Long memberId = jsonData.getLong("memberId");
        Integer accessWayId = jsonData.getInteger("accessWay");
        List<RequestPack> requestPacks = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);

        if (CollectionUtils.isEmpty(requestPacks)) {
            return JsonApiResult.ofErrorResult(400, "商品包不能为空");
        }

        if (NumberUtil.isNullOrZero(memberId)) {
            return JsonApiResult.ofErrorResult(400, "会员信息不能为空");
        }

        AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
        MemberVO member = memberQueryService.getById(memberId);
        OpChannelVO channel = mcOpChannelService.findByCode(code);
        SmartPosPreviewVO previewVO = null;
        if (CollectionUtils.isNotEmpty(requestPacks)) {
            previewVO = smartPosService.preview(requestPacks, member, channel, accessWay);
        }
        return JsonApiResult.ofSuccessResult(previewVO);

    }


    /**
     * 线下收银购物车预览，目前只有source.RAW商品
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(value = "/order/confirm")
    public JsonApiResult orderConfirm(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
        logger.info("api/smartPos/order/confirm 入参：code={} data={}");
        JSONObject jsonData = JSONObject.parseObject(data);
        Long memberId = jsonData.getLong("memberId");
        Integer accessWayId = jsonData.getInteger("accessWay");
        BigDecimal price = jsonData.getBigDecimal("price");
        List<RequestPack> requestPacks = JSON.parseArray(jsonData.getString("packs"), RequestPack.class);
        String deviceId = jsonData.getString("deviceId");
        String downloadSource = jsonData.getString("downloadSource");
        String tbsClient = jsonData.getString("tbsClient");
        String tbsUSource = jsonData.getString("tbsUSource");
        String platform = jsonData.getString("platform");
        AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);

        if (CollectionUtils.isEmpty(requestPacks)) {
            return JsonApiResult.ofErrorResult(400, "商品包不能为空");
        }

        if (NumberUtil.isNullOrZero(memberId)) {
            return JsonApiResult.ofErrorResult(400, "会员信息不能为空");
        }

        MemberVO member = memberQueryService.getById(memberId);
        OpChannelVO channel = mcOpChannelService.findByCode(code);
        try {
            String orderCode = smartPosService.confirm(price, requestPacks, member, channel, accessWay, 
            		deviceId, downloadSource, tbsClient, tbsUSource, platform);
            return JsonApiResult.ofSuccessResult(orderCode);
        }catch (ChannelException e){
            // 库存不足特殊处理
            logger.error("下单失败",e);
            if(e.getErrorCode().equalsIgnoreCase(ChannelExceptionErrorCode.ORDER_QUANTITY_ZERO_CODE)){
                // 商品库存不足
                return JsonApiResult.ofErrorResult(4002,e.getMessage());
            }
            throw e;
        }
    }

}
