package com.thebeastshop.pegasus.channelservice.controller.shop;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.configuration.service.StoreService;
import com.thebeastshop.configuration.vo.StoreBubbleVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ShopOperationConstant;
import com.thebeastshop.pegasus.channelservice.controller.order.app.OrderController;
import com.thebeastshop.pegasus.component.shop.domain.BubbleVo;
import com.thebeastshop.pegasus.component.shop.domain.ShopVo;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;

@Controller
@RequestMapping(value = "/api/shop")
public class ShopControllor {

	private final Logger logger = LoggerFactory.getLogger(OrderController.class);

	// protected ShopEntryService service =
	// ComponentServiceLoader.getBean(ShopEntryService.class);

	@Autowired
	private StoreService storeService;

	// /**
	// * 获取 shop
	// *
	// * @param code
	// * @param data
	// * @return
	// */
	// @RequestMapping(path = "/getShopById", method = RequestMethod.GET)
	// @ResponseStatus(HttpStatus.OK)
	// @ResponseBody
	// public JsonApiResult getProduct(@RequestParam("CODE") String code,
	// @RequestParam("DATA") String data) {
	// JSONObject jsonData = JSONObject.parseObject(data);
	// Long shopId = jsonData.getLong("shopId");
	// ShopVo cond = new ShopVo();
	// cond.setShopId(shopId);
	// cond.setState(ShopOperationConstant.type.PUBLISH);
	//
	// ShopVo shop = new ShopVo();
	// List<ShopVo> shops = service.findOperationListByCond(cond);
	// if (null != shops && shops.size() > 0) {
	// shop = shops.get(0);
	// }
	// return JsonApiResult.ofSuccessResult(shop);
	// }

	// /**
	// * 获取 气泡
	// *
	// * @param code
	// * @param data
	// * @return
	// */
	// @RequestMapping(path = "/getBubbleById", method = RequestMethod.GET)
	// @ResponseStatus(HttpStatus.OK)
	// @ResponseBody
	// public JsonApiResult getBubbles(@RequestParam("CODE") String code,
	// @RequestParam("DATA") String data) {
	// // JSONObject jsonData = JSONObject.parseObject(data);
	// // String shopId = jsonData.getString("shopId");
	// BubbleVo cond = new BubbleVo();
	// // cond.setShopId(shopId);
	// cond.setState(ShopOperationConstant.type.PUBLISH);
	//
	// List<BubbleVo> bubs = service.findBubbleByCond(cond);
	// return JsonApiResult.ofSuccessResult(bubs);
	// }

	/**
	 * 获取 气泡新
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getBubbleByIdNew", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getBubblesNew(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		//
		BubbleVo cond = new BubbleVo();
		cond.setState(ShopOperationConstant.type.PUBLISH);
		List<BubbleVo> bubs = new ArrayList<BubbleVo>();

		ServiceResp<List> resp = storeService.getOnlineBubbles();
		if (resp.isSuccess()) {
			List<StoreBubbleVO> vos = resp.getBean();
			if (CollectionUtils.isNotEmpty(vos)) {
				for (StoreBubbleVO vo : vos) {
					BubbleVo bub = new BubbleVo();
					bub.setBubbles(vo.getModules());
					bub.setId(vo.getId());
					bub.setShopId(vo.getShopId().toString());
					bub.setShopName(vo.getShopName());
					bub.setState(vo.getState());
					bubs.add(bub);
					logger.info("气泡" + bub);
				}
			}
		}

		return JsonApiResult.ofSuccessResult(bubs);
	}

	// public ShopEntryService getService() {
	// return service;
	// }
	//
	// public void setService(ShopEntryService service) {
	// this.service = service;
	// }

}
