package com.thebeastshop.pegasus.channelservice.controller.search;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.thebeastshop.pegasus.channelservice.enums.SearchSortField;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsIposCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.vo.product.CategoryVO;
import com.thebeastshop.support.vo.product.FilterVO.Item;
import com.thebeastshop.support.vo.product.ProductsIposVO;
import com.thebeastshop.support.vo.product.SimpleProductVO;

@Controller("searchIposController")
@RequestMapping("/api/searchIpos")
public class SearchIposController {
	private Logger logger = LoggerFactory.getLogger(SearchIposController.class);
	@Autowired
	private McOpChannelService mcOpChannelService;

	@Autowired
	private ProductAdapter adapter;
	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private McPsProductService mcPsProductService;

	// ==========================================ipos===========================================
	@ApiAuth
	@RequestMapping(path = "/category", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult getCategoryForIpos(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		logger.info("查询门店");
		List<CategoryVO> categorys = new ArrayList<CategoryVO>();
		ProdSearchCond prodSearchCond = new ProdSearchCond();
		prodSearchCond.setChannelCode(code);
		List<PcsIposCategoryVO> iposCategoryVOs = mcPsProductService.queryIposCategoryBrandLabel(prodSearchCond);
		if (CollectionUtils.isNotEmpty(iposCategoryVOs)) {
			for (PcsIposCategoryVO iposCategoryVO : iposCategoryVOs) {
				CategoryVO category = new CategoryVO();
				List<PcsSkuCategoryVO> subCates = iposCategoryVO.getCategoryList();
				PcsSkuCategoryVO cate = iposCategoryVO.getPanrent();

				String[] cateNnames = cate.getName().split("-");

				category.setName(cateNnames.length > 0 ? cateNnames[cateNnames.length - 1] : "");

				List<Item> items = new ArrayList<Item>();
				if (CollectionUtils.isNotEmpty(subCates)) {
					for (PcsSkuCategoryVO subCate : subCates) {
						Item item = new Item();
						item.setId(subCate.getCode());
						String name = subCate.getName();

						String[] names = name.split("-");
						String itemName = names.length > 0 ? names[names.length - 1] : "";

						if (CollectionUtils.isEmpty(items)) {
							itemName = "全部" + itemName;
						}
						item.setName(itemName);
						items.add(item);
					}
				}
				category.setItems(items);
				categorys.add(category);
			}

		} else {
			logger.info("李凯没有返回门店类目信息");
		}

		return JsonApiResult.ofSuccessResult(categorys);
	}

	/**
	 * 搜索关键字
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/ipos", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult searchForIpos(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		Integer offset = jsonData.getInteger("offset");
		Integer limit = jsonData.getInteger("limit");
		String keywords = jsonData.getString("keywords");
		String categoryId = jsonData.getString("categoryId");
		Boolean isSpot = jsonData.getBoolean("isSpot");
		Boolean isCombined = jsonData.getBoolean("isCombined");
		Boolean isOversea = jsonData.getBoolean("isOversea");

		MemberVO member = memberQueryService.getById(memberId);

		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);

		ProdSearchCond prodSearchCond = new ProdSearchCond();
		prodSearchCond.setChannelCode(code);
		prodSearchCond.setFrom(offset);
		prodSearchCond.setSize(limit);
		prodSearchCond.setSortField(SearchSortField.RELEASE.getName());
		prodSearchCond.setSortOrder("ASC");
		if (StringUtils.isNotBlank(keywords)) {
			try {
				prodSearchCond.setKeywords(URLDecoder.decode(keywords, "UTF-8"));
			} catch (UnsupportedEncodingException e) {
				logger.info("设置 keywork  中文 转码！");
			}
		}
		if (StringUtils.isNotBlank(categoryId)) {
			List<String> categoryCodes = new ArrayList<String>();
			categoryCodes.add(categoryId);
			prodSearchCond.setCategoryCodes(categoryCodes);
		}
		prodSearchCond.setIsCombined(isCombined);
		prodSearchCond.setIsLocalStock(isSpot);
		prodSearchCond.setIsCrossBorder(isOversea);

		Page<PsProductVO> page = getPage(
				mcPsProductService.findIposProdBySearchCondVO(code, campaignCond, prodSearchCond));

		List<SimpleProductVO> simpleProducts = new ArrayList<SimpleProductVO>();
		if (page.getTotal() > 0) {
			simpleProducts = adapter.getSimpleProducts(Lists.newArrayList(page.getItems()), member, opChannel,
					accessWay);
			sortBySoldOut(simpleProducts);
		}

		ProductsIposVO result = new ProductsIposVO();
		result.setProducts(simpleProducts);
		result.setTotal(page.getTotal());

		return JsonApiResult.ofSuccessResult(result);
	}

	private void sortBySoldOut(List<SimpleProductVO> list) {
		if (CollectionUtils.isNotEmpty(list)) {
			// 排序 根据soldout
			Collections.sort(list, new Comparator<SimpleProductVO>() {
				@Override
				public int compare(SimpleProductVO o1, SimpleProductVO o2) {
					int a = o1.getSoldOut() ? 1 : 0;
					int b = o2.getSoldOut() ? 1 : 0;
					return (a - b);
				}
			});
		}
	}

	/**
	 * 获取分页实体
	 * 
	 * @param productList
	 * @return
	 */
	private Page<PsProductVO> getPage(List<PsProductVO> productList) {
		Page<PsProductVO> page = new Page<PsProductVO>();
		page.setItems(productList);
		// 数量
		Long total = 0L;
		if (CollectionUtils.isNotEmpty(productList)) {
			if (productList.size() > 0) {
				total = productList.get(0).getTotal();
			}
		}
		if (total != null) {
			page.setTotal(Integer.valueOf(total.toString()));
		}
		return page;
	}

	private PsMatchCampaignCond createMatchCampaignCond(MemberVO member, AccessWayEnum accessWay, String code) {
		PsMatchCampaignCond campaignCond = new PsMatchCampaignCond();
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		campaignCond.setMatchCampaign(true);
		campaignCond.setAccessWay(accessWay.getCode());
		campaignCond.setChannelCode(code);
		campaignCond.setMemberLevel(memberLevel.getCode());
		campaignCond.setDiscount(memberLevel.getLevelAmountCondition());
		campaignCond.setBdDiscount(member.getBdayDiscountRatio());
		logger.info("MatchCampaign={},AccessWay={},ChannelCode={},MemberLevel={},Discount={},BdDiscount={}",
				campaignCond.getMatchCampaign(), campaignCond.getAccessWay(), campaignCond.getChannelCode(),
				campaignCond.getMemberLevel(), campaignCond.getDiscount(), campaignCond.getBdDiscount());
		return campaignCond;
	}
}
