package com.thebeastshop.pegasus.channelservice.controller.search;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.*;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.pegasus.channelservice.enums.SearchSortField;
import com.thebeastshop.pegasus.component.product.enums.ProductSortField;
import com.thebeastshop.support.Link;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.configuration.enums.SearchRecommendTypeEnum;
import com.thebeastshop.configuration.enums.TerminalEnum;
import com.thebeastshop.configuration.service.SearchRecommendService;
import com.thebeastshop.configuration.service.StoreService;
import com.thebeastshop.configuration.vo.SearchRecommendVO;
import com.thebeastshop.configuration.vo.StoreVO;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.component.category.CategoryFront;
import com.thebeastshop.pegasus.component.category.service.CategoryFrontService;
import com.thebeastshop.pegasus.component.compatible.service.ListService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.merchandise.IService.IRecommendService;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsCampaignSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.TrackSearchDataCond;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuBuEnum;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McOpLabelService;
import com.thebeastshop.pegasus.merchandise.service.McOpListpageService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpLabelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpListpageProdVO;
import com.thebeastshop.pegasus.merchandise.vo.OpListpageVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.scm.vo.recommend.RecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendParamVO.Type;
import com.thebeastshop.support.enums.HotKeyType;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.page.Pagination;
import com.thebeastshop.support.page.Sort;
import com.thebeastshop.support.vo.AppCommonParams;
import com.thebeastshop.support.vo.product.FilterVO;
import com.thebeastshop.support.vo.product.FilterVO.Item;
import com.thebeastshop.support.vo.product.HotKeyVO.HotKey;
import com.thebeastshop.support.vo.product.ProductDetailNewVO.Image;
import com.thebeastshop.support.vo.product.ProductListVO;
import com.thebeastshop.support.vo.product.ProductListVO.Suggest;
import com.thebeastshop.support.vo.product.SimpleProductVO;

@Controller("searchController")
@RequestMapping("/api/search")
public class SearchController {
	private Logger logger = LoggerFactory.getLogger(SearchController.class);

	protected ListService listService = ComponentServiceLoader.getBean(ListService.class);

	@Autowired
	private MemberQueryService memberQueryService;

	private CategoryFrontService categoryFrontService = ComponentServiceLoader.getBean(CategoryFrontService.class);

	@Autowired
	private McOpLabelService mcOpLabelService;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McOpListpageService mcOpListpageService;

	@Autowired
	private ProductAdapter adapter;

	@Autowired
	private IRecommendService recommendService;

	@Autowired
	private StoreService storeService;

	@Autowired
	private SearchRecommendService searchRecommendService;

	@Autowired
	private McOpChannelService mcOpChannelService;

	// ======================private=====================

	/**
	 * 设置SortField默认值
	 * @return
	 */
	public SearchSortField getSortFieldOrDefaultValue(SearchSortField sortField){
		if(null == sortField){
			return SearchSortField.RELEASE;
		}
		return sortField;
	}

	/**
	 * 商品排序
	 * 
	 * @param products
	 * @param sortField
	 */
	private List<PsProductVO> sort(List<PsProductVO> products, SearchSortField sortField, final String sortOrder) {
		switch (sortField) {
		case RELEASE:
			if (sortOrder.equalsIgnoreCase("ASC")) {
				Collections.reverse(products);
			}
			break;
		case PRICE:
			Collections.sort(products, new Comparator<PsProductVO>() {
				@Override
				public int compare(PsProductVO o1, PsProductVO o2) {
					BigDecimal price1 = o1 != null && o1.getListPrice() != null ? o1.getListPrice() : BigDecimal.ZERO;
					BigDecimal price2 = o2 != null && o2.getListPrice() != null ? o2.getListPrice() : BigDecimal.ZERO;
					if (sortOrder.equalsIgnoreCase("ASC")) {
						return price1.compareTo(price2);
					} else {
						return price2.compareTo(price1);
					}
				}
			});
			break;
		default:
			break;
		}

		return products;
	}

	/**
	 * 获取分页实体
	 * 
	 * @param productList
	 * @return
	 */
	private Page<PsProductVO> getPage(List<PsProductVO> productList) {
		Page<PsProductVO> page = new Page<PsProductVO>();
		page.setItems(productList);
		// 数量
		Long total = 0L;
		if (CollectionUtils.isNotEmpty(productList)) {
			if (productList.size() > 0) {
				total = productList.get(0).getTotal();
			}
		}
		if (total != null) {
			page.setTotal(Integer.valueOf(total.toString()));
		}
		return page;
	}

	/**
	 * 获取分页实体
	 * 
	 * @param productList
	 * @param offset
	 * @param limit
	 * @param sortField
	 * @param sortOrder
	 * @return
	 */
	private Page<PsProductVO> getPage(List<PsProductVO> productList, Integer offset, Integer limit,
			SearchSortField sortField, String sortOrder) {
		Page<PsProductVO> page = new Page<PsProductVO>();
		if (CollectionUtils.isNotEmpty(productList)) {
			int total = productList.size();
			page.setTotal(total);
			productList = sort(productList, sortField, sortOrder);
			// 分页设置
			int fromIndex = offset;
			if (fromIndex < total) {
				int toIndex = offset + limit;
				if (toIndex > total) {
					toIndex = total;
				}
				page.setItems(productList.subList(fromIndex, toIndex));
			}
		} else {
			page.setTotal(0);
		}
		return page;
	}

	/**
	 * 从es中获取商品列表
	 * 
	 * @param channelCode
	 * @param prodSearchCond
	 * @return
	 */
	private Page<PsProductVO> getProductsByES(String channelCode, ProdSearchCond prodSearchCond,
			PsMatchCampaignCond campaignCond) {
		Date start = new Date();
		logger.info(
				"搜索参数，labelIds={},labels={},Aggs={}，BrandId={}，BrandIds={}，CategoryCodes={}，ChannelCode={}，DateRange={}，From={}，IsCrossBorder={}，IsNew={}，Keywords={}，LabelIds={}，PsTags={}，Size={}，SortField={}，SortOrder={}",
				prodSearchCond.getLabelIds(), prodSearchCond.getLabels(), prodSearchCond.getAggs(),
				prodSearchCond.getBrandId(), prodSearchCond.getBrandIds(), prodSearchCond.getCategoryCodes(),
				prodSearchCond.getChannelCode(), prodSearchCond.getDateRange(), prodSearchCond.getFrom(),
				prodSearchCond.getIsCrossBorder(), prodSearchCond.getIsNew(), prodSearchCond.getKeywords(),
				prodSearchCond.getLabelIds(), prodSearchCond.getPsTags(), prodSearchCond.getSize(),
				prodSearchCond.getSortField(), prodSearchCond.getSortOrder());

		List<PsProductVO> productList = mcPsProductService.findByProdSearchCondVO(channelCode, campaignCond,
				prodSearchCond);
		Date end = new Date();
		logger.info(
				"方法mcPsProductService.findByProdSearchCondVO，参数  categorycodes：{}，brandids：{} , labels：{}，keywprds:{}，花费时间：{}毫秒",
				prodSearchCond.getCategoryCodes(), prodSearchCond.getBrandIds(), prodSearchCond.getLabelIds(),
				prodSearchCond.getKeywords(), end.getTime() - start.getTime());
		// logger.info("搜索结果：productList:{}", productList);
		return getPage(productList);
	}

	// ==================================================

	/**
	 * 搜索商品
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/product", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult searchProduct(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		Boolean forPostage = jsonData.getBoolean("forPostage");
		Long campaignId = jsonData.getLong("campaignId");
		Long listId = jsonData.getLong("listId");
		Long shopId = jsonData.getLong("shopId");
		List<String> categoryCodes = JSON.parseArray(jsonData.getString("categoryCodes"), String.class);
		Boolean isNew = jsonData.getBoolean("isNew");
		Boolean overseas = jsonData.getBoolean("overseasOnly");
		Boolean customizable = jsonData.getBoolean("customizable");
		String selected = jsonData.getString("selected");
		Boolean special = jsonData.getBoolean("special");
		String keyword = jsonData.getString("keyword");

		List<String> brandIds = JSON.parseArray(jsonData.getString("brandId"), String.class);
		List<String> labels = new ArrayList<String>();
		SearchSortField sortField = jsonData.getObject("sortField", SearchSortField.class);
		sortField = getSortFieldOrDefaultValue(sortField);
		SearchSortField sort = jsonData.getObject("sortField", SearchSortField.class);
		AppCommonParams commonParams = jsonData.getObject("commonParams", AppCommonParams.class);

		String attributeId = jsonData.getString("attributeId");
		String dimensionId = jsonData.getString("dimensionId");
		List<String> labelIds = JSON.parseArray(jsonData.getString("labelIds"), String.class);

		String sortOrder = jsonData.getString("sortOrder");
		Integer offset = jsonData.getInteger("offset");
		Integer limit = jsonData.getInteger("limit");
		String tbsSource = jsonData.getString("tbsSource");
		String param = jsonData.getString("param");
		Integer buId = jsonData.getInteger("buId");
		Page<SimpleProductVO> rtPage = new Page<SimpleProductVO>(
				new Pagination(offset, limit, new Sort(sortField.getName(), sortOrder)));

		Page<PsProductVO> page = null;
		// ====参数处理======//
		List<String> condCategorys = new ArrayList<>();// 商品服务查询用类目id
		List<String> condBrandIds = new ArrayList<>();// 商品服务查询用品牌id
		List<String> condLabels = new ArrayList<>();// 商品服务查询用标签id

		convertSelectedParameter(selected, condCategorys, condBrandIds, condLabels);

		MemberVO member = memberQueryService.getById(memberId);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		if (buId > -1) {

			logger.info("搜索bu商品 buId ={}" + buId);



			PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
			ProdSearchCond prodSearchCond = new ProdSearchCond();
			prodSearchCond.setChannelCode(code);
			prodSearchCond.setFrom(offset);
			prodSearchCond.setSize(limit);
			prodSearchCond.setSortField(sortField.getName());
			prodSearchCond.setSortOrder(sortOrder);
			prodSearchCond.setBu(PcsSkuBuEnum.getBuNameByVal(buId));


			checkSelectedIdsWithDefaultCateIds(condCategorys, categoryCodes);
			logger.info("类目查询参数 condCategorys={}", condCategorys);
			if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {

				prodSearchCond.setCategoryCodes(condCategorys);
			}
			if (null != condBrandIds && !CollectionUtils.isEmpty(condBrandIds) && condBrandIds.size() > 0) {
				prodSearchCond.setBrandIds(condBrandIds);
			}
			if (null != condLabels && !CollectionUtils.isEmpty(condLabels) && condLabels.size() > 0) {
				prodSearchCond.setLabelIds(condLabels);
			}
			List<PsProductVO> products = mcPsProductService.findBuListByProdSearchCondVO(code, campaignCond,
					prodSearchCond);

			page = getPage(products);

		}

		else if (CollectionUtils.isNotEmpty(labelIds)) {

			logger.info("商品属性标签搜索");

			logger.info("标签查询参数 labelIds={}", labelIds);
			List<String> labelList = mcOpLabelService.findParentIdAndSelfByLabelId(labelIds);

			logger.info("查询后标签 labelList={}", labelList);

			PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
			ProdSearchCond prodSearchCond = new ProdSearchCond();
			prodSearchCond.setChannelCode(code);
			prodSearchCond.setFrom(offset);
			prodSearchCond.setSize(limit);
			prodSearchCond.setSortField(sortField.getName());
			prodSearchCond.setSortOrder(sortOrder);
			checkSelectedIdsWithDefaultIds(condLabels, labelList);

			logger.info("根据标签查询商品condLabels={}", condLabels);

			prodSearchCond.setLabelIds(condLabels);
			if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {
				prodSearchCond.setCategoryCodes(condCategorys);
			}
			if (null != condBrandIds && !CollectionUtils.isEmpty(condBrandIds) && condBrandIds.size() > 0) {
				prodSearchCond.setBrandIds(condBrandIds);
			}
			List<PsProductVO> products = mcPsProductService.findProdListBySkuAttribute(code, campaignCond,
					prodSearchCond);
			page = getPage(products);
		} else if (StringUtils.isNotBlank(attributeId) && StringUtils.isNotBlank(dimensionId)) {
			logger.info("属性搜索");
			PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
			ProdSearchCond prodSearchCond = new ProdSearchCond();
			prodSearchCond.setChannelCode(code);
			prodSearchCond.setFrom(offset);
			prodSearchCond.setSize(limit);
			prodSearchCond.setSortField(sortField.getName());
			prodSearchCond.setSortOrder(sortOrder);
			prodSearchCond.setSkuAttrId(Long.parseLong(dimensionId));
			prodSearchCond.setSkuAttrValueId(Long.parseLong(attributeId));
			if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {
				prodSearchCond.setCategoryCodes(condCategorys);
			}
			if (null != condLabels && !CollectionUtils.isEmpty(condLabels) && condLabels.size() > 0) {
				prodSearchCond.setLabelIds(condLabels);
			}
			if (null != condBrandIds && !CollectionUtils.isEmpty(condBrandIds) && condBrandIds.size() > 0) {
				prodSearchCond.setBrandIds(condBrandIds);
			}
			List<PsProductVO> products = mcPsProductService.findProdListBySkuAttribute(code, campaignCond,
					prodSearchCond);
			page = getPage(products);
		} else if (null != customizable && customizable) {
			logger.info("定制搜索");
			PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
			ProdSearchCond prodSearchCond = new ProdSearchCond();
			prodSearchCond.setChannelCode(code);
			prodSearchCond.setFrom(offset);
			prodSearchCond.setSize(limit);
			prodSearchCond.setSortField(sortField.getName());
			prodSearchCond.setSortOrder(sortOrder);
			List<PsProductVO> products = mcPsProductService.findCustomzeListByProdSearchCondVO(code, campaignCond,
					prodSearchCond);

			page = getPage(products);
		} else if (null != special && special) {
			logger.info("special搜索");
			PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
			ProdSearchCond prodSearchCond = new ProdSearchCond();
			prodSearchCond.setChannelCode(code);
			prodSearchCond.setFrom(offset);
			prodSearchCond.setSize(limit);
			prodSearchCond.setSortField(sortField.getName());
			prodSearchCond.setSortOrder(sortOrder);
			List<PsProductVO> products = mcPsProductService.findSpecialDiscountListByProdSearchCondVO(code,
					campaignCond, prodSearchCond);

			page = getPage(products);

		} else {

			if (categoryCodes == null) {
				categoryCodes = new ArrayList<>();
			}
			categoryCodes.addAll(convertShopIdToCategoryCodes(shopId));

			checkSelectedIdsWithDefaultCateIds(condCategorys, categoryCodes);
			logger.info("类目查询参数 condCategorys={}", condCategorys);

			checkSelectedIdsWithDefaultIds(condBrandIds, brandIds);
			logger.info("品牌查询参数 condBrandIds={}", condBrandIds);

			checkSelectedIdsWithDefaultIds(condLabels, labels);
			logger.info("标签查询参数 condLabels={}", condLabels);

			// logger.info(
			// "参数
			// listId={},categoryCodes={},shopId={},isNew={},sortField={},sortOrder={},offset={},limit={},campaignId={}",
			// listId, categoryCodes, shopId, isNew, sortField, sortOrder,
			// offset, limit, campaignId);
			if (forPostage != null && forPostage) {
				logger.info("forPostage搜索");
				RecommendParamVO avo = new RecommendParamVO();
				avo.setMemberLevel(memberLevel.getCode());
				avo.setAccessWay(accessWay.getCode());
				avo.setDiscount(memberLevel.getLevelAmountCondition());
				avo.setLimitSize(200);
				avo.setChnCode(opChannel.getCode());
				avo.setType(Type.ADD_ON_ITEM);
				List<PsProductVO> products = recommendService.autoRecommend(avo);
				page = getPage(products, offset, limit, sortField, sortOrder);
			} else if (null != brandIds && !CollectionUtils.isEmpty(brandIds) && brandIds.size() > 0) {
				logger.info("品牌搜索brandId={}", brandIds);

				PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
				ProdSearchCond prodSearchCond = new ProdSearchCond();
				prodSearchCond.setBrandIds(condBrandIds);
				prodSearchCond.setChannelCode(code);
				prodSearchCond.setFrom(offset);
				prodSearchCond.setSize(limit);
				prodSearchCond.setSortField(sortField.getName());
				prodSearchCond.setSortOrder(sortOrder);
				if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {
					prodSearchCond.setCategoryCodes(condCategorys);
				}
				if (null != condLabels && !CollectionUtils.isEmpty(condLabels) && condLabels.size() > 0) {
					prodSearchCond.setLabelIds(condLabels);
				}
				prodSearchCond.setIsCrossBorder(overseas);
				if (null != tbsSource && (tbsSource.equals("2") || tbsSource.endsWith("3"))) {
					prodSearchCond.setIsCrossBorder(false);
				}
				logger.info(
						"搜索参数，Aggs={}，BrandId={}，BrandIds={}，CategoryCodes={}，ChannelCode={}，DateRange={}，From={}，IsCrossBorder={}，IsNew={}，Keywords={}，LabelIds={}，PsTags={}，Size={}，SortField={}，SortOrder={}",
						prodSearchCond.getAggs(), prodSearchCond.getBrandId(), prodSearchCond.getBrandIds(),
						prodSearchCond.getCategoryCodes(), prodSearchCond.getChannelCode(),
						prodSearchCond.getDateRange(), prodSearchCond.getFrom(), prodSearchCond.getIsCrossBorder(),
						prodSearchCond.getIsNew(), prodSearchCond.getKeywords(), prodSearchCond.getLabelIds(),
						prodSearchCond.getPsTags(), prodSearchCond.getSize(), prodSearchCond.getSortField(),
						prodSearchCond.getSortOrder());

				List<PsProductVO> productList = mcPsProductService.findBrandsListByProdSearchCondVO(code, campaignCond,
						prodSearchCond);
				page = getPage(productList);
				// page = getProductsByES(code, prodSearchCond, campaignCond);
			} else if (StringUtils.isNotBlank(keyword)) {
				logger.info("关键字搜索 keyword={}", keyword);
				PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
				ProdSearchCond prodSearchCond = new ProdSearchCond();
				prodSearchCond.setChannelCode(code);
				prodSearchCond.setFrom(offset);
				prodSearchCond.setSize(limit);
				if (sort != null) {
					logger.info("关键字搜索排序 sort={},sortOrder={}", sort.getName(), sortOrder);
					prodSearchCond.setSortField(sort.getName());
					prodSearchCond.setSortOrder(sortOrder);
				}

				if (StringUtils.isNotBlank(keyword)) {
					try {
						prodSearchCond.setKeywords(URLDecoder.decode(keyword, "UTF-8"));
					} catch (UnsupportedEncodingException e) {
						logger.info("设置 keywork  中文 转码！");
					}
				}
				if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {
					prodSearchCond.setCategoryCodes(condCategorys);
				}
				if (null != condLabels && !CollectionUtils.isEmpty(condLabels) && condLabels.size() > 0) {
					prodSearchCond.setLabelIds(condLabels);
				}
				if (null != condBrandIds && !CollectionUtils.isEmpty(condBrandIds) && condBrandIds.size() > 0) {
					prodSearchCond.setBrandIds(condBrandIds);
				}
				// 打点参数
				TrackSearchDataCond trackCond = new TrackSearchDataCond();
				trackCond.setMemberId(member.getId());
				trackCond.setMemberCode(member.getCode());
				trackCond.setAccessWay(accessWay.getCode().shortValue());
				trackCond.setBeastId(commonParams.getTbsId());
				trackCond.setChannelCode(code);
				trackCond.setDeviceId(commonParams.getDeviceId());
				trackCond.setMemberLevel(member.getMemberLevel().shortValue());
				prodSearchCond.setTrackSearchDataCond(trackCond);
				page = getProductsByES(code, prodSearchCond, campaignCond);

			} else if (campaignId != null) {
				logger.info("活动搜索campaignId={}", campaignId);
				PsCampaignSearchCond cond = new PsCampaignSearchCond();
				cond.setAccessWay(accessWay.getCode());
				cond.setChannelCode(code);
				cond.setMemberLevel(memberLevel.getCode());
				cond.setDiscount(memberLevel.getLevelAmountCondition());
				cond.setCampaignIds(Lists.newArrayList(campaignId));
				if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {
					cond.setCategoryCodes(condCategorys);
				}
				if (null != condLabels && !CollectionUtils.isEmpty(condLabels) && condLabels.size() > 0) {
					cond.setLabelIds(condLabels);
				}
				if (null != condBrandIds && !CollectionUtils.isEmpty(condBrandIds) && condBrandIds.size() > 0) {
					cond.setBrandIds(condBrandIds);
				}

				cond.setChannelCode(code);
				cond.setFrom(offset);
				cond.setSize(limit);
				cond.setSortField(sortField.getName());
				cond.setSortOrder(sortOrder);
				cond.setBdDiscount(member.getBdayDiscountRatio());
				logger.info(
						"merchandise参数 accessway={},memberlevel={},discount={},campaignids={},categoryCodes={},code={},"
								+ "offset={},limit={},sortField={},sortOrder={},bddiscount={}",
						accessWay.getCode(), memberLevel.getCode(), memberLevel.getLevelAmountCondition(), campaignId,
						categoryCodes, code, offset, limit, sortField.getName(), sortOrder,
						member.getBdayDiscountRatio());
				List<PsProductVO> products = mcPsProductService.findByCampaignSearchCond(cond);
				page = getPage(products);
			} else if (listId != null) {
				// 通过list查询商品列表
				ProductSortField productSortField = null;
				switch (sortField){
					case PRICE:
						productSortField= ProductSortField.PRICE;
						break;
					default:
						productSortField=ProductSortField.RELEASE;
				}
				logger.info("list搜索listId={}", listId);
				page = listService.findById(listId, offset, limit, productSortField, sortOrder, opChannel.getCode(), member,
						accessWay);
			} else if ("discount".equals(param)) {
				logger.info("折扣搜索");

				PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
				ProdSearchCond prodSearchCond = new ProdSearchCond();
				prodSearchCond.setChannelCode(code);
				prodSearchCond.setFrom(offset);
				prodSearchCond.setSize(limit);
				prodSearchCond.setSortField(sortField.getName());
				prodSearchCond.setSortOrder(sortOrder);
				prodSearchCond.setCategoryCodes(condCategorys);
				prodSearchCond.setLabelIds(condLabels);
				prodSearchCond.setBrandIds(condBrandIds);
				page = getPage(
						mcPsProductService.findDiscountListByProdSearchCondVO(code, campaignCond, prodSearchCond));
			} else {
				logger.info("其他搜索");
				PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
				ProdSearchCond prodSearchCond = new ProdSearchCond();
				prodSearchCond.setChannelCode(code);
				prodSearchCond.setIsNew(isNew);
				prodSearchCond.setFrom(offset);
				prodSearchCond.setSize(limit);
				prodSearchCond.setSortField(sortField.getName());
				prodSearchCond.setSortOrder(sortOrder);
				prodSearchCond.setIsCrossBorder(overseas);
				if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {
					prodSearchCond.setCategoryCodes(condCategorys);
				}
				if (null != condLabels && !CollectionUtils.isEmpty(condLabels) && condLabels.size() > 0) {
					prodSearchCond.setLabelIds(condLabels);
				}
				if (null != condBrandIds && !CollectionUtils.isEmpty(condBrandIds) && condBrandIds.size() > 0) {
					prodSearchCond.setBrandIds(condBrandIds);
				}
				if (null != tbsSource && (tbsSource.equals("2") || tbsSource.endsWith("3"))) {
					prodSearchCond.setIsCrossBorder(false);
				}
				page = getProductsByES(code, prodSearchCond, campaignCond);
			}
		}

		List<SimpleProductVO> simpleProducts = new ArrayList<SimpleProductVO>();
		if (page.getTotal() > 0) {
			simpleProducts = adapter.getSimpleProducts(Lists.newArrayList(page.getItems()), member, opChannel,
					accessWay);
			sortBySoldOut(simpleProducts);
		}
		rtPage.setItems(simpleProducts);
		rtPage.setTotal(page.getTotal());

		// 设置水印
		// waterMarkAdapter.setWaterMarkByPage(rtPage);
		return JsonApiResult.ofSuccessResult(rtPage);
	}

	@SuppressWarnings("unchecked")
	private void checkSelectedIdsWithDefaultIds(List selectedIds, List defaultIds) {
		if (CollectionUtils.isNotEmpty(defaultIds)) {
			if (CollectionUtils.isNotEmpty(selectedIds)) {
				selectedIds.retainAll(defaultIds);
			} else {
				selectedIds.addAll(defaultIds);
			}
		}
	}

	@SuppressWarnings("unchecked")
	private void checkSelectedIdsWithDefaultCateIds(List selectedIds, List defaultIds) {
		if (CollectionUtils.isNotEmpty(defaultIds)) {
			if (CollectionUtils.isNotEmpty(selectedIds)) {
				// selectedIds.retainAll(defaultIds);
			} else {
				selectedIds.addAll(defaultIds);
			}
		}
	}

	/**
	 * 搜索关键字
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/keywords", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult searchKeywords(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		Integer offset = jsonData.getInteger("offset");
		Integer limit = jsonData.getInteger("limit");
		String keywords = jsonData.getString("keywords");
		SearchSortField sortField = jsonData.getObject("sortField", SearchSortField.class);
		sortField = getSortFieldOrDefaultValue(sortField);
		AppCommonParams commonParams = jsonData.getObject("commonParams", AppCommonParams.class);

		String sortOrder = jsonData.getString("sortOrder");

		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
		ProdSearchCond prodSearchCond = new ProdSearchCond();
		prodSearchCond.setChannelCode(code);
		prodSearchCond.setFrom(offset);
		prodSearchCond.setSize(limit);
		// track cond
		TrackSearchDataCond trackCond = new TrackSearchDataCond();
		trackCond.setMemberId(member.getId());
		trackCond.setMemberCode(member.getCode());
		trackCond.setAccessWay(accessWay.getCode().shortValue());
		trackCond.setBeastId(commonParams.getTbsId());
		trackCond.setChannelCode(code);
		trackCond.setDeviceId(commonParams.getDeviceId());
		trackCond.setMemberLevel(member.getMemberLevel().shortValue());
		prodSearchCond.setTrackSearchDataCond(trackCond);

		if (StringUtils.isNotBlank(keywords)) {
			try {
				prodSearchCond.setKeywords(URLDecoder.decode(keywords, "UTF-8"));
			} catch (UnsupportedEncodingException e) {
				logger.info("设置 keyworks  中文 转码！");
			}
		}
		Page<PsProductVO> page = getProductsByES(code, prodSearchCond, campaignCond);
		List<SimpleProductVO> simpleProducts = new ArrayList<SimpleProductVO>();
		if (page.getTotal() > 0) {
			simpleProducts = adapter.getSimpleProducts(Lists.newArrayList(page.getItems()), member, opChannel,
					accessWay);
			sortBySoldOut(simpleProducts);
		}
		Page<SimpleProductVO> rtPage = new Page<SimpleProductVO>(
				new Pagination(offset, limit, new Sort(sortField.getName(), sortOrder)));
		rtPage.setItems(simpleProducts);
		rtPage.setTotal(page.getTotal());

		return JsonApiResult.ofSuccessResult(rtPage);
	}

	private void sortBySoldOut(List<SimpleProductVO> list) {
		if (CollectionUtils.isNotEmpty(list)) {
			// 排序 根据soldout
			Collections.sort(list, new Comparator<SimpleProductVO>() {
				@Override
				public int compare(SimpleProductVO o1, SimpleProductVO o2) {
					int a = o1.getSoldOut() ? 1 : 0;
					int b = o2.getSoldOut() ? 1 : 0;
					return (a - b);
				}
			});
		}
	}

	/**
	 * 类目筛选
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/filter", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult filter(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long campaignId = jsonData.getLong("campaignId");
		Long listId = jsonData.getLong("listId");
		Long shopId = jsonData.getLong("shopId");
		List<String> categoryCodes = JSON.parseArray(jsonData.getString("categoryCodes"), String.class);
		Boolean isNew = jsonData.getBoolean("isNew");
		List<String> brandIds = JSON.parseArray(jsonData.getString("brandId"), String.class);
		SearchSortField sortField = jsonData.getObject("sortField", SearchSortField.class);
		sortField = getSortFieldOrDefaultValue(sortField);
		String selected = jsonData.getString("selected");

		String sortOrder = jsonData.getString("sortOrder");
		Integer offset = jsonData.getInteger("offset");
		Integer limit = jsonData.getInteger("limit");
		String param = jsonData.getString("param");
		Boolean special = jsonData.getBoolean("special");

		Integer buId = jsonData.getInteger("buId");
		String keyword = jsonData.getString("keyword");

		String attributeId = jsonData.getString("attributeId");
		String dimensionId = jsonData.getString("dimensionId");
		List<String> labelIds = JSON.parseArray(jsonData.getString("labelIds"), String.class);
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		Long memberId = jsonData.getLong("memberId");
		MemberVO member = memberQueryService.getById(memberId);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());

		List<FilterVO> filters = new ArrayList<FilterVO>();

		if (listId != null && (shopId == null || shopId.equals("") || shopId.intValue() == 0)
				&& !CollectionUtils.isNotEmpty(categoryCodes)) {
			logger.info("没有类目显示全部 categoryFilter:{}");
		} else {

			// ====参数处理======//
			List<String> selectedCategoryCode = new ArrayList<>();// 商品服务查询用类目id
			List<String> selectedBrandIds = new ArrayList<>();// 商品服务查询用品牌id
			List<String> selectedLabelIds = new ArrayList<>();// 商品服务查询用品牌id

			convertSelectedParameter(selected, selectedCategoryCode, selectedBrandIds, selectedLabelIds);

			List categories = null;
			List<PcsBrandVO> brands = null;
			List<OpLabelVO> labels = null;
			if (buId > -1) {
				logger.info("bu商品类目筛选 buId ={}" + buId);

				ProdSearchCond condCategories = createProdSearchCond(code, null, brandIds, null);
				condCategories.setBu(PcsSkuBuEnum.getBuNameByVal(buId));
				categories = mcPsProductService.queryBuCategoryBrandLabel(condCategories).getCategoryList();

				ProdSearchCond condBrand = createProdSearchCond(code, selectedCategoryCode, brandIds, null);
				condBrand.setBu(PcsSkuBuEnum.getBuNameByVal(buId));
				brands = mcPsProductService.queryBrandsCategoryBrandLabel(condBrand).getBrands();

				ProdSearchCond condLabel = createProdSearchCond(code, selectedCategoryCode, selectedBrandIds, null);
				condLabel.setBu(PcsSkuBuEnum.getBuNameByVal(buId));

				labels = mcPsProductService.queryBrandsCategoryBrandLabel(condLabel).getLabels();

			} else if (CollectionUtils.isNotEmpty(brandIds)) {
				// List<Long> allCategoryIds =
				// categoryFrontService.getAllCategories();
				// logger.info("brandIds类目筛选类目id：" + categoryCodes);
				// categories =
				// categoryFrontService.getCategoriesByIds(allCategoryIds);
				// logger.info("brandIds类目筛选类目查询结果：" + categoryCodes);
				// brands = getBrandsOld(code, allCategoryIds, brandIds, null);
				// labels = getLabelsOld(code, allCategoryIds, brandIds);

				// logger.info("brandIds类目筛选类目brandIds={},selectedLabelIds={},selectedCategoryCode={}",
				// brandIds,
				// selectedLabelIds, selectedCategoryCode);
				categories = mcPsProductService
						.queryBrandsCategoryBrandLabel(createProdSearchCond(code, null, brandIds, null))
						.getCategoryList();

				// logger.info("brandIds类目筛选类目查询结果：" + categories);

				brands = mcPsProductService
						.queryBrandsCategoryBrandLabel(createProdSearchCond(code, selectedCategoryCode, brandIds, null))
						.getBrands();
				logger.info("brandIds品牌查询结果：" + brands);

				checkSelectedIdsWithDefaultCateIds(selectedBrandIds, brandIds);
				labels = mcPsProductService.queryBrandsCategoryBrandLabel(
						createProdSearchCond(code, selectedCategoryCode, selectedBrandIds, null)).getLabels();
				// logger.info("brandIds标签查询结果：" + labels);
			} else if (StringUtils.isNotBlank(attributeId) && StringUtils.isNotBlank(dimensionId)) {
				logger.info("attributeId类目筛选类目id：" + categoryCodes);
				ProdSearchCond prodSearchCond = createProdSearchCond(code, null, null, null);
				prodSearchCond.setSkuAttrId(Long.parseLong(dimensionId));
				prodSearchCond.setSkuAttrValueId(Long.parseLong(attributeId));
				categories = mcPsProductService.queryProdListCategoryBrandLabelBySkuAttribute(prodSearchCond)
						.getCategoryList();
				// logger.info("discount类目筛选类目查询结果：" + categoryCodes);

				ProdSearchCond prodSearchCondb = createProdSearchCond(code, selectedCategoryCode, null,
						selectedLabelIds);
				prodSearchCondb.setSkuAttrId(Long.parseLong(dimensionId));
				prodSearchCondb.setSkuAttrValueId(Long.parseLong(attributeId));
				brands = mcPsProductService.queryProdListCategoryBrandLabelBySkuAttribute(prodSearchCondb).getBrands();

				ProdSearchCond prodSearchCondl = createProdSearchCond(code, selectedCategoryCode, selectedBrandIds,
						null);
				prodSearchCondl.setSkuAttrId(Long.parseLong(dimensionId));
				prodSearchCondl.setSkuAttrValueId(Long.parseLong(attributeId));
				labels = mcPsProductService.queryProdListCategoryBrandLabelBySkuAttribute(prodSearchCondl).getLabels();
			} else if (CollectionUtils.isNotEmpty(labelIds)) {

				logger.info("标签查询参数 labelIds={}", labelIds);
				List<String> labelList = mcOpLabelService.findParentIdAndSelfByLabelId(labelIds);

				logger.info("查询后标签 labelList={}", labelList);

				logger.info("labelIds类目筛选类目id：" + categoryCodes);
				categories = mcPsProductService
						.queryProdListCategoryBrandLabelByLabel(createProdSearchCond(code, null, null, labelList))
						.getCategoryList();
				// checkSelectedIdsWithDefaultCateIds(selectedLabelIds,
				// labelIds);
				brands = mcPsProductService.queryProdListCategoryBrandLabelByLabel(
						createProdSearchCond(code, selectedCategoryCode, null, labelList)).getBrands();
				logger.info("brandIds品牌查询结果：" + brands);

				logger.info("查询标签参数code={},selectedCategoryCode={},selectedBrandIds={},labelList={}", code,
						selectedCategoryCode, selectedBrandIds, labelList);
				labels = mcPsProductService
						.queryProdListCategoryBrandLabelByLabel(
								createProdSearchCond(code, selectedCategoryCode, selectedBrandIds, labelList))
						.getLabels();

			} else if ("discount".equals(param)) {
				logger.info("discount类目筛选类目id：" + categoryCodes);

				PsMatchCampaignCond cond = new PsMatchCampaignCond();
				cond.setAccessWay(accessWay.getCode());
				cond.setMemberLevel(memberLevel.getCode());
				logger.info("accessWay={},memberlevel={}", accessWay.getCode(), memberLevel.getCode());

				categories = mcPsProductService
						.queryDiscountCategoryBrandLabel(createProdSearchCond(code, null, null, null), cond)
						.getCategoryList();

				// logger.info("discount类目筛选类目查询结果：" + categoryCodes);
				brands = mcPsProductService
						.queryDiscountCategoryBrandLabel(
								createProdSearchCond(code, selectedCategoryCode, null, selectedLabelIds), cond)
						.getBrands();
				labels = mcPsProductService
						.queryDiscountCategoryBrandLabel(
								createProdSearchCond(code, selectedCategoryCode, selectedBrandIds, null), cond)
						.getLabels();
			} else if (StringUtils.isNotBlank(keyword)) {

				logger.info("keyword类目筛选类目keyword=：" + keyword);

				logger.info("keyword类目筛选类目id：" + categoryCodes);

				ProdSearchCond prodSearchCondC = new ProdSearchCond();
				prodSearchCondC.setChannelCode(code);
				try {
					prodSearchCondC.setKeywords(URLDecoder.decode(keyword, "UTF-8"));
				} catch (UnsupportedEncodingException e) {
					logger.info("设置 keywork  中文 转码！");
				}
				categories = mcPsProductService.queryKeySearchBrandLabel(prodSearchCondC).getCategoryList();

				// logger.info("keyword类目筛选类目查询结果：" + categories);

				ProdSearchCond prodSearchCondB = new ProdSearchCond();
				prodSearchCondB.setChannelCode(code);
				prodSearchCondB.setCategoryCodes(selectedCategoryCode);
				prodSearchCondB.setLabelIds(selectedLabelIds);
				try {
					prodSearchCondB.setKeywords(URLDecoder.decode(keyword, "UTF-8"));
				} catch (UnsupportedEncodingException e) {
					logger.info("设置 keywork  中文 转码！");
				}
				brands = mcPsProductService.queryKeySearchBrandLabel(prodSearchCondB).getBrands();
				logger.info("keyword类目筛选类目查询结果brands=" + brands);

				ProdSearchCond prodSearchCondL = new ProdSearchCond();
				prodSearchCondL.setChannelCode(code);
				prodSearchCondL.setCategoryCodes(selectedCategoryCode);
				prodSearchCondL.setBrandIds(selectedBrandIds);
				try {
					prodSearchCondL.setKeywords(URLDecoder.decode(keyword, "UTF-8"));
				} catch (UnsupportedEncodingException e) {
					logger.info("设置 keywork  中文 转码！");
				}
				labels = mcPsProductService.queryKeySearchBrandLabel(prodSearchCondL).getLabels();
				// logger.info("keyword类目筛选类目查询结果labels=" + labels);

			} else if (BooleanUtils.isTrue(isNew)) {
				// logger.info("isNew类目筛选类目id：" + categoryCodes);
				categories = mcPsProductService
						.queryNewtCategoryBrandLabel(createProdSearchCond(code, null, null, null)).getCategoryList();

				// logger.info("isNew类目筛选类目查询结果：" + categoryCodes);
				brands = mcPsProductService.queryNewtCategoryBrandLabel(
						createProdSearchCond(code, selectedCategoryCode, null, selectedLabelIds)).getBrands();
				labels = mcPsProductService.queryNewtCategoryBrandLabel(
						createProdSearchCond(code, selectedCategoryCode, selectedBrandIds, null)).getLabels();
			} else if (BooleanUtils.isTrue(special)) {
				// logger.info("special类目筛选类目id：" + categoryCodes);
				categories = mcPsProductService
						.querySpecialDiscountBrandLabel(createProdSearchCond(code, null, null, null)).getCategoryList();
				// logger.info("special类目筛选类目查询结果：" + categoryCodes);
				brands = mcPsProductService.querySpecialDiscountBrandLabel(
						createProdSearchCond(code, selectedCategoryCode, null, selectedLabelIds)).getBrands();
				labels = mcPsProductService.querySpecialDiscountBrandLabel(
						createProdSearchCond(code, selectedCategoryCode, selectedBrandIds, null)).getLabels();
			} else if (StringUtils.isNotBlank(keyword)) {
				// logger.info("keyword类目筛选类目id：" + categoryCodes);
				categories = mcPsProductService
						.querySpecialDiscountBrandLabel(createProdSearchCond(code, null, null, null)).getCategoryList();
				// logger.info("keyword类目筛选类目查询结果：" + categoryCodes);
				brands = mcPsProductService.querySpecialDiscountBrandLabel(
						createProdSearchCond(code, selectedCategoryCode, null, selectedLabelIds)).getBrands();
				labels = mcPsProductService.querySpecialDiscountBrandLabel(
						createProdSearchCond(code, selectedCategoryCode, selectedBrandIds, null)).getLabels();
			} else {
				if (categoryCodes == null) {
					categoryCodes = new ArrayList<>();
				}
				categoryCodes.addAll(convertShopIdToCategoryCodes(shopId));
				if (CollectionUtils.isEmpty(categoryCodes)) {
					categoryCodes = Lists.transform(
							categoryFrontService.getCategoriesByIds(categoryFrontService.getAllCategories()),
							new Function<CategoryFront, String>() {
								@Override
								public String apply(CategoryFront item) {
									return item.getCode();
								}
							});
				}
				checkSelectedIdsWithDefaultCateIds(selectedCategoryCode, categoryCodes);
				// logger.info("shopId类目筛选类目id：" + categoryCodes);
				categories = mcPsProductService
						.queryCategoryBrandLabelByCodes(createProdSearchCond(code, categoryCodes, null, null))
						.getCategoryList();

				// logger.info("shopId类目筛选类目查询结果：" + categoryCodes);
				brands = mcPsProductService.queryCategoryBrandLabelByCodes(
						createProdSearchCond(code, selectedCategoryCode, null, selectedLabelIds)).getBrands();
				labels = mcPsProductService.queryCategoryBrandLabelByCodes(
						createProdSearchCond(code, selectedCategoryCode, selectedBrandIds, null)).getLabels();
			}
			addCategoryItemsToFilters(filters, categories);
			addBrandItemsToFilters(filters, brands);
			addLabelItemsToFilters(filters, labels);
		}
		return JsonApiResult.ofSuccessResult(filters);
	}

	private List<String> convertShopIdToCategoryCodes(Long shopId) {
		// 根据店铺查询category
		if (null != shopId && shopId.intValue() != 0) {
			ServiceResp<StoreVO> resp = storeService.getStoreById(shopId);
			if (resp.isSuccess()) {
				String cate = resp.getBean().getCategories();
				// ShopEntry shopEntry = shopService.selectByPrimaryKey(shopId);
				// if (null != shopEntry) {
				// String cate = shopEntry.getCategoryId();
				if (StringUtils.isNotBlank(cate)) {
					List<String> codes = Lists.newArrayList(cate.split(","));
					if (CollectionUtils.isNotEmpty(codes)) {
						// logger.info("===当前店铺是 shopId = {}，包含目录 codes = {}",
						// shopId, codes);
						return codes;
					}
				}
			}
		}
		return new ArrayList<>();
	}

	private void convertSelectedParameter(String selected, List<String> selectedCategoryCode,
			List<String> selectedBrandIds, List<String> selectedLabelIds) {
		// selected参数拆解
		List<String> selects = new ArrayList<String>();
		if (null != selected && !selected.equals("")) {
			selects = Arrays.asList(selected.split(","));
			if (selects != null && selects.size() > 0) {
				String selectedCategoryString = selects.get(0);
				String selectedBrandString = "";
				String selectedLabelString = "";

				if (selects.size() > 1) {
					selectedBrandString = selects.get(1);
				}
				if (selects.size() > 2) {
					selectedLabelString = selects.get(2);
				}

				// 类目参数处理
				if (null != selectedCategoryString && !selectedCategoryString.equals("")) {
					List<String> selectedCates = Lists.newArrayList(selectedCategoryString.split("_"));
					// logger.info("===selected参数 类目Id selectedCateIds ={} ",
					// selectedCates);
					if (CollectionUtils.isNotEmpty(selectedCates)) {
						selectedCategoryCode.addAll(selectedCates);
					}
				}

				// 品牌参数处理
				if (null != selectedBrandString && !selectedBrandString.equals("")) {
					List<String> selectedBrands = Lists.newArrayList(selectedBrandString.split("_"));
					// logger.info("===selected参数 品牌Id selectedBrands ={} ",
					// selectedBrands);
					if (CollectionUtils.isNotEmpty(selectedBrands)) {
						selectedBrandIds.addAll(selectedBrands);
					}
				}

				// 标签参数处理
				if (null != selectedLabelString && !selectedLabelString.equals("")) {
					List<String> selectedLabels = Lists.newArrayList(selectedLabelString.split("_"));
					if (CollectionUtils.isNotEmpty(selectedLabels)) {
						for (String selectedLabel : selectedLabels) {
							selectedLabelIds.addAll(Arrays.asList(selectedLabel.split("-")));
						}
					}
					// logger.info("===selected参数 标签Id selectedLabels ={} ",
					// selectedLabelIds);
				}
			}
		}
	}

	private PsMatchCampaignCond createMatchCampaignCond(MemberVO member, AccessWayEnum accessWay, String code) {
		PsMatchCampaignCond campaignCond = new PsMatchCampaignCond();

		campaignCond.setMatchCampaign(true);
		campaignCond.setAccessWay(accessWay.getCode());
		campaignCond.setChannelCode(code);
		if(member != null){
			MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
			campaignCond.setMemberLevel(memberLevel.getCode());
			campaignCond.setDiscount(memberLevel.getLevelAmountCondition());
			campaignCond.setBdDiscount(member.getBdayDiscountRatio());
		}else{
			campaignCond.setDiscount(BigDecimal.valueOf(1));
		}

		return campaignCond;
	}

	private ProdSearchCond createProdSearchCond(String channelCode, List<String> categoryCodes, List<String> brandIds,
			List<String> labelIds) {
		ProdSearchCond prodSearchCond = new ProdSearchCond();
		prodSearchCond.setChannelCode(channelCode);
		prodSearchCond.setCategoryCodes(categoryCodes);
		prodSearchCond.setBrandIds(brandIds);
		prodSearchCond.setLabelIds(labelIds);
		prodSearchCond.setChannelCode(channelCode);
		// logger.info("搜索参数channelCode={}，categoryCodes={}，brandIds={}，labelIds{}",
		// channelCode, categoryCodes, brandIds,
		// labelIds);
		return prodSearchCond;
	}

	private FilterVO createFilterVO(List<Item> items, String name, boolean isIndependent, boolean isSortable) {
		FilterVO filterVO = new FilterVO();
		filterVO.setItems(items);
		filterVO.setName(name);
		filterVO.setIndependent(isIndependent);
		filterVO.setSortable(isSortable);
		return filterVO;
	}

	private void addCategoryItemsToFilters(List<FilterVO> filters, List categories) {
		List<Item> categoryItems = new ArrayList<Item>();
		if (CollectionUtils.isNotEmpty(categories)) {
			for (Object object : categories) {
				if (object instanceof CategoryFront) {
					CategoryFront categoryFront = (CategoryFront) object;
					Item item = new Item();
					item.setId(categoryFront.getCode());
					String[] names = categoryFront.getName().split("-");
					item.setName(names.length > 0 ? names[names.length - 1] : "");
					categoryItems.add(item);
				}
				if (object instanceof PcsSkuCategoryVO) {
					PcsSkuCategoryVO pcsSkuCategoryVO = (PcsSkuCategoryVO) object;
					Item item = new Item();
					item.setId(pcsSkuCategoryVO.getCode());
					String[] names = pcsSkuCategoryVO.getName().split("-");
					item.setName(names.length > 0 ? names[names.length - 1] : "");
					categoryItems.add(item);
				}
			}
		}
		filters.add(createFilterVO(categoryItems, "分类", false, false));
	}

	private void addBrandItemsToFilters(List<FilterVO> filters, List<PcsBrandVO> brands) {
		List<Item> brandItems = new ArrayList<Item>();
		if (CollectionUtils.isNotEmpty(brands)) {
			for (PcsBrandVO brand : brands) {
				Item item = new Item();
				item.setId(brand.getId().toString());
				item.setName(brand.getName());
				brandItems.add(item);
			}
		}
		filters.add(createFilterVO(brandItems, "品牌", false, true));
	}

	private void addLabelItemsToFilters(List<FilterVO> filters, List<OpLabelVO> labels) {
		List<Item> labelItems = new ArrayList<>();
		Multimap<String, OpLabelVO> opLabelVOMultimap = Multimaps.index(labels, new Function<OpLabelVO, String>() {
			public String apply(OpLabelVO opLabelVO) {
				return opLabelVO.getNameCn();
			}
		});
		for (Map.Entry<String, Collection<OpLabelVO>> entry : opLabelVOMultimap.asMap().entrySet()) {
			Item item = new Item();
			item.setId(StringUtils.join(Iterables.transform(entry.getValue(), new Function<OpLabelVO, Long>() {
				public Long apply(OpLabelVO opLabelVO) {
					return opLabelVO.getId();
				}
			}), "-"));
			item.setName(entry.getKey());
			labelItems.add(item);
		}
		filters.add(createFilterVO(labelItems, "热门标签", false, false));
	}

	/**
	 * 类目筛选
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/suggest", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult suggest(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		// HotKeyVO hotKeys = new HotKeyVO();
		List<HotKey> list = new ArrayList<HotKey>();
		// rpc search recommend config
		List<SearchRecommendVO> vos = searchRecommendService.findCurrentLastOnlineByType(SearchRecommendTypeEnum.HOT,
				TerminalEnum.PC);
		for (SearchRecommendVO vo : vos) {
			HotKey hotKey = new HotKey();
			hotKey.setType(HotKeyType.KEYWORD);
			hotKey.setName(vo.getKeyWord());
			list.add(hotKey);
		}

		List<SearchRecommendVO> voss = searchRecommendService
				.findCurrentLastOnlineByType(SearchRecommendTypeEnum.DEFAULT, TerminalEnum.PC);
		String keyWord = "";
		if (CollectionUtils.isNotEmpty(voss)) {
			keyWord = voss.get(0).getKeyWord();
		}
		Map<String, Object> datas = new HashMap<>();
		datas.put("hotKeys", list);
		datas.put("keyword", keyWord);
		return JsonApiResult.ofSuccessResult(datas);
	}

	/**
	 * 搜索关键字
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/keywordWithSuggest", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult searchKeywordWithSuggest(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		Integer offset = jsonData.getInteger("offset");
		Integer limit = jsonData.getInteger("limit");
		String keyword = jsonData.getString("keyword");

		SearchSortField sort = jsonData.getObject("sortField", SearchSortField.class);
		SearchSortField sortField = jsonData.getObject("sortField", SearchSortField.class);
		sortField = getSortFieldOrDefaultValue(sortField);
		AppCommonParams commonParams = jsonData.getObject("commonParams", AppCommonParams.class);
		String sortOrder = jsonData.getString("sortOrder");

		String selected = jsonData.getString("selected");
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		// ====参数处理======//
		List<String> condCategorys = new ArrayList<>();// 商品服务查询用类目id
		List<String> condBrandIds = new ArrayList<>();// 商品服务查询用品牌id
		List<String> condLabels = new ArrayList<>();// 商品服务查询用标签id

		convertSelectedParameter(selected, condCategorys, condBrandIds, condLabels);

		// logger.info(
		// "参数
		// offset={},limit={},keyword={},sortOrder={},selected={},condCategorys={},condBrandIds={},condLabels={}",
		// offset, limit, keyword, sortOrder, selected, condCategorys,
		// condBrandIds, condLabels);

		PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
		ProdSearchCond prodSearchCond = new ProdSearchCond();
		prodSearchCond.setChannelCode(code);
		prodSearchCond.setFrom(offset);
		prodSearchCond.setSize(limit);
		if (StringUtils.isNotBlank(keyword)) {
			try {
				prodSearchCond.setKeywords(URLDecoder.decode(keyword, "UTF-8"));
			} catch (UnsupportedEncodingException e) {
				logger.info("设置 keyworks  中文 转码！");
			}
		}
		if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {
			prodSearchCond.setCategoryCodes(condCategorys);
		}
		if (null != condLabels && !CollectionUtils.isEmpty(condLabels) && condLabels.size() > 0) {
			prodSearchCond.setLabelIds(condLabels);
		}
		if (null != condBrandIds && !CollectionUtils.isEmpty(condBrandIds) && condBrandIds.size() > 0) {
			prodSearchCond.setBrandIds(condBrandIds);
		}
		if (sort != null) {
			// logger.info("关键字搜索排序 sort={},sortOrder={}", sort.getName(),
			// sortOrder);
			prodSearchCond.setSortField(sort.getName());
			prodSearchCond.setSortOrder(sortOrder);
		}
		// track cond
		TrackSearchDataCond trackCond = new TrackSearchDataCond();
		trackCond.setMemberId(member.getId());
		trackCond.setMemberCode(member.getCode());
		trackCond.setAccessWay(accessWay.getCode().shortValue());

		if (commonParams != null) {
			trackCond.setBeastId(commonParams.getTbsId());
			trackCond.setDeviceId(commonParams.getDeviceId());
		}

		trackCond.setChannelCode(code);

		trackCond.setMemberLevel(member.getMemberLevel().shortValue());
		prodSearchCond.setTrackSearchDataCond(trackCond);
		ProductListVO productList = new ProductListVO();
		Page<PsProductVO> page = getProductsByES(code, prodSearchCond, campaignCond);

		Suggest suggest = new Suggest();
		if (CollectionUtils.isNotEmpty(page.getItems())) {
			List<PsProductVO> ps = Lists.newArrayList(page.getItems());
			PsProductVO pro = ps.get(0);
			if (CollectionUtils.isNotEmpty(pro.getAnalysis())) {
				List<String> analysis = pro.getAnalysis();
				if (StringUtils.isNoneBlank(analysis.get(0))) {
					// logger.info("推荐关键字keySuggest={}", analysis.get(0));
					String keySuggest = analysis.get(0);
					suggest.setKeyword(analysis.get(0));
					suggest.setLink("beastapp://index");
					prodSearchCond.setKeywords(keySuggest);
					productList.setSuggest(suggest);
					page = getProductsByES(code, prodSearchCond, campaignCond);
				}
			}
		}

		if (CollectionUtils.isEmpty(page.getItems())) {
			logger.info("搜索无商品");
			suggest.setLink("beastapp://index");
			productList.setSuggest(suggest);
		}
		List<SimpleProductVO> simpleProducts = new ArrayList<SimpleProductVO>();
		if (page.getTotal() > 0) {
			simpleProducts = adapter.getSimpleProducts(Lists.newArrayList(page.getItems()), member, opChannel,
					accessWay);
			sortBySoldOut(simpleProducts);
		}
		Page<SimpleProductVO> rtPage = new Page<SimpleProductVO>(
				new Pagination(offset, limit, new Sort(sortField.getName(), sortOrder)));
		rtPage.setItems(simpleProducts);
		rtPage.setTotal(page.getTotal());
		logger.info("设置查询结果total={}", page.getTotal());
		productList.setList(rtPage);

		// // 设置水印
		// waterMarkAdapter.setWaterMarkByPage(rtPage);
		return JsonApiResult.ofSuccessResult(productList);
	}

	/**
	 * 搜索商品
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/productByList", method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public JsonApiResult searchProductByList(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		logger.info("searchProductByList start");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		Long listId = jsonData.getLong("listId");
		String selected = jsonData.getString("selected");
		SearchSortField sortField = jsonData.getObject("sortField", SearchSortField.class);
		sortField = getSortFieldOrDefaultValue(sortField);

		Page<PsProductVO> page = new Page<PsProductVO>();
		String sortOrder = jsonData.getString("sortOrder");
		Integer offset = jsonData.getInteger("offset");
		Integer limit = jsonData.getInteger("limit");
		ProductListVO productList = new ProductListVO();

		ServiceResp<OpListpageVO> resp = mcOpListpageService.findById(listId.intValue(), true);

		OpListpageVO bean = resp.getBean();

		if(bean == null){
			
			logger.info("searchProductByList 未查到数据。");
			
			return JsonApiResult.ofSuccessResult(productList);
		}
		
		ProductListVO.Banner banner = new ProductListVO.Banner();
		// jumpType 映射，来源于SCM配置 0或空无连接,1专题id,2列表id
		Map<Integer,String> jumpTypeMap = Maps.newHashMapWithExpectedSize(4);
		jumpTypeMap.put(0,"none");
		jumpTypeMap.put(1,"article");
		jumpTypeMap.put(2,"list");

		if("CHN2018".equals(code)){
			if (StringUtils.isNotEmpty(bean.getPcBannerUrl())) {
				banner.setSrc(bean.getPcBannerUrl());
				banner.setHeight(bean.getPcBannerHeight());
				banner.setWidth(bean.getPcBannerWidth());
				banner.setLink(new Link(jumpTypeMap.get(bean.getPcJumpType()),bean.getPcJumpId()));
				productList.setBanner(banner);
			}
		}else{
			if (StringUtils.isNotEmpty(bean.getAppBannerUrl())) {
				banner.setSrc(bean.getAppBannerUrl());
				banner.setHeight(bean.getAppBannerHeight());
				banner.setWidth(bean.getAppBannerWidth());
				banner.setLink(new Link(jumpTypeMap.get(bean.getAppJumpType()),bean.getAppJumpId()));
				productList.setBanner(banner);
			} else {
				productList.setBanner(null);
			}
		}


		List<OpListpageProdVO> list = bean.getProdList();

		List<String> productCodes = new ArrayList<String>();
		List<SimpleProductVO> simpleProducts = new ArrayList<>();
		List<PsProductVO> products = new ArrayList<PsProductVO>();
		if (CollectionUtils.isNotEmpty(list)) {
			for (OpListpageProdVO vo : list) {
				productCodes.add(vo.getProductCode());
			}

			if (CollectionUtils.isNotEmpty(productCodes)) {

				MemberVO member = memberQueryService.getById(memberId);
				OpChannelVO opChannel = mcOpChannelService.findByCode(code);

				// ====参数处理======//
				List<String> condCategorys = new ArrayList<>();// 商品服务查询用类目id
				List<String> condBrandIds = new ArrayList<>();// 商品服务查询用品牌id
				List<String> condLabels = new ArrayList<>();// 商品服务查询用标签id

				convertSelectedParameter(selected, condCategorys, condBrandIds, condLabels);

				PsMatchCampaignCond campaignCond = createMatchCampaignCond(member, accessWay, code);
				ProdSearchCond prodSearchCond = new ProdSearchCond();
				prodSearchCond.setChannelCode(code);
				prodSearchCond.setFrom(offset);
				prodSearchCond.setSize(limit);
				if(sortField !=null ){
					prodSearchCond.setSortField(sortField.getName());
				}

				prodSearchCond.setSortOrder(sortOrder);
				prodSearchCond.setProdCodes(productCodes);
				if (null != condCategorys && !CollectionUtils.isEmpty(condCategorys) && condCategorys.size() > 0) {
					prodSearchCond.setCategoryCodes(condCategorys);
				}
				if (null != condBrandIds && !CollectionUtils.isEmpty(condBrandIds) && condBrandIds.size() > 0) {
					prodSearchCond.setBrandIds(condBrandIds);
				}
				if (null != condLabels && !CollectionUtils.isEmpty(condLabels) && condLabels.size() > 0) {
					prodSearchCond.setLabelIds(condLabels);
				}


					products = mcPsProductService.findProdsByCodes(code,campaignCond, prodSearchCond);
					if (CollectionUtils.isNotEmpty(products)) {
						simpleProducts = adapter.getSimpleProducts(products, member, opChannel, accessWay);
						page = getPage(products);

					}

			}
		}

//		if(!"CHN2018".equals(code)){
//			Page<SimpleProductVO> rtPage = new Page<SimpleProductVO>(
//					new Pagination(offset, limit, new Sort(sortField.getName(), sortOrder)));
//			rtPage.setItems(simpleProducts);
//			rtPage.setTotal(page.getTotal());
//			//logger.info("设置查询结果total={}", page.getTotal());
//			productList.setList(rtPage);
//		}else{
			Page<SimpleProductVO> rtPage = new Page<SimpleProductVO>();
			rtPage.setItems(simpleProducts);
			rtPage.setTotal(page.getTotal());
			rtPage.setLimit(limit);
			rtPage.setOffset(offset);
			rtPage.setSortOrder(sortOrder);
			productList.setList(rtPage);
		//}



		return JsonApiResult.ofSuccessResult(productList);

	}
}