package com.thebeastshop.pegasus.channelservice.controller.sales;

import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.pegasus.service.operation.vo.OpProduceTaskVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.SalesAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.vo.sales.SalesVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.domain.Wait4HandlePackage;
import com.thebeastshop.pegasus.service.operation.enums.ProduceTaskStatusEnum;
import com.thebeastshop.pegasus.service.operation.model.OpSales;
import com.thebeastshop.pegasus.service.operation.vo.OpProduceTaskCondVO;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.common.Pagination;

@Controller("CommonSalesController")
@RequestMapping("/api/sales")
public class SalesController {

	@Autowired
	public SalesAdapter salesAdapter;
	
	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();
	
	/***
	 * 根据渠道取得所有销售店员
	 * @param code
	 * @param data
	 * @return
	 * 取得店员
	 */
	@ApiAuth
	@RequestMapping(value="/searchByCode")
	@ResponseBody
	public JsonApiResult searchByCode(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		
		
		List<OpSales> sales=pcInstance.findSalesByChannelCode(code);
		if(sales!=null){
			
			List<SalesVO> list = new ArrayList<SalesVO>();
			
			for(OpSales sale:sales){
				SalesVO vo = salesAdapter.common(sale);
				list.add(vo);
			}
			
			return JsonApiResult.ofSuccessResult(list);
		}
		return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
	}
	
	/***
	 * 根据渠道取得所有制单任务
	 * @param code
	 * @param data
	 * @return
	 * 取得店员
	 */
	@ApiAuth
	@RequestMapping(value="/searchWaitForTasks")
	@ResponseBody
	public JsonApiResult searchWaitForTasks(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		try{
			List<String> channelList= new ArrayList<>();
			channelList.add(code);
			OpProduceTaskCondVO cond = new OpProduceTaskCondVO();
			cond.setTargetChannelCodeList(channelList);
			cond.setStatus(ProduceTaskStatusEnum.WAIT_FOR_CONFIRM.getId());
			cond.setCurrpage(1);
			Pagination<OpProduceTaskVO> list=pcInstance.getWait4HandlePackageByCond(cond);
			if(list!=null){
				
				
				return JsonApiResult.ofSuccessResult(list.getResultList());
			}else{
				return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(), ErrorCode.DATA_NOT_FOUND.getMesage());
			}
		}catch(Exception e){

		return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),e.getMessage());
		}
	}
	
	/***
	 * 根据渠道取得所有制单任务
	 * @param code
	 * @param data
	 * @return
	 * 取得店员
	 */
	@ApiAuth
	@RequestMapping(value="/searchWaitForTaskCount")
	@ResponseBody
	public JsonApiResult searchWaitForTaskCount(@RequestParam("CODE") String code,@RequestParam("DATA") String data ){
		List<String> channelList= new ArrayList<>();
		channelList.add(code);
		OpProduceTaskCondVO cond = new OpProduceTaskCondVO();
		cond.setTargetChannelCodeList(channelList);
		cond.setStatus(ProduceTaskStatusEnum.WAIT_FOR_CONFIRM.getId());
		cond.setCurrpage(1);
		Integer count=pcInstance.getWait4HandlePackageCountByCond(cond);
        if(count==null){
        	count = 0;

		}
		return JsonApiResult.ofSuccessResult(count);
	}

	/**
	 * 接受店送任务
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/acceptTask")
	@ResponseBody
	public JsonApiResult acceptTask(@RequestParam("CODE") String code, @RequestParam("DATA") String data){
		JSONObject jsonData = JSONObject.parseObject(data);
		try{
			Long taskId = jsonData.getLong("taskId");
			return JsonApiResult.ofSuccessResult(pcInstance.acceptTask(taskId,1l));
		}catch(Exception e){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), e.getMessage());
		}
	}

	/**
	 * 拒绝店送任务
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value="/refuseTask")
	@ResponseBody
	public JsonApiResult refuseTask(@RequestParam("CODE") String code, @RequestParam("DATA") String data){
		JSONObject jsonData = JSONObject.parseObject(data);
		try{
			Long taskId = jsonData.getLong("taskId");
			String remark = jsonData.getString("remark");
			return JsonApiResult.ofSuccessResult(pcInstance.refuseTask(taskId, remark));
		}catch(Exception e){
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), e.getMessage());
		}
	}
}
