package com.thebeastshop.pegasus.channelservice.controller.redenvelope;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.redenvelope.RedEnvelopeAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.redenvelope.RedEnvelopeReceivedAdapter;
import com.thebeastshop.pegasus.component.redenvelope.business.IRedEnvelopeShareService;
import com.thebeastshop.pegasus.component.redenvelope.condition.RedEnvelopeCondition;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.Res;
import com.thebeastshop.support.enums.RedEnvelopeType;
import com.thebeastshop.support.vo.coupon.CouponVO;
import com.thebeastshop.support.vo.redenvelope.ReceiveDTO;
import com.thebeastshop.support.vo.redenvelope.ReceiveDetailsVO;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeRecordVo;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
@RequestMapping(value = "/api/app/redEnvelope")
public class RedenvelopeControllor {

    public Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedEnvelopeAdapter redEnvelopeAdapter;

    @Autowired
    private RedEnvelopeReceivedAdapter redEnvelopeReceivedAdapter;

    private IRedEnvelopeShareService iRedEnvelopeShareService = ComponentServiceLoader.getBean(IRedEnvelopeShareService.class);


    /**
     * 修改手机号
     *
     * @param code
     * @param data
     */
    @ApiAuth
    @RequestMapping(value = "/modifyMobile")
    @ResponseBody
    public JsonApiResult modifyMobile(@RequestParam("CODE") String code,
                                      @RequestParam("DATA") String data) {
        JSONObject jsonData = JSONObject.parseObject(data);
        String mobile = jsonData.getString("mobile");
        String unionId = jsonData.getString("unionId");
        Long memberId = redEnvelopeReceivedAdapter.getMemberIdByUnionId(unionId);
        Boolean status = redEnvelopeAdapter.updateMobile(mobile, memberId);
        return JsonApiResult.ofSuccessResult(status);
    }


    /**
     * 领取红包
     *
     * @param code
     * @param data
     * @return
     */
    @ApiAuth
    @RequestMapping(value = "/received")
    @ResponseBody
    public JsonApiResult received(@RequestParam("CODE") String code,
                                  @RequestParam("DATA") String data) {
        logger.info("入参：Code=[{}],DATA=[{}]", code, data);
        JSONObject jsonData = JSONObject.parseObject(data);
        ReceiveDTO receiveDTO = jsonData.getObject("receive", ReceiveDTO.class);
        ReceiveDetailsVO result = new ReceiveDetailsVO();
        if (StringUtils.isBlank(receiveDTO.getRedEnvelopeId())) {
            result.setAvailable(false);
            return JsonApiResult.ofErrorResult(401,"缺少活动红包id");
        }
        //获取抽奖人和中奖人信息

        Long memberId = redEnvelopeReceivedAdapter.getMemberIdByUnionId(receiveDTO.getUnionId());
        logger.info("根据UNIONID[{}]获取到的memberId为[{}]",receiveDTO.getUnionId(),memberId);
        if(NumberUtil.isNullOrZero(memberId)){
            return  JsonApiResult.ofErrorResult(401,"会员不存在");
        }
        if (StringUtils.isNotEmpty(receiveDTO.getMobile())) {
            boolean flag = redEnvelopeAdapter.updateMobile(receiveDTO.getMobile(), memberId);
            logger.info("更改memberId为[{}]的微信领取手机号为[{}]",memberId,receiveDTO.getMobile());
        }

        String mobile = redEnvelopeReceivedAdapter.getReceivedMobile(memberId,receiveDTO.getMobile());
        MemberVO member = redEnvelopeReceivedAdapter.getMemberByMobile(mobile, code);

        RedEnvelopeCondition condition = new RedEnvelopeCondition();
        condition.setUnionId(receiveDTO.getUnionId());
        condition.setNickName(receiveDTO.getNickName());
        condition.setAvatar(receiveDTO.getAvatar());
        condition.setShareId(receiveDTO.getRedEnvelopeId());
        condition.setMobile(mobile);
        Res<ReceiveDetailsVO> receiveRes = iRedEnvelopeShareService.receiveRedEnvelope(member, condition);
        result = receiveRes.getData();
        CouponVO couponVO = null;
        //新发红包须添加优惠券
        if(NumberUtil.isNullOrZero(receiveRes.getCode())){
            RedEnvelopeRecordVo myRecived = result.getMyReceived();
            if (null != myRecived && myRecived.isFirstReceive()) {
                if ( RedEnvelopeType.COUPON.getValue().equalsIgnoreCase(myRecived.getReceived().getType())) {
                    couponVO = redEnvelopeReceivedAdapter.sendCoupons(member.getId(), Long.parseLong(myRecived.getReceived().getValue()));
                    myRecived.getReceived().setCoupon(couponVO);
                    logger.info("发送优惠券[{}]到会员[{}]结果：{}", myRecived.getReceived().getValue(), memberId, JSONObject.toJSONString(couponVO));
                }
            } else if (null != myRecived && !myRecived.isFirstReceive()) {
                if ( RedEnvelopeType.COUPON.getValue().equalsIgnoreCase(myRecived.getReceived().getType())) {
                    couponVO = redEnvelopeReceivedAdapter.getCouponsBySampleId(Long.parseLong(result.getMyReceived().getReceived().getValue()),result.getMyReceived().getReceiveTime());
                    myRecived.getReceived().setCoupon(couponVO);
                    logger.info("已领取红包结果：{}",  JSONObject.toJSONString(myRecived));
                }
            }
        }else{
            if(couponVO == null && RedEnvelopeType.COUPON.getValue().equalsIgnoreCase(result.getMyReceived().getReceived().getType())){
                couponVO = redEnvelopeReceivedAdapter.getCouponsBySampleId(Long.parseLong(result.getMyReceived().getReceived().getValue()),result.getMyReceived().getReceiveTime());
                result.getMyReceived().getReceived().setCoupon(couponVO);
            }
            result.setDesc("该手机已经领取红包，请更换手机号领取");
        }
        //循环增加优惠券信息，屏蔽历史记录 手机号
        List<RedEnvelopeRecordVo> records = result.getRecords();
        if(CollectionUtils.isNotEmpty(records)){
            for (RedEnvelopeRecordVo recordVo : records){
                if(RedEnvelopeType.COUPON.getValue().equalsIgnoreCase(recordVo.getReceived().getType())){
                    CouponVO coupon = redEnvelopeReceivedAdapter.getCouponsBySampleId(Long.parseLong(recordVo.getReceived().getValue()),recordVo.getReceiveTime());
                    recordVo.getReceived().setCoupon(coupon);
                }
                recordVo.setMobile(null);
            }
        }
        return JsonApiResult.ofSuccessResult(result);
    }
}
