package com.thebeastshop.pegasus.channelservice.controller.product;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvCustomizeAdapter;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.vo.customize.SpvCustomizeDetails;
import com.thebeastshop.support.vo.product.ScanProductVO;
import com.thebeastshop.support.vo.stock.SpvStockVO;

@Controller("productSpvController")
@RequestMapping("/api/prod")
public class ProductSpvController {
	private Logger logger = LoggerFactory.getLogger(ProductSpvController.class);

	@Autowired
	private SpvCustomizeAdapter spvCustomizeAdapter;

	@Autowired
	private McPsProductService mcPsProductService;
	
	@Autowired
	private McPsSpvService mcPsSpvService;

	/**
	 * 获取定制信息
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/spv/customize", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult getProductCustomize(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long spvId = jsonData.getLong("spvId");
		SpvCustomizeDetails result = spvCustomizeAdapter.getSpvCustomizeInfo(spvId);
		return JsonApiResult.ofSuccessResult(result);
	}

	/**
	 * 获取定制信息. spvid 返回规则： 根据sku匹配到的spvid productId匹配但是skuCode不匹配的不返回
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "barcode/simpleProducts")
	@ResponseBody
	public JsonApiResult simpleProductsByBarcode(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String barcode = jsonData.getString("barcode");

		List<PsProductVO> prods = mcPsProductService.findProdsByChnCodeSkuCode(code, barcode);
		List<ScanProductVO> result = Lists.newArrayList();
		List<ScanProductVO> combinedList = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(prods)) {
			for (PsProductVO prod : prods) {
				ScanProductVO scanProductVO = new ScanProductVO();
				scanProductVO.setProductId(prod.getCode());
				if (CollectionUtils.isNotEmpty(prod.getSpvList())) {
					for (PsSpvVO spvVO : prod.getSpvList()) {
						boolean matchFlag = false;
						if (spvVO.getCombined()) {
							List<PsSkuCombinationVO> psSkuCombinationVOS = spvVO.getSkuCombinationList();
							for (PsSkuCombinationVO psSkuCombinationVO : psSkuCombinationVOS) {
								if (barcode.equalsIgnoreCase(psSkuCombinationVO.getSubSkuCode())) {
									scanProductVO.getSpvIds().add(spvVO.getSpvId());
									matchFlag = true;
									break;
								}
							}
						} else if (barcode.equalsIgnoreCase(spvVO.getSkuCode())) {
							matchFlag = true;
						}
						if (matchFlag) {
							scanProductVO.getSpvIds().add(spvVO.getSpvId());
						}

					}
				}
				if(prod.getCombined()){
					combinedList.add(scanProductVO);
				}else{
					result.add(scanProductVO);
				}
			}
		}
		// 组合商品沉底
		if(CollectionUtils.isNotEmpty(combinedList)){
			result.addAll(combinedList);
		}

		return JsonApiResult.ofSuccessResult(result);
	}

}
