package com.thebeastshop.pegasus.channelservice.controller.product;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.kit.redis.util.RedisClient;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.CommonAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductCombinationAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.merchandise.IService.IRecommendService;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McOpProdDynmcontDetailsService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailsSaveVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmTitleVO;
import com.thebeastshop.pegasus.merchandise.vo.PsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PsDynmContentVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsCalcProductDTO;
import com.thebeastshop.price.vo.PrsProductPriceResultVO;
import com.thebeastshop.scm.vo.recommend.OrderFinishRecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendParamVO.Type;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.vo.product.ProductDetailNewVO;
import com.thebeastshop.support.vo.product.ProductDetailNewVO.Image;
import com.thebeastshop.support.vo.product.ProductDetailNewVO.ProductDetail;
import com.thebeastshop.support.vo.product.ProductDetailNewVO.ProductDetailModule;
import com.thebeastshop.support.vo.product.ProductDetailNewVO.TableRow;
import com.thebeastshop.support.vo.product.ProductDetailVO;
import com.thebeastshop.support.vo.product.ProductVO;
import com.thebeastshop.support.vo.product.ProductVariantVO;
import com.thebeastshop.support.vo.product.SPDSimpleProductVO;
import com.thebeastshop.support.vo.product.SimpleProductVO;
import com.thebeastshop.support.vo.product.SpvVO;

@Controller("productController")
@RequestMapping("/api/product")
public class ProductController {
	private Logger logger = LoggerFactory.getLogger(ProductController.class);

	private final String RUSH_ONOFF = "rush_onoff";

	private final String RUSH_LIST = "rush_list";

	@Resource
	private RedisClient redisClient;

	@Autowired
	private PrsPriceService prsPriceService;

	@Autowired
	private PriceAdapter priceAdapter;

	@Autowired
	private CommonAdapter commonAdapter;

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private ProductAdapter adapter;

	@Autowired
	private LogisticsAdapter logisticsAdapter;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McPsSpvService mcPsSpvService;

	@Autowired
	private IRecommendService recommendService;

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private McOpProdDynmcontDetailsService mcOpProdDynmcontDetailsService;
	@Autowired
	private McOpChannelService mcOpChannelService;

	@Autowired
	private EmailSendService emailSendService;

	@Autowired
	ProductCombinationAdapter productCombinationAdapter;

	/**
	 * 推缓存
	 *
	 * @param
	 */
	@RequestMapping(path = "/pushRedis", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult pushRedis(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		commonAdapter.push();
		return JsonApiResult.ofSuccessResult(true);
	}

	/**
	 * 获取一个商品
	 *
	 * @param
	 */
	@RequestMapping(path = "/getProduct", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getProduct(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		JSONObject jsonData = JSONObject.parseObject(data);
		String productCode = jsonData.getString("productCode");// product code
		Long memberId = jsonData.getLong("memberId");
		Boolean isShow = jsonData.getBoolean("isShow");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		MemberVO member = memberQueryService.getById(memberId);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());

		List<String> onoffList = JsonUtil.toList(PropConstants.getProperties(RUSH_ONOFF), String.class);
		Boolean onoffState = commonAdapter.on_off(onoffList.get(0), onoffList.get(1));
		Boolean onlineState = commonAdapter.isOnline(code);
		List<String> rushList = JsonUtil.toList(PropConstants.getProperties(RUSH_LIST), String.class);
		PsProductVO product = null;
		if (onoffState && onlineState && rushList.contains(productCode)) {// 开关期间，且有线上渠道，且抢购商品
			logger.info("redis里取商品");
			product = redisClient.getCache(commonAdapter.buildProductKey(memberLevel.getCode(), productCode));
			if (null == product) {
				logger.info("redis里没取到，push一下");
				product = commonAdapter.pushProduct(productCode, memberLevel);
			}
		} else {

			PsMatchCampaignCond cond = new PsMatchCampaignCond();
			cond.setMatchCampaign(true);
			cond.setChannelCode(code);
			cond.setAccessWay(accessWay.getCode());
			cond.setMemberLevel(memberLevel.getCode());
			cond.setDiscount(memberLevel.getLevelAmountCondition());
			cond.setBdDiscount(member.getBdayDiscountRatio());
			product = mcPsProductService.getProductDetailByCode(code, productCode, cond);
		}
		OpChannelVO opChannel = new OpChannelVO();
		if (onoffState && onlineState && rushList.contains(productCode)) {// 开关期间，且有线上渠道，且抢购商品
			logger.info("从redis获取channel");
			opChannel = redisClient.getCache(commonAdapter.buildChannelKey(code));
			if (null == opChannel) {
				logger.info("从redis没有获取到");
				commonAdapter.pushChannel();
				opChannel = mcOpChannelService.findByCode(code);
			}
		} else {
			opChannel = mcOpChannelService.findByCode(code);
		}
		ProductVO productVO = adapter.getProduct(product, member, opChannel, accessWay);
		if (productVO != null) {
			// label排序
			if (productVO != null && CollectionUtils.isNotEmpty(productVO.getLabels())) {
				List<Label> labels = productVO.getLabels();
				int[][] typed = new int[labels.size()][2];
				for (int i = 0; i < labels.size(); i++) {
					typed[i][0] = trans(labels.get(i).getType().toString());
					typed[i][1] = i;
				}
				for (int j = 0; j < typed.length; j++) {
					for (int i = 0; i < typed.length - 1; i++) {
						int[] ss;
						if (typed[i][0] > typed[i + 1][0]) {
							ss = typed[i];
							typed[i] = typed[i + 1];
							typed[i + 1] = ss;
						}
					}
				}
				List<Label> typed_lables = new ArrayList<Label>();
				for (int i = 0; i < typed.length; i++) {
					typed_lables.add(i, labels.get(typed[i][1]));
				}
				productVO.setLabels(typed_lables);
			}

		} else {
			productVO = new ProductVO();
			productVO.setInvisible(true);
		}

		if (productCode.equals("PROD001018058") || productCode.equals("PROD001018048")
				|| productCode.equals("PROD001018049")) {
			if (productVO.getInvisible() || productVO.getOffShelf() || productVO.getSoldOut()) {
				productVO.setOffShelf(false);
				productVO.setSoldOut(false);
				productVO.setBuyable(false);
			}
		}
		// 是否编辑过
		if (onoffState && onlineState && rushList.contains(productCode)) {// 开关期间，且有线上渠道，且抢购商品
			logger.info("从redis里取是否编辑过");
			Boolean state = redisClient.getCache(commonAdapter.buildLegacyKey(productCode));
			if (null != state) {
				productVO.setLegacyDetails(state);
			} else {
				logger.info("没取到，push一下");
				productVO.setLegacyDetails(commonAdapter.pushLegacy(productCode));
			}
		} else {
			productVO.setLegacyDetails(!mcOpProdDynmcontDetailsService.IsEditByProdCode(productCode));
		}

		if (isShow) {
			if (productVO.getInvisible()) {
				productVO.setBuyable(false);
			}
			productVO.setInvisible(false);

		}
		return JsonApiResult.ofSuccessResult(productVO);
	}

	int trans(String type) {
		int transed = 0;
		switch (type) {
		case "预售":
			transed = 0;
			return transed;
		case "海淘":
			transed = 1;
			return transed;
		case "定制":
			transed = 2;
			return transed;
		case "满减":
			transed = 3;
			return transed;
		case "满赠":
			transed = 4;
			return transed;
		case "换购":
			transed = 5;
			return transed;
		case "其他活动系统里的优惠":
			transed = 6;
			return transed;
		default:
			transed = 7;
		}
		return transed;
	}

	/**
	 * 验证一个区域是否可配送
	 *
	 * @param
	 * @param
	 * @return
	 */
	@RequestMapping(path = "/checkDelivery", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult checkDelivery(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {

		JSONObject jsonData = JSONObject.parseObject(data);
		String productCode = jsonData.getString("productCode");
		Long districtId = jsonData.getLong("districtId");

		if (StringUtils.isBlank(productCode) || districtId == null) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		boolean rt = false;
		try {
			PsProductVO product = mcPsProductService.findProdByCode(productCode);
			rt = logisticsAdapter.checkDelivery(product, districtId);
		} catch (Exception e) {
			logger.error("验证一个区域错误：{}", e);
		}
		return JsonApiResult.ofSuccessResult(rt);
	}

	/**
	 * 获取一个商品的规格列表
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(path = "/getProductVariant")
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getProductVariant(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String productCode = jsonData.getString("productCode");
		Long memberId = jsonData.getLong("memberId");
		Boolean isGroupon = jsonData.getBoolean("isGroupon");

		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		logger.info("==查询商品规格参数productCode={},memberId={}", productCode, memberId);

		MemberVO member = memberQueryService.getById(memberId);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setChannelCode(code);
		cond.setMatchCampaign(true);
		cond.setAccessWay(accessWay.getCode());
		cond.setMemberLevel(memberLevel.getCode());
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		cond.setBdDiscount(member.getBdayDiscountRatio());
		PsProductVO product = mcPsProductService.getProductDetailByCode(code, productCode, cond);

		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		ProductVariantVO productVariantVO = new ProductVariantVO();

		if (product == null) {
			// 异常通知邮件
			List<String> toAddressList = new ArrayList<>();
			toAddressList.add("tianqi.zhang@thebeastshop.com");
			EmailVO emailVO = new EmailVO();
			emailVO.setSubject("获取商品异常");
			emailVO.setToAddressList(toAddressList);
			String pegasus_channel_service = PropConstants.getProperties("pegasus_channel_service", "test");
			StringBuilder sb = new StringBuilder();
			sb.append("code:").append(code).append(",productCode").append(productCode).append(",memberId:")
					.append(memberId).append("########").append(pegasus_channel_service);

			emailVO.setContent(sb.toString());
			emailSendService.send(emailVO);

		}

		// 去sku详情
		List<String> codes = product.getSkuCodes();

		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(codes);

		PrsCalcProductDTO arg0 = priceAdapter.assemblePriceProduct(product, skus, member, opChannel, accessWay);
		if (null == arg0) {

			logger.info("商品组装出现问题：取不到该商品完整信息，productcode=" + product.getCode());

			return JsonApiResult.ofSuccessResult(null);
		}
		logger.info("获取商品规格价格计算");

		PrsProductPriceResultVO priceVo = new PrsProductPriceResultVO();
		if (isGroupon) {
			priceVo = prsPriceService.calculatePrs4GroupBuyProductDetail(arg0);
		} else {
			priceVo = prsPriceService.calculatePrs4ProductDetail(arg0);
		}

		Map<Long, BigDecimal> priceMap = this.adapter.combineSpvPrice(priceVo);
		productVariantVO = this.adapter.getProductVariantPrice(product, member, opChannel, accessWay, priceMap);

		return JsonApiResult.ofSuccessResult(productVariantVO);
	}

	/**
	 * 获取商品的简要信息
	 *
	 * @param
	 * @param
	 * @param
	 * @return
	 */

	@RequestMapping(path = "/listSimpleProducts", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult listSimpleProducts(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		List<String> productCodes = JSON.parseArray(jsonData.getString("productCodes"), String.class);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));

		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setChannelCode(code);
		cond.setMatchCampaign(true);
		cond.setAccessWay(accessWay.getCode());
		cond.setMemberLevel(memberLevel.getCode());
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		cond.setBdDiscount(member.getBdayDiscountRatio());
		List<PsProductVO> products = mcPsProductService.findTopicByCodes(code, productCodes, cond, 1,
				productCodes.size());
		List<SimpleProductVO> simpleProducts = new ArrayList<SimpleProductVO>();
		if (CollectionUtils.isNotEmpty(products)) {
			simpleProducts = this.adapter.getSimpleProducts(products, member, opChannel, accessWay);
		}
		return JsonApiResult.ofSuccessResult(simpleProducts);
	}

	/**
	 * 获取商品的动态内容
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/productContent", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult getProductContent(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String productCode = jsonData.getString("productCode");

		List<ProductDetailVO> productContentVOs = Lists.newArrayList();
		List<PsProductVO> products = mcPsProductService.findByProdCode(productCode);

		if (CollectionUtils.isNotEmpty(products)) {
			List<PsDynmContentVO> productContents = products.get(0).getDynmContents();
			if (CollectionUtils.isNotEmpty(productContents)) {
				productContentVOs = this.adapter.getProductContent(productContents);
			}
		}
		return JsonApiResult.ofSuccessResult(productContentVOs);
	}

	/**
	 * 获取商品推荐列表
	 *
	 * @param
	 * @param
	 * @param
	 * @return
	 */
	@RequestMapping(path = "/suggest", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult suggest(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));

		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		MemberVO member = memberQueryService.getById(memberId);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
//		Integer offset = jsonData.getInteger("offset");
//		Integer limit = jsonData.getInteger("limit");
		String source = jsonData.getString("source");
		String orderId = jsonData.getString("orderId");
		String productId = jsonData.getString("productId");
		List<PsProductVO> products = new ArrayList<>();
		switch (source) {
		case "PRODUCT":
			RecommendParamVO avo = new RecommendParamVO();
			if (null != productId && !productId.equals("")) {
				avo.setProductCode(productId);
				avo.setMemberLevel(memberLevel.getCode());
				avo.setAccessWay(accessWay.getCode());
				avo.setDiscount(memberLevel.getLevelAmountCondition());
				avo.setLimitSize(12);
				avo.setChnCode(opChannel.getCode());
				avo.setType(Type.PROD_DETAIL);
				avo.setBdDiscount(member.getBdayDiscountRatio());
				products = recommendService.autoRecommend(avo);
			}
			break;
		case "CART":
			RecommendParamVO rvo = new RecommendParamVO();
			rvo.setAccessWay(accessWay.getCode());
			rvo.setChnCode(opChannel.getCode());
			rvo.setDiscount(memberLevel.getLevelAmountCondition());
			rvo.setLimitSize(12);
			rvo.setMemberLevel(memberLevel.getCode());
			rvo.setType(Type.SHOPPING_CART);
			rvo.setBdDiscount(member.getBdayDiscountRatio());
			products = recommendService.getShoppingCartProcutList(rvo);
			break;
		case "ORDER":
			if (null != orderId && !orderId.equals("")) {

				OpSalesOrderVO order = pcInstance.orderDetail(member.getCode(), orderId);
				List<OpSoPackageVO> packages = order.getOpSoPackageVOs();
				if (null != packages && packages.size() > 0) {
					List<Long> spvIds = new ArrayList<Long>();
					for (OpSoPackageVO pack : packages) {
						List<OpSoPackageSkuVO> skus = pack.getOpSoPackageSkuVOs();
						if (null != skus && skus.size() > 0) {
							for (OpSoPackageSkuVO sku : skus) {
								
								if(sku.getSpvId() != null && !spvIds.contains(sku.getSpvId())){
									spvIds.add(sku.getSpvId());
								}
								
								
							}
						}
					}
					
					if(CollectionUtils.isNotEmpty(spvIds)){
						List<PsSpvVO> spvs = mcPsSpvService.findBySpvIds(spvIds);

						List<String> productCodes = new ArrayList<String>();

						List<String> ps = new ArrayList<String>();
						for (PsSpvVO spv : spvs) {
							ps.add(spv.getProductCode());
						}
						// 去重
						for (String s : ps) {
							if (Collections.frequency(productCodes, s) < 1)
								productCodes.add(s);
						}

						if (CollectionUtils.isEmpty(productCodes)) {

							logger.error("订单商品推荐参数异常:memberId = " + memberId + ",orderId=" + orderId);

						} else {
							OrderFinishRecommendParamVO ovo = new OrderFinishRecommendParamVO();
							ovo.setProductCodes(productCodes);
							ovo.setMemberLevel(memberLevel.getCode());
							ovo.setAccessWay(accessWay.getCode());
							ovo.setLimitSize(12);
							ovo.setDiscount(memberLevel.getLevelAmountCondition());
							ovo.setChnCode(opChannel.getCode());
							ovo.setBdDiscount(member.getBdayDiscountRatio());
							products = recommendService.orderFinishRecommend(ovo);
						}
					}
					


				}
			}
			break;
		default:
			break;
		}

		List<SimpleProductVO> simpleProducts = new ArrayList<SimpleProductVO>();
		if (CollectionUtils.isNotEmpty(products)) {
			simpleProducts = this.adapter.getSimpleProducts(products, member, opChannel, accessWay);
		}
		// 设置水印
		// waterMarkAdapter.setWaterMarkByList(simpleProducts);
		return JsonApiResult.ofSuccessResult(simpleProducts);
	}

	/**
	 * 获取商品的动态内容
	 *
	 * @param code
	 * @param data
	 * @return
	 */
	@ApiAuth
	@RequestMapping(path = "/productDetails", method = RequestMethod.GET)
	@ResponseBody
	public JsonApiResult productDetails(@RequestParam("CODE") String code, @RequestParam("DATA") String data) throws UnsupportedEncodingException {
		JSONObject jsonData = JSONObject.parseObject(data);
		String productCode = jsonData.getString("productCode");

		Boolean isLink = jsonData.getBoolean("isLink");
		ProductDetailNewVO newVO = new ProductDetailNewVO();
		logger.info("获取新的商品动态productCode={}", productCode);

		if (!mcOpProdDynmcontDetailsService.IsEditByProdCode(productCode)) {
			logger.info("该商品没有被编辑过productCode={}", productCode);
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), "该商品没有被编辑过，请调用旧的商详接口");
		}

		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));

		// PsMatchCampaignCond cond = new PsMatchCampaignCond();
		// cond.setChannelCode(code);
		// cond.setMatchCampaign(true);
		// cond.setAccessWay(accessWay.getCode());
		// cond.setMemberLevel(-1);
		// cond.setDiscount(new BigDecimal("1.00"));
		// cond.setBdDiscount(BigDecimal.valueOf(1));
		//
		// PsProductVO product = mcPsProductService.getProductDetailByCode(code,
		// productCode, cond);

		List<String> onoffList = JsonUtil.toList(PropConstants.getProperties(RUSH_ONOFF), String.class);
		Boolean onoffState = commonAdapter.on_off(onoffList.get(0), onoffList.get(1));
		Boolean onlineState = commonAdapter.isOnline(code);
		List<String> rushList = JsonUtil.toList(PropConstants.getProperties(RUSH_LIST), String.class);
		PsProductVO product = null;
		if (onoffState && onlineState && rushList.contains(productCode)) {// 开关期间，且有线上渠道，且抢购商品
			logger.info("redis里取商品");
			product = redisClient
					.getCache(commonAdapter.buildProductKey(MemberLevelEnum.NORMAL.getCode(), productCode));
			if (null == product) {
				logger.info("redis里没取到，push一下");
				product = commonAdapter.pushProduct(productCode, MemberLevelEnum.NORMAL);
			}
		} else {

			PsMatchCampaignCond cond = new PsMatchCampaignCond();
			cond.setChannelCode(code);
			cond.setMatchCampaign(true);
			cond.setAccessWay(accessWay.getCode());
			cond.setMemberLevel(-1);
			cond.setDiscount(new BigDecimal("1.00"));
			cond.setBdDiscount(BigDecimal.valueOf(1));

			product = mcPsProductService.getProductDetailByCode(code, productCode, cond);
		}

		Boolean furniture = false;

		List<String> codes = product.getSkuCodes();
		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(codes);

		for (PsSkuVO sku : skus) {
			if (sku.getWhetherLogistics() != null && sku.getWhetherLogistics() == 1) {
				furniture = true;
				break;
			}
		}
		OpProdDynmDetailsSaveVO vo = mcOpProdDynmcontDetailsService.getByProductCode(productCode);
		if (null != vo) {

			List<OpProdDynmTitleVO> list = vo.getAllDynmDetail();
			logger.info("获取商品详情信息，该商品共有数据 size={}条", vo.getAllDynmDetail().size());
			// 排序 根据sort
			Collections.sort(list, new Comparator<OpProdDynmTitleVO>() {
				@Override
				public int compare(OpProdDynmTitleVO o1, OpProdDynmTitleVO o2) {
					int a = o1.getDynmcontId() - o2.getDynmcontId() > 0 ? 1 : 0;
					return (a);
				}
			});

			ArrayList<ProductDetail> details = new ArrayList<ProductDetail>();
			for (OpProdDynmTitleVO det : list) {
				logger.info("模块内容list={}", det.getDynmDtatails());
				ProductDetail detail = new ProductDetail();
				if (null != det.getIsOpen() && det.getIsOpen().equals(1)) {
					detail.setExpanded(false);
				} else {
					detail.setExpanded(true);
				}
				detail.setTitle(det.getTitleCn());
				detail.setTitleEn(det.getTitleEn());

				List<OpProdDynmDetailVO> cons = det.getDynmDtatails();
				ArrayList<ProductDetailModule> modules = new ArrayList<ProductDetailModule>();
				ArrayList<TableRow> tables = new ArrayList<TableRow>();
				if (CollectionUtils.isNotEmpty(cons)) {
					logger.info("cons size={}", cons.size());
					logger.info("模块 Title={}, 模块 TitleEn={},", det.getTitleCn(), det.getTitleEn());
					// 排序 根据sort
					//int t = 0;
					// for (OpProdDynmDetailVO con : cons) {
					//
					// logger.info("内容
					// i={},getSort()={},getDynmTitle={},getDynmContent={},getDynmType={}",
					// t,
					// con.getSort(), con.getDynmTitle(), con.getDynmContent(),
					// con.getDynmType());
					// t++;
					// }
					Collections.sort(cons, new Comparator<OpProdDynmDetailVO>() {
						@Override
						public int compare(OpProdDynmDetailVO o1, OpProdDynmDetailVO o2) {
							return (Integer.compare(o1.getSort(), o2.getSort()));
						}
					});

					logger.info("商详内容共有size={}", cons.size());
					for (int i = 0; i < cons.size(); i++) {
						boolean state = true;// 是否存入modules标志
						OpProdDynmDetailVO con = cons.get(i);
						if (null != con && null != con.getDynmType() && null != con.getDynmContent()) {
							ProductDetailModule module = new ProductDetailModule();
							logger.info("类型={}", con.getDynmType());

							switch (con.getDynmType()) {
							// 动态内容类型:1-图片 2-文字 3-表格
							case 1:
								module.setType("IMAGE");
								Image image = new Image();
								image.setSrc(FileConstant.BASE_URL + con.getDynmContent());
								module.setImage(image);
								module.setDesc(con.getDynmTitle());
								break;
							case 2:
								module.setType("TEXT");
								if (null != con.getDynmTitle() && con.getDynmTitle().equals("标题")) {
									module.setTitle(con.getDynmContent());
								} else {
									module.setText(con.getDynmContent());
								}
								break;
							case 3:
								state = false;
								module.setType("TABLE");
								logger.info("表格数据con.getDynmContent()={}", con.getDynmContent());
								if (i > 0 && !cons.get(i - 1).getDynmType().equals(3)) {
									tables = new ArrayList<TableRow>();
									logger.info("新表格");
								}
								ArrayList<String> row = new ArrayList<String>();
								TableRow tableRow = new TableRow();

								if (null != con.getDynmTitle()) {
									row.add(con.getDynmTitle());
								} else {
									row.add("");
								}
								if (null != con.getDynmContent()) {
									row.add(con.getDynmContent());
								} else {
									row.add("");
								}
								tableRow.setTableRow(row);
								logger.info("表格内容");
								tables.add(tableRow);
								if (i < cons.size() - 1 && !cons.get(i + 1).getDynmType().equals(3)
										|| i == (cons.size() - 1)) {
									logger.info("表格完结");
									module.setTable(tables);
									state = true;
								}
								break;
							}
							if (state) {
								modules.add(module);
							}
						}
					}
					if (isLink) {
						if (det.getTitleCn().equals("品牌故事") && CollectionUtils.isNotEmpty(modules)) {
							ProductDetailModule brandModule = new ProductDetailModule();

							Long brandId = 0L;
							String brandName = "";
							brandModule.setType("LINK");
							if (product.getBrands().size() > 0) {
								PsBrandVO brand = product.getBrands().get(0);
								if (brand != null) {
									brandId = brand.getBrandId();
									brandName = brand.getBrandName();
								}
							}
							brandModule.setText("去" + brandName + "主页");
							brandModule.setLink("beastapp://brand/" + brandId + "?title=" + URLEncoder.encode(brandName, "UTF-8").replaceAll("\\+","%20"));
							modules.add(brandModule);
						}

						if (det.getTitleCn().equals("服务承诺") && CollectionUtils.isNotEmpty(modules)) {
							if (furniture) {
								ProductDetailModule exchangedModule = new ProductDetailModule();

								exchangedModule.setType("LINK");
								exchangedModule.setText("查看详细说明");
								exchangedModule.setLink("beastapp://entry?name=big-furniture-tips");
								modules.add(exchangedModule);

							}
						}
					}
					detail.setModules(modules);
					details.add(detail);
				}
			}
			newVO.setDetails(details);
		}
		logger.info("返回查询结果newVO={}", newVO.toString());
		return JsonApiResult.ofSuccessResult(newVO);
	}

	/**
	 * 获取商品的简要信息
	 *
	 * @param
	 * @param
	 * @param
	 * @return
	 */
	@RequestMapping(path = "/listSPDSimpleProducts", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult listSPDSimpleProducts(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		List<String> productCodes = JSON.parseArray(jsonData.getString("productCodes"), String.class);
		Long memberId = jsonData.getLong("memberId");
		Boolean canBuy = jsonData.getBoolean("canBuy");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		code = "CHN1030";// 集团渠道
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setChannelCode(code);
		cond.setMatchCampaign(true);
		cond.setAccessWay(accessWay.getCode());
		cond.setMemberLevel(memberLevel.getCode());
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		cond.setBdDiscount(member.getBdayDiscountRatio());
		List<PsProductVO> products = mcPsProductService.findTopicByCodes(code, productCodes, cond, 1,
				productCodes.size());
		List<SPDSimpleProductVO> SPDSimpleProducts = this.adapter.getSPDSimpleProducts(products, member, opChannel,
				accessWay, canBuy);

		return JsonApiResult.ofSuccessResult(SPDSimpleProducts);
	}

	/**
	 * 浦发商品规格列表
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(path = "/getProductVariantFromSPD")
	@ResponseStatus(HttpStatus.OK)

	@ResponseBody
	public JsonApiResult getProductVariantFromSPD(@RequestParam("CODE") String code,
			@RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String productCode = jsonData.getString("productCode");
		// Long memberId = jsonData.getLong("memberId");
		Long memberId = 1L;
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		logger.info("==查询商品规格参数productCode={},memberId={}", productCode, memberId);

		code = "CHN1030";
		MemberVO member = memberQueryService.getById(memberId);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setChannelCode(code);
		cond.setMatchCampaign(true);
		cond.setAccessWay(accessWay.getCode());
		cond.setMemberLevel(memberLevel.getCode());
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		cond.setBdDiscount(member.getBdayDiscountRatio());
		PsProductVO product = mcPsProductService.getProductDetailByCode(code, productCode, cond);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);

		ProductVariantVO productVariantVO = new ProductVariantVO();
		// String ISNEWPRODUCTPRICE =
		// PropConstants.getProperties("ISNEWPRODUCTPRICE");//
		//
		// if (ISNEWPRODUCTPRICE.equals("true")) {
		// 去sku详情
		List<String> codes = product.getSkuCodes();
		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(codes);

		PrsCalcProductDTO arg0 = priceAdapter.assemblePriceProduct(product, skus, member, opChannel, accessWay);
		if (null == arg0) {
			logger.info("商品组装出现问题：取不到该商品完整信息，productcode=" + product.getCode());
			return null;
		}
		PrsProductPriceResultVO priceVo = prsPriceService.calculatePrs4ProductDetail(arg0);
		Map<Long, BigDecimal> priceMap = this.adapter.combineSpvPrice(priceVo);
		productVariantVO = this.adapter.getProductVariantPrice(product, member, opChannel, accessWay, priceMap);
		// } else {
		// productVariantVO = this.adapter.getProductVariant(product, member,
		// opChannel, accessWay);
		// }
		return JsonApiResult.ofSuccessResult(productVariantVO);
	}

	/**
	 * 商品组合搭配列表
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getProductCombination")
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getProductCombination(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String productCode = jsonData.getString("productCode");// product code
		Long memberId = jsonData.getLong("memberId");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		MemberVO member = memberQueryService.getById(memberId);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		logger.info("==查询商品规格参数productCode={},memberId={}", productCode, memberId);
		PsProductCond cond = new PsProductCond();
		cond.setCode(productCode);
		cond.setChannelCode(code);
		cond.setMemberLevel(memberLevel.getCode());
		cond.setAccessWay(accessWay.getCode());
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		List<PsProductVO> products = mcPsProductService.findCollocationCombinedProdByCode(cond);
		List<ProductVO> prods = productCombinationAdapter.getCombinedProductDetails(products, member, opChannel,
				accessWay);
		BigDecimal maxEconomize = BigDecimal.ZERO;
		BigDecimal prodEconomize = BigDecimal.ZERO;
		for (ProductVO prod : prods) {
			prodEconomize = prod.getRawPrice().subtract(prod.getPrice());
			if (prodEconomize.compareTo(maxEconomize) > 0) {
				maxEconomize = prodEconomize;
			}
		}
		Map<String, Object> resultMap = new HashMap<>();
		resultMap.put("maxEconomize", maxEconomize);
		resultMap.put("products", prods);
		resultMap.put("count", prods.size());
		return JsonApiResult.ofSuccessResult(resultMap);
	}

	/**
	 * 商品组合搭配列表
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/newSimpleProducts")
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getNewSimpleProducts(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		List<String> productCodes = JSON.parseArray(jsonData.getString("productCodes"), String.class);
		Integer size = jsonData.getInteger("pageSize");
		ProdSearchCond cond = new ProdSearchCond();
		cond.setChannelCode(code);
		cond.setSize(size);
		List<PsProductVO> products = mcPsProductService.findByNewProdSearchCondVO(productCodes, cond);

		List<SimpleProductVO> simpleProducts = new ArrayList<SimpleProductVO>();
		if (CollectionUtils.isNotEmpty(products)) {
			for (PsProductVO product : products) {
				SimpleProductVO basic = new SimpleProductVO();
				basic.setId(product.getCode());// 换code
				// featureImage
				String featureImage = product.getPicList();
				if (StringUtils.isNotBlank(featureImage) && !featureImage.startsWith(FileConstant.BASE_URL)) {
					featureImage = FileConstant.BASE_URL + featureImage;
				}
				basic.setFeatureImage(featureImage);
				// images
				List<String> images = product.getPicDetailMuls();
				for (int i = 0; i < images.size(); i++) {
					if (StringUtils.isNotBlank(images.get(i)) && !images.get(i).startsWith(FileConstant.BASE_URL)) {
						String image = FileConstant.BASE_URL + images.get(i);
						images.set(i, image);
					}
				}
				basic.setImages(images);
				// brand
				if (product.getBrands().size() > 0) {
					PsBrandVO brand = product.getBrands().get(0);
					if (brand != null) {
						SpvVO.BrandVO brandVO = new SpvVO.BrandVO();
						brandVO.setId(brand.getBrandId());
						brandVO.setName(brand.getBrandName());
						basic.setBrand(brandVO);
					}
				}
				// name
				basic.setName(product.getNameCn());
				// summary
				basic.setSummary(product.getDescription());
				simpleProducts.add(basic);
			}
		}
		return JsonApiResult.ofSuccessResult(simpleProducts);
	}

}
