package com.thebeastshop.pegasus.channelservice.controller.order.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beast.clog.agent.TagBuilder;
import com.beast.clog.agent.log.ILog;
import com.beast.clog.agent.log.LogManager;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.course.dto.FrontBeastCourseDTO;
import com.thebeastshop.course.service.FrontBeastCourseService;
import com.thebeastshop.course.vo.FrontBeastCourseVO;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.order.OrderLessonAdapter;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 野兽课堂订单处理
 * Created by GFL on 2019/3/7.
 */
@Controller("appOrderLessonController")
@RequestMapping("api/app/lessonOrder")
public class OrderLessonController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ILog clog = LogManager.getLogger(OrderLessonController.class);

    @Autowired
    private MemberQueryService memberQueryService;
    @Autowired
    private McOpChannelService mcOpChannelService;
    @Autowired
    private CartProductPackAdapter cartProductPackAdapter;
    @Autowired
    FrontBeastCourseService frontBeastCourseService;
    @Autowired
    OrderLessonAdapter orderLessonAdapter;

    /***
     * 野兽课堂预览订单
     */
    @ApiAuth
    @RequestMapping(value = "/preview", method = RequestMethod.POST)
    @ResponseBody
    public JsonApiResult preview(@RequestParam("CODE") String code, @RequestBody final String data) {
        logger.info("beast Class Preview begin ...");

        JSONObject jsonData = JSONObject.parseObject(data);
        Long memberId = jsonData.getLong("memberId");
        logger.info("memberId={}", memberId);
        Integer accessWayId = jsonData.getInteger("accessWay");

        AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
        MemberVO member = memberQueryService.getById(memberId);
        OpChannelVO opChannel = mcOpChannelService.findByCode(code);
        // 订单预览
        OrderPreviewDTO orderPreview = JSON.parseObject(jsonData.getString("orderPreview"), OrderPreviewDTO.class);
        // 商品包
        CartProductPack cartProductPack = null;
        List<RequestPack> requestPacks = orderPreview.getPacks();
        if (CollectionUtils.isNotEmpty(requestPacks)) {
            List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestPacks,
                    accessWay, member, opChannel.getCode());
            cartProductPack = prodPacks.get(0);

        }
        if (cartProductPack == null) {
            return JsonApiResult.ofErrorResult(400, "商品信息为空");
        }

        // 获取课程数据
        FrontBeastCourseDTO courseCond = new FrontBeastCourseDTO();
        courseCond.setProdCode(cartProductPack.getProduct().getCode());
        courseCond.setMemberCode(member.getCode());
        ServiceResp<FrontBeastCourseVO> courseResp = frontBeastCourseService.getBeastCourseDetailByCond(courseCond);
        if (courseResp.isFailure()) {
            return JsonApiResult.ofErrorResult(400, "课堂不存在");
        }
        FrontBeastCourseVO beastCourse = courseResp.getBean();

        if(!beastCourse.getMemberLevels().contains(member.getMemberLevel().toString())){
            String levelName = MemberLevelEnum.getEnumByCode(member.getMemberLevel()).getName();
            return JsonApiResult.ofErrorResult(400, levelName+"没有购买权限");
        }

        OrderConfirmVO orderConfirm = orderLessonAdapter.getOrderPreview(orderPreview, cartProductPack, beastCourse, member, opChannel, accessWay);

        logger.info("execute  preview end");
        return JsonApiResult.ofSuccessResult(orderConfirm);
    }

    /***
     * 野兽课堂确认订单
     */
    @ApiAuth
    @RequestMapping(value = "/confirm", method = RequestMethod.POST)
    @ResponseBody
    public JsonApiResult confirm(@RequestParam("CODE") String code, @RequestBody String data) {
        logger.info("execute  confirm");
        JSONObject jsonData = JSONObject.parseObject(data);
        Long memberId = jsonData.getLong("memberId");
        String deviceId = jsonData.getString("deviceId");
        Integer accessWayId = jsonData.getInteger("accessWay");
        AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);

        OrderConfirmDTO orderConfirmDTO = JSON.parseObject(jsonData.getString("orderConfirm"), OrderConfirmDTO.class);
        if (orderConfirmDTO == null || !OrderBusinessType.CLASSROOM.equals(orderConfirmDTO.getOrderType())) {
            return JsonApiResult.ofErrorResult(400, "订单类型错误，只支持野兽课堂订单");
        }

        MemberVO member = memberQueryService.getById(memberId);
        OpChannelVO opChannel = mcOpChannelService.findByCode(code);

        clog.info("confirm下单", data, TagBuilder.create().append("memberId", memberId).build());
        // 商品包
        CartProductPack cartProductPack = null;
        List<RequestPack> requestPacks = orderConfirmDTO.getPacks();
        if (CollectionUtils.isNotEmpty(requestPacks)) {
            List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestPacks,
                    accessWay, member, opChannel.getCode());
            cartProductPack = prodPacks.get(0);

        }
        if (cartProductPack == null) {
            return JsonApiResult.ofErrorResult(400, "商品信息为空");
        }
        // 获取课程数据
        FrontBeastCourseDTO courseCond = new FrontBeastCourseDTO();
        courseCond.setProdCode(cartProductPack.getProduct().getCode());
        courseCond.setMemberCode(member.getCode());
        ServiceResp<FrontBeastCourseVO> courseResp = frontBeastCourseService.getBeastCourseDetailByCond(courseCond);
        if (courseResp.isFailure()) {
            return JsonApiResult.ofErrorResult(400, "课堂不存在");
        }
        FrontBeastCourseVO beastCourse = courseResp.getBean();

        if(!beastCourse.getMemberLevels().contains(member.getMemberLevel().toString())){
            String levelName = MemberLevelEnum.getEnumByCode(member.getMemberLevel()).getName();
            return JsonApiResult.ofErrorResult(400, levelName+"没有购买权限");
        }
        String orderCode = orderLessonAdapter.orderCreate(orderConfirmDTO, cartProductPack, beastCourse, member, opChannel, accessWay, deviceId);
        JsonApiResult jsonResult = JsonApiResult.ofSuccessResult(orderCode);
        logger.info("confirm result,code=[" + jsonResult.getCode() + "],msg=[" + jsonResult.getMessage() + "]");
        clog.info("confirm下单", "confirm result,code=[" + jsonResult.getCode() + "],msg=[" + jsonResult.getMessage() + "]");
        return jsonResult;
    }

}
