package com.thebeastshop.pegasus.channelservice.controller.order.app;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.order.OrderCooperationAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.order.SnapshotAdapter;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.channel.service.ChannelService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongEntityException;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;

/**
 * TODO：订单接口（目前针对app端）
 * 
 * @author Paul-xiong
 *
 */
@Controller("appOrderCooperationController")
@RequestMapping("api/app/orderCooperation")
public class OrderCooperationController {

	private final Logger logger = LoggerFactory.getLogger(OrderCooperationController.class);

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private MemberQueryService memberQueryService;

	private ChannelService channelService = ComponentServiceLoader.getBean(ChannelService.class);

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private McPsSpvService mcPsSpvService;

	@Autowired
	private CartService cartService;

	@Autowired
	private SnapshotAdapter snapshotAdapter;

	@Autowired
	private OrderCooperationAdapter orderCooperationAdapter;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private McOpChannelService mcOpChannelService;

	/***
	 * 预览订单（浦发兑换） 浦发权益兑换商品不经过购物车，价格0运费0
	 */
	@ApiAuth
	@RequestMapping(value = "/preview", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult preview(@RequestParam("CODE") String code, @RequestBody final String data) {
		logger.info("合作订单预览接口");
		OrderConfirmVO orderConfirm = new OrderConfirmVO();
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		logger.info("memberId={}", memberId);
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		MemberVO member = memberQueryService.getById(memberId);
		// // 使用礼品卡则不能进行会员打折,则把当前会员等级暂时变成普通会员
		// if (member != null && jsonData.getBoolean("useGiftCard") != null &&
		// jsonData.getBoolean("useGiftCard")) {
		// member.setMemberLevel(MemberLevelEnum.NORMAL.getCode());
		// }
		code = "CHN1030";
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		// 订单预览
		OrderPreviewDTO orderPreview = JSON.parseObject(jsonData.getString("orderPreview"), OrderPreviewDTO.class);

		List<CartProductPack> packs = Lists.newArrayList();
		List<RequestPack> requestPacks = orderPreview.getPacks();
		if (CollectionUtils.isNotEmpty(requestPacks)) {
			List<Long> packIds = Lists.newArrayList();
			List<RequestPack> noIdPacks = Lists.newArrayList();
			for (RequestPack requestPack : requestPacks) {

				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}
			if (CollectionUtils.isNotEmpty(packIds)) {
				packs.addAll(cartService.getPacksByIds(member, packIds, accessWay, opChannel.getCode()));
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
						accessWay, member, opChannel.getCode());
				packs.addAll(prodPacks);
			}
			cartProductPackAdapter.syncPrice2ProductPack(packs);
			logger.info("来自购物车的商品包处理   packs ：{}", packs);
			orderConfirm = orderCooperationAdapter.getOrderConfirm(orderPreview, packs, member, opChannel, accessWay,
					false);

		}
		orderConfirm.setOrderType(OrderBusinessType.SPD);

		logger.info("execute  preview end");
		return JsonApiResult.ofSuccessResult(orderConfirm);
	}

	/***
	 * 确认订单。 浦发订单
	 */
	@ApiAuth
	@RequestMapping(value = "/confirm", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult confirm(@RequestParam("CODE") String code, @RequestBody final String data) {
		logger.info("execute  confirm");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		String deviceId = jsonData.getString("deviceId");
		MemberVO member = memberQueryService.getById(memberId);

		code = "CHN1030";
		Channel channel = channelService.getByCode(code);
		OrderConfirmDTO orderConfirmDTO = JSON.parseObject(jsonData.getString("orderConfirm"), OrderConfirmDTO.class);

		// 浦发订单不能使用礼品卡和优惠券
		if (CollectionUtils.isNotEmpty(orderConfirmDTO.getGiftCards())) {
			throw new WrongArgException("浦发权益兑换订单请不要使用礼品卡");
		}
		if (null != orderConfirmDTO.getCouponId()) {
			throw new WrongArgException("浦发权益兑换订单请不要使用优惠券");
		}
		logger.info("确认订单：memberId：{}，packs：{}", memberId, orderConfirmDTO.getPacks());
		// 目前先调用老的创建订单
		String orderCode = "";
		// Long orderId = 0L;
		if (null != orderConfirmDTO.getPacks().get(0).getSpvId()) {
			Long spvId = orderConfirmDTO.getPacks().get(0).getSpvId();
			PsProductVO productVO = mcPsProductService.findProdBySpvId(spvId);
			PsSpvVO spv = mcPsSpvService.findBySpvId(spvId);
			PsSkuVO sku = mcPsSkuService.findBySkuCode(spv.getSkuCode());

			OpSalesOrderVO opSalesOrderVO = orderCooperationAdapter.pufaOrder(orderConfirmDTO, member, channel,
					deviceId, productVO, spv, sku);
			try {
				OpSalesOrderResponseVO orderResp = pcInstance.iposOrderCreate(opSalesOrderVO);
				orderCode = orderResp.getOrderCode();
				// orderId = orderResp.getId();
				// if (orderResp != null &&
				// StringUtils.isNotBlank(orderResp.getOrderCode())) {
				// orderCode = orderResp.getOrderCode();
				// if (orderResp.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
				// OpSalesOrder order = pcInstance.getOrderByCode(orderCode);
				// // TODO:如果支付价格为零元则订单设为已支付,默认支付方式为支付宝
				// _callOldOrderPay(orderCode, PaymentType.ALIPAY.getId(),
				// orderResp.getAmount(), "");
				// }
				// // 保存订单快照
				// if (StringUtils.isNotBlank(orderCode)) {
				// orderSnapshotService.savePSDOrderSnapshot(orderResp.getId(),
				// spv);
				// }
				//
				// }

			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new WrongEntityException(e.getMessage());

			}
		}
		logger.info("confirm orderCode=" + orderCode);
		JsonApiResult jsonResult = JsonApiResult.ofSuccessResult(orderCode);
		logger.info("confirm result,code=[" + jsonResult.getCode() + "],msg=[" + jsonResult.getMessage() + "]");

		return jsonResult;
	}

	private Boolean _callOldOrderPay(String orderCode, Integer paymentType, BigDecimal totalAmount, String tradeNo) {
		try {

			// XXX:是否有必要给支付价格呢
			// 支付账号
			String _payAccount = "";
			return pcInstance.orderPay(orderCode, paymentType, totalAmount, _payAccount, tradeNo);

		} catch (Exception e) {
			logger.error("订单支付异常! e={}", e);
		}
		return false;
	}

	/***
	 * 确认订单。 浦发订单
	 */
	@ApiAuth
	@RequestMapping(value = "/callOrderPay", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult callOrderPay(@RequestParam("CODE") String code, @RequestBody final String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String orderCode = jsonData.getString("orderCode");
		Long spvId = jsonData.getLong("spvId");
		OpSalesOrder order = pcInstance.getOrderByCode(orderCode);

		try {
			if (order != null && order.getNeedToPayAmount().compareTo(BigDecimal.ZERO) <= 0) {

				// TODO:如果支付价格为零元则订单设为已支付,默认支付方式为支付宝
				_callOldOrderPay(orderCode, PaymentType.ALIPAY.getId(), order.getNeedToPayAmount(), "");

				PsSpvVO spv = mcPsSpvService.findBySpvId(spvId);
				snapshotAdapter.savePSDOrderSnapshot(order.getId(), spv);
				return JsonApiResult.ofSuccessResult(true);
			}

			return JsonApiResult.ofErrorResult(404, "订单不存在或者金额有误！");

		} catch (Exception e) {

			logger.error("订单支付异常! e={}", e);

			throw new WrongEntityException(e.getMessage());
		}

	}
}
