package com.thebeastshop.pegasus.channelservice.controller.order.app;

import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.common.utils.BCrypt;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beast.clog.agent.TagBuilder;
import com.beast.clog.agent.log.ILog;
import com.beast.clog.agent.log.LogManager;
import com.google.common.collect.Lists;
import com.thebeastshop.account.dto.MemberAccountDto;
import com.thebeastshop.campaign.enums.RowStateEnum;
import com.thebeastshop.campaign.service.GroupBuyService;
import com.thebeastshop.campaign.vo.GroupBuyResultVO;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.IposPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.ipos.IposAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.order.OrderPriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ForecastAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvCustomizeAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.enums.OrderFlowState;
import com.thebeastshop.pegasus.channelservice.service.ExchangeCartService;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongEntityException;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;
import com.thebeastshop.support.vo.payment.OrderPayVO;

/**
 * TODO：订单接口（目前针对app端） s
 * 
 * @author Paul-xiong
 *
 */
@Controller("appOrderController")
@RequestMapping("api/app/order")
public class OrderController {

	private final Logger logger = LoggerFactory.getLogger(OrderController.class);
	private final ILog clog = LogManager.getLogger(OrderController.class);

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();
	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private GroupBuyService groupBuyService;

	@Autowired
	private CartService cartService;

	@Autowired
	private ExchangeCartService exchangeCartService;

	@Autowired
	private LogisticsAdapter logisticsAdapter;

	@Autowired
	private OrderPriceAdapter orderPriceAdapter;

	@Autowired
	private SpvCustomizeAdapter spvCustomizeAdapter;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private McOpChannelService mcOpChannelService;

	@Autowired
	private ForecastAdapter forecastAdapter;

	@Autowired
	private IposPackAdapter iposPackAdapter;

	@Autowired
	private IposAdapter iposAdapter;

	// =============private============
	private JsonApiResult _buildOrderDeleteResult(final Integer status) {
		if (status == 1) {
			return JsonApiResult.ofSuccessResult(true);
		} else if (status == -1) {
			return JsonApiResult.ofErrorResult(-1, "抱歉，订单不存在");
		} else if (status == -2) {
			return JsonApiResult.ofErrorResult(-1, "抱歉,此订单信息有误,无法删除。");
		} else if (status == 2) {
			return JsonApiResult.ofErrorResult(-1, "抱歉,此订单还有商品未发货,无法删除。");
		} else if (status == 3) {
			return JsonApiResult.ofErrorResult(-1, "抱歉,等待支付状态的订单无法删除,请先取消订单。");
		} else if (status == 4) {
			return JsonApiResult.ofErrorResult(-1, "抱歉，订单不可删除");
		} else {
			return JsonApiResult.ofErrorResult(-1, "抱歉，订单不可删除");
		}
	}

	/**
	 * 调用老的删除订单方法
	 * 
	 * @param memberCode
	 * @param orderCode
	 * @return
	 */
	private Integer _callOldOrderDelete(String memberCode, String orderCode, String remark) {
		return pcInstance.deleteSalesOrder(memberCode, orderCode, remark);
	}

	/**
	 * 调用老的取消订单方法
	 * 
	 * @param orderCode
	 * @return
	 */
	private Boolean _callOldOrderCancel(String orderCode) {
		try {
			return pcInstance.cancleSalesOrder(orderCode);
		} catch (Exception e) {
			logger.error("取消订单异常! e={}", e);
		}
		return false;
	}

	@ApiAuth
	@RequestMapping(value = "/iposPreview", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult iposPreview(@RequestParam("CODE") final String code, @RequestBody final String data) {
		
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		memberId = memberId == null ? 1L : memberId;
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));

		OrderPreviewDTO orderPreview = JSON.parseObject(jsonData.getString("orderPreview"), OrderPreviewDTO.class);
		List<RequestPack> requestPacks = orderPreview.getPacks();
		if (CollectionUtils.isEmpty(requestPacks)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), "请选择商品");
		}

		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		List<CartProductPack> prodPacks = iposPackAdapter.setProdAndSpvCartPack(requestPacks, accessWay, member, opChannel.getCode());

		OrderConfirmVO orderConfirm = iposAdapter.orderPreview(orderPreview, prodPacks, member, opChannel, accessWay);
		return JsonApiResult.ofSuccessResult(orderConfirm);
	}

	/***
	 * 预览订单。
	 *
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/info
	 */
	@ApiAuth
	@RequestMapping(value = "/preview", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult preview(@RequestParam("CODE") final String code, @RequestBody final String data) {
		logger.info("execute  preview");
		OrderConfirmVO orderConfirm = new OrderConfirmVO();
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		memberId = memberId == null ? 1L : memberId;
		Integer accessWayId = jsonData.getInteger("accessWay");
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(accessWayId);
		MemberVO member = memberQueryService.getById(memberId);
		// 订单预览
		OrderPreviewDTO orderPreview = JSON.parseObject(jsonData.getString("orderPreview"), OrderPreviewDTO.class);

		List<CartProductPack> packs = Lists.newArrayList();
		List<RequestPack> requestPacks = orderPreview.getPacks();

		if (CollectionUtils.isNotEmpty(requestPacks)) {
			OpChannelVO opChannel = mcOpChannelService.findByCode(code);
			List<Long> packIds = Lists.newArrayList();
			List<RequestPack> noIdPacks = Lists.newArrayList();
			for (RequestPack requestPack : requestPacks) {
				// 积分兑换订单购物车做无购物车处理
				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}
			if (CollectionUtils.isNotEmpty(packIds)) {
				if (OrderBusinessType.EXCHANGE.equals(orderPreview.getOrderType())) {
					noIdPacks.addAll(exchangeCartService.getPacksByIds(memberId, packIds));
				} else {
					packs.addAll(cartService.getPacksByIds(member, packIds, accessWay, opChannel.getCode()));
				}
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
						accessWay, member, opChannel.getCode());
				packs.addAll(prodPacks);
			}

			logisticsAdapter.checktDeliverable(packs, orderPreview.getAddressId(), opChannel);

			// 线下不需要验证
			if (member != null && opChannel.getType() != null && opChannel.getType() != 4 && opChannel.getType() != 5) {
				// 校验商品包是否包含预售商品
				forecastAdapter.checkOrderPacksForecast(packs, member.getMemberLevel());
			}

			cartProductPackAdapter.syncPrice2ProductPack(packs);
			for (CartProductPack productPack : packs) {
				if (productPack.isCustomize()) {
					// 校验锈字规则
					if (!spvCustomizeAdapter.checkWordLimit(productPack.getSpv().getSpvId(),
							productPack.getCustomizeList())) {
						logger.error("定制商品{}：输入文字不符合规则", productPack);
						throw new WrongEntityException("定制文本不符合规则");
					}
				}
			}

			orderConfirm = orderPriceAdapter.getOrderPreview(orderPreview, packs, member, opChannel, accessWay);
		} else {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(), "请选择商品");
		}
		logger.info("execute  preview end");
		return JsonApiResult.ofSuccessResult(orderConfirm);
	}

	/***
	 * 确认订单。
	 *
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/info
	 */
	@ApiAuth
	@RequestMapping(value = "/confirm", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult confirm(@RequestParam("CODE") final String code, @RequestBody final String data) {
		logger.info("execute  confirm");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		String deviceId = jsonData.getString("deviceId");
		if (null == memberId) {
			memberId = 1L;
		}
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));

		logger.info("confirm orderConfirm =" + jsonData.getString("orderConfirm"));
		clog.info("confirm下单", data, TagBuilder.create().append("memberId", memberId).build());
		// iLog.info("confirm orderConfirm =" +
		// jsonData.getString("orderConfirm"));

		OrderConfirmDTO orderConfirmDTO = JSON.parseObject(jsonData.getString("orderConfirm"), OrderConfirmDTO.class);

		String orderCode = "";

		try {
			if (orderConfirmDTO.getOrderType().equals(OrderBusinessType.GROUPON)) {
				String openId = jsonData.getString("openId");
				String order = jsonData.getString("orderCode");
				String avatar = jsonData.getString("avatar");
				Boolean isOpen = jsonData.getBoolean("isOpen");
				int leftNumber = jsonData.getIntValue("leftNumber");
				String groupId = jsonData.getString("grouponId");
				orderCode = orderPriceAdapter.orderCreateForGroupon(isOpen, orderConfirmDTO, memberId, deviceId, order,
						openId, avatar, opChannel, accessWay, leftNumber, groupId);

				ServiceResp<GroupBuyResultVO> resp = groupBuyService.updateRecordState(orderCode,
						RowStateEnum.ORDERED.getId());
				if (resp.isSuccess()) {
					logger.info("小飞更新成功 orderCode={}，团号groupId={},是否开团isOpen={} ", order, orderCode, isOpen);
					clog.info("团购订单", "小飞更新成功", TagBuilder.create().append("orderCode", order)
							.append("groupId", orderCode).append("isOpen", isOpen).build());
				} else {
					clog.error("更新团购失败", TagBuilder.create().append("orderCode", order).build());
					throw new WrongArgException("更新开团失败");
				}
				logger.info("团购下单成功 orderCode={}，团号groupId={},是否开团isOpen={} ", order, orderCode, isOpen);
				clog.info("团购订单", "开团下单成功",
						TagBuilder.create().append("orderCode", order).append("groupId", orderCode).build());

			} else {
				orderCode = orderPriceAdapter.orderCreate(orderConfirmDTO, member, opChannel, accessWay, deviceId);
			}
		} catch (Exception e) {
			logger.error("confirm order error:{}", e);
			clog.error("confirm下单", e);

			StackTraceElement stackTraceElement = e.getStackTrace()[0];

			StringBuilder sb = new StringBuilder();
			sb.append("File=" + stackTraceElement.getFileName());
			sb.append(",Line=" + stackTraceElement.getLineNumber());
			sb.append(",Method=" + stackTraceElement.getMethodName());
			logger.error("errorHint:" + e.getMessage() + "========" + sb.toString());

			throw new WrongArgException(e.getMessage());
		}

		logger.info("confirm orderCode=" + orderCode);
		JsonApiResult jsonResult = JsonApiResult.ofSuccessResult(orderCode);
		logger.info("confirm result,code=[" + jsonResult.getCode() + "],msg=[" + jsonResult.getMessage() + "]");
		clog.info("confirm下单",
				"confirm result,code=[" + jsonResult.getCode() + "],msg=[" + jsonResult.getMessage() + "]");
		return jsonResult;
	}

	/***
	 * 根据订单号，更新支付状态为已支付
	 *
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/pay
	 * @throws Exception
	 */
	@ApiAuth
	@RequestMapping("/pay")
	@ResponseBody
	public JsonApiResult pay(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		logger.info("execute  pay");
		JSONObject jsonData = JSON.parseObject(data);
		// 订单code
		String orderCode = jsonData.getString("orderCode");
		// 第三方交易号
		String tradeNo = jsonData.getString("tradeNo");

		// 第三方交易号
		String payAccount = jsonData.getString("payAccount");

		// 支付类型
		PaymentType paymentType = PaymentType.valueOf(jsonData.getString("paymentType"));
		// 存款密码
		String paypwd = jsonData.getString("paypwd");
		// 操作员Id
		Long operatorId = jsonData.getLong("operatorId");
		// 操作员姓名
		String operatorName = jsonData.getString("operatorName");

		// 支付金额(TODO:目前并不会用到)
		// BigDecimal totalAmount = jsonData.getBigDecimal("totalAmount");

		logger.info("根据订单号，更新支付状态为已支付：orderCode：{}，tradeNo{},paymentType{}", orderCode, tradeNo, paymentType);
		OrderPayVO orderPayVO = new OrderPayVO();
		boolean result = false;
		OpSalesOrder order = pcInstance.getOrderByCode(orderCode);
		if (order != null && !OrderFlowState.isPaid(order.getSalesOrderStatus())) {
			// result = _callOldOrderPay(orderCode, paymentType.getId(),
			// order.getNeedToPayAmount(), tradeNo);

			try {

				if (StringUtils.isNotEmpty(paypwd)) {

					MemberVO opMember = memberQueryService.getByCode(order.getMemberCode());

					// 判断支付密码是否正确
					if (!BCrypt.checkpw(paypwd, opMember.getPayPasswd())) {

						orderPayVO.setCode(ErrorCode.USER_PAYPWD_ERR.getCode());
						orderPayVO.setMessage(ErrorCode.USER_PAYPWD_ERR.getMesage());
						return JsonApiResult.ofSuccessResult(orderPayVO);
					}

					// 判断存款是否足够
					BigDecimal accountBalance = pcInstance.getMemberAccountByMemberId(opMember.getId(),code);
					if (accountBalance == null) {

						orderPayVO.setCode(ErrorCode.NSUFFICIENT_FUND.getCode());
						orderPayVO.setMessage(ErrorCode.NSUFFICIENT_FUND.getMesage());
						return JsonApiResult.ofSuccessResult(orderPayVO);
					} else {

						if (accountBalance.compareTo(order.getNeedToPayAmount()) < 0) {
							orderPayVO.setCode(ErrorCode.NOT_SUFFICIENT_FUND.getCode());
							orderPayVO.setMessage(ErrorCode.NOT_SUFFICIENT_FUND.getMesage());
							orderPayVO.setAccountFee(accountBalance);
							return JsonApiResult.ofSuccessResult(orderPayVO);
						}

					}

					result = pcInstance.orderAccountPay(orderCode, paymentType.getId(), order.getNeedToPayAmount(),
							payAccount, null, operatorId, operatorName);
				} else {
					// XXX:是否有必要给支付价格呢
					result = pcInstance.orderPay(orderCode, paymentType.getId(), order.getNeedToPayAmount(), payAccount,
							tradeNo);
				}

				if (result) {
					orderPayVO.setPayStatus("1");
					// OpSalesOrder order2 =
					// pcInstance.getOrderByCode(orderCode);
					// try{
					//
					// // 双11活动，支付送权益商品
					// orderAdapter.dobule11Interest(order2);
					// }catch(Exception e){
					//
					// logger.error("权益商品发放出错，"+e.getMessage());
					//
					// }
				}

			} catch (Exception e) {
				logger.error("订单支付异常! e={}", e);
			}

		}
		return JsonApiResult.ofSuccessResult(orderPayVO);
	}

	/***
	 * 取消订单
	 *
	 * @param code
	 * @param data
	 * @return 取消订单
	 * @throws Exception
	 */
	@ApiAuth
	@RequestMapping("/cancel")
	@ResponseBody
	public JsonApiResult cancel(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		logger.info("execute  cancel");
		final JSONObject jsonData = JSON.parseObject(data);

		// 取得订单号
		final String orderCode = jsonData.getString("orderCode");

		logger.info("取消订单：orderCode：{}", orderCode);
		// TODO:调用老的方法
		final Boolean result = _callOldOrderCancel(orderCode);

		return JsonApiResult.ofSuccessResult(result);
	}

	/**
	 * 删除订单
	 */
	@ApiAuth
	@RequestMapping("/delete")
	@ResponseBody
	public JsonApiResult delete(@RequestParam(value = "CODE", required = false) final String code,
			@RequestParam("DATA") final String data) {
		logger.info("execute  delete");
		final JSONObject jsonData = JSON.parseObject(data);
		// 订单code
		final String orderCode = jsonData.getString("orderCode");
		final Long memberId = jsonData.getLong("memberId");

		logger.info("删除订单：orderCode：{}，memberId{}", orderCode, memberId);
		if (StringUtils.isEmpty(orderCode) || memberId == null) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		MemberVO member = memberQueryService.getById(memberId);
		// TODO:调用老的方法
		final Integer status = _callOldOrderDelete(member.getCode(), orderCode, "用户主动删除订单");
		return _buildOrderDeleteResult(status);
	}

	/**
	 * 新建一个订单号
	 */
	@ApiAuth
	@RequestMapping("/createSalesOrderCode")
	@ResponseBody
	public JsonApiResult createSalesOrderCode(@RequestParam(value = "CODE", required = false) final String code) {
		logger.info("execute  createSalesOrderCode");
		String orderCode = pcInstance.createSalesOrderCode(code, 1);
		return JsonApiResult.ofSuccessResult(orderCode);
	}

	/***
	 * 团购价格计算
	 *
	 * @param code
	 * @param data
	 */
	@ApiAuth
	@RequestMapping(value = "/calculate", method = RequestMethod.POST)
	@ResponseBody
	public JsonApiResult calculate(@RequestParam("CODE") final String code, @RequestBody final String data) {
		logger.info("execute  calculate");
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		if (null == memberId) {
			memberId = 1L;
		}
		MemberVO member = memberQueryService.getById(memberId);
		OpChannelVO opChannel = mcOpChannelService.findByCode(code);
		AccessWayEnum accessWay = AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));

		logger.info("confirm orderConfirm =" + jsonData.getString("orderConfirm"));
		OrderConfirmDTO orderConfirmDTO = JSON.parseObject(jsonData.getString("orderConfirm"), OrderConfirmDTO.class);

		BigDecimal price = BigDecimal.ZERO;
		try {
			price = orderPriceAdapter.calculate(orderConfirmDTO, member, opChannel, accessWay);

		} catch (Exception e) {
			logger.error("confirm order error:{}", e);
			throw e;
		}

		logger.info("calculate price=" + price);
		JsonApiResult jsonResult = JsonApiResult.ofSuccessResult(price);
		logger.info("confirm result,code=[" + jsonResult.getCode() + "],msg=[" + jsonResult.getMessage() + "]");
		return jsonResult;
	}

}
