package com.thebeastshop.pegasus.channelservice.controller.order;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.thebeastshop.pegasus.channelservice.constants.PegasusConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.OrderAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.controller.search.SearchController;
import com.thebeastshop.pegasus.channelservice.vo.order.IposOrderListVO;
import com.thebeastshop.pegasus.channelservice.vo.order.IposOrderVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderListVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderVO;
import com.thebeastshop.pegasus.channelservice.vo.order.SyncOrderPayStatusVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;

/***
 * 订单接口
 *
 * @author ztq
 */
@Controller("CommonOrderController")
@RequestMapping("/api/order")
public class OrderController {

	private static final Logger LOGGER = LoggerFactory.getLogger(OrderController.class);
	@Autowired
	private OrderAdapter orderAdapter;

	private Logger logger = LoggerFactory.getLogger(SearchController.class);

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	/***
	 * 根据用户id，查询订单列表
	 *
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/list
	 */
	// @ApiAuth
	@RequestMapping("/list")
	@ResponseBody
	public JsonApiResult list(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data) {
		final JSONObject jsonData = JSON.parseObject(data);

		final String memberCode = jsonData.getString("memberCode");
		final Integer currpage = jsonData.getInteger("page");
		final Integer pagenum = jsonData.getInteger("limit");

		if (StringUtils.isBlank(memberCode)) {
			LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		final List<OpSalesOrderVO> opSalesOrderVOs = pcInstance.orderList(memberCode, currpage, pagenum);

		if (CollectionUtils.isNotEmpty(opSalesOrderVOs)) {
			final List<OrderListVO> orderList = orderAdapter.common2channel(opSalesOrderVOs);
			final Integer orderCount = pcInstance.orderCount(memberCode);
			final OrderVO orderVO = new OrderVO();
			orderVO.setCount(orderCount);
			orderVO.setOrderList(orderList);
			return JsonApiResult.ofSuccessResult(orderVO);

		} else {
			// LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" +
			// ErrorCode.DEFAULT_EXCEPTION.getMesage());
			LOGGER.info(ErrorCode.DATA_NOT_FOUND.getCode() + ":" + ErrorCode.DATA_NOT_FOUND.getMesage());
			return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),
					ErrorCode.DEFAULT_EXCEPTION.getMesage());

		}

	}

	/***
	 * 根据用户id，查询订单列表
	 *
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/list
	 */
	@ApiAuth
	@RequestMapping("/ordersBycode")
	@ResponseBody
	public JsonApiResult ordersByCode(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) {
		final JSONObject jsonData = JSON.parseObject(data);

		String startDate = jsonData.getString("startDate");
		String endDate = jsonData.getString("endDate");

		final String nowDate;
		final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		if (StringUtils.isBlank(startDate)) {
			nowDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
			startDate = nowDate + " 00:00:00";
		} else {
			nowDate = startDate;
			startDate += " 00:00:00";
		}

		// 判断结束日期
		if (StringUtils.isBlank(endDate)) {

			endDate = nowDate + " 23:59:59";
		} else {
			endDate += " 23:59:59";
		}

		final Integer currpage = jsonData.getInteger("page");
		Integer pagenum = jsonData.getInteger("limit");
		if (pagenum == null) {
			pagenum = 30;
		}

		final Date endTime;
		final Date startTime;
		try {
			startTime = dateFormatter.parse(startDate);
			endTime = dateFormatter.parse(endDate);
		} catch (final ParseException e) {
			LOGGER.error("解析日期失败。", e);
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		final List<OpSalesOrderVO> opSalesOrderVOs = pcInstance.ordersByCode(code, currpage, pagenum, startTime,
				endTime);

		if (CollectionUtils.isNotEmpty(opSalesOrderVOs)) {
			final List<IposOrderVO> orderList = orderAdapter.common2order(opSalesOrderVOs);
			final Integer orderCount = pcInstance.orderCountByCode(code, startTime, endTime);
			final IposOrderListVO orderListVO = new IposOrderListVO();
			orderListVO.setCount(orderCount);
			orderListVO.setOrderList(orderList);
			return JsonApiResult.ofSuccessResult(orderListVO);
		} else {
			LOGGER.error(ErrorCode.DATA_NOT_FOUND.getCode() + ":" + ErrorCode.DATA_NOT_FOUND.getMesage());
			return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
					ErrorCode.DATA_NOT_FOUND.getMesage());
		}
	}

	// /***
	// * 根据订单id，查询订单行详情
	// *
	// * @param code
	// * @param data
	// * @return 对应原 /beast_site/order/info
	// */
	// // @ApiAuth
	// @RequestMapping("/detail")
	// @ResponseBody
	// public JsonApiResult detail(@RequestParam("CODE") final String code,
	// @RequestParam("DATA") final String data) {
	// logger.info("execute detail");
	// final JSONObject jsonData = JSON.parseObject(data);
	// // 订单code
	// final String orderCode = jsonData.getString("orderCode");
	// final String memberCode = jsonData.getString("memberCode");
	// final String memberId = jsonData.getString("memberId");
	// if (orderCode == null) {
	// return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
	// ErrorCode.PARAMS_ILLEGAL.getMesage());
	// }
	//
	// logger.info("根据订单id，查询订单行详情 memberCode{},orderCode{}", memberCode,
	// orderCode);
	//
	// // 取得订单内容
	// final OpSalesOrderVO opSalesOrderVO = pcInstance.orderDetail(memberCode,
	// orderCode);
	//
	// if (opSalesOrderVO == null) {
	// LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" +
	// ErrorCode.DEFAULT_EXCEPTION.getMesage());
	// return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),
	// ErrorCode.DEFAULT_EXCEPTION.getMesage());
	// }
	//
	// final OrderDetailVO vo = orderAdapter.common2channel(opSalesOrderVO);
	//
	// if (StringUtils.isNotBlank(memberId)) {
	// final MemberVO member =
	// memberQueryService.getById(Long.valueOf(memberId));
	// // final Channel channel = channelService.getByCode(code);
	// AccessWayEnum accessWay =
	// AccessWayEnum.getEnumByCode(jsonData.getInteger("accessWay"));
	// OpChannelVO opChannel = mcOpChannelService.findByCode(code);
	// com.thebeastshop.support.vo.order.OrderDetailVO orderDetail =
	// appOrderAdapter.getOrderDetail(opSalesOrderVO,
	// member, opChannel, accessWay);
	//
	// vo.setPriceSteps(orderDetail.getPriceSteps());
	//
	// }
	//
	// return JsonApiResult.ofSuccessResult(vo);
	// }

	/***
	 * 根据订单号，更新支付状态为已支付
	 *
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/pay
	 * @throws Exception
	 */
	@ApiAuth
	@RequestMapping("/pay")
	@ResponseBody
	public JsonApiResult pay(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		logger.info("execute pay");
		final SyncOrderPayStatusVO vo = JSON.parseObject(data, SyncOrderPayStatusVO.class);

		if (vo == null) {
			LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		// 判断订单编号，支付方式，总金额
		if (StringUtils.isBlank(vo.getOrderNo()) || StringUtils.isBlank(vo.getPayMethod()) || vo.getTotal() == null) {
			LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		final Integer paymentType = getPaymentType(vo.getPayMethod());

		final boolean result = pcInstance.orderPay(vo.getOrderNo(), paymentType,
				new BigDecimal(String.valueOf(vo.getTotal())), vo.getPayAccount());

		if (result) {
			return JsonApiResult.ofSuccessResult(result);
		}
		LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),
				ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}

	/***
	 * 根据订单号，更新支付状态为已支付
	 *
	 * @param code
	 * @param data
	 * @return 对应原 /beast_site/order/pay
	 * @throws Exception
	 */
	@ApiAuth
	@RequestMapping("/orderPay")
	@ResponseBody
	public JsonApiResult orderPay(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		logger.info("execute orderPay");
		final SyncOrderPayStatusVO vo = JSON.parseObject(data, SyncOrderPayStatusVO.class);

		if (vo == null) {
			LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		// 判断订单编号，支付方式，总金额
		if (StringUtils.isBlank(vo.getOrderNo()) || StringUtils.isBlank(vo.getPayMethod()) || vo.getTotal() == null) {
			LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		final Integer paymentType = getPaymentType(vo.getPayMethod());

		final boolean result = pcInstance.orderPay(vo.getOrderNo(), paymentType,
				new BigDecimal(String.valueOf(vo.getTotal())), vo.getPayAccount(), vo.getTradeNo());

		if (result) {

			// try{
			// OpSalesOrder order = pcInstance.getOrderByCode(vo.getOrderNo());
			// // 双11活动，支付送权益商品
			// appOrderAdapter.dobule11Interest(order);
			// }catch(Exception e){
			//
			// LOGGER.error("权益商品发放出错，"+e.getMessage());
			//
			// }

			return JsonApiResult.ofSuccessResult(result);
		}
		LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" + ErrorCode.DEFAULT_EXCEPTION.getMesage());
		return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),
				ErrorCode.DEFAULT_EXCEPTION.getMesage());
	}

	/***
	 * 查询订是否取消
	 *
	 * @param code
	 * @param data
	 * @return 取消订单
	 */
	@ApiAuth
	@RequestMapping("/specilOrderIsCancel")
	@ResponseBody
	public JsonApiResult specilOrderIsCancel(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) {
		logger.info("execute specilOrderIsCancel");
		final JSONObject jsonData = JSON.parseObject(data);

		// 取得订单号
		final String orderCode = jsonData.getString("orderNo");
		final boolean result = pcInstance.orderSpecilIsCancel(orderCode);

		return JsonApiResult.ofSuccessResult(result);
	}

	/***
	 * 查询订是否取消
	 *
	 * @param code
	 * @param data
	 * @return 取消订单
	 */
	@ApiAuth
	@RequestMapping("/orderstatus")
	@ResponseBody
	public JsonApiResult specilOrderStatus(@RequestParam("CODE") final String code,
			@RequestParam("DATA") final String data) {
		logger.info("execute orderstatus");
		final JSONObject jsonData = JSON.parseObject(data);

		// 取得订单号
		final String orderCode = jsonData.getString("orderNo");
		final Integer result = pcInstance.orderStatus(orderCode);

		return JsonApiResult.ofSuccessResult(result);
	}

	/***
	 * 取消订单
	 *
	 * @param code
	 * @param data
	 * @return 取消订单
	 * @throws Exception
	 */
	@ApiAuth
	@RequestMapping("/orderCancel")
	@ResponseBody
	public JsonApiResult orderCancel(@RequestParam("CODE") final String code, @RequestParam("DATA") final String data)
			throws Exception {
		logger.info("execute orderCancel");
		final JSONObject jsonData = JSON.parseObject(data);

		// 取得订单号
		final String orderCode = jsonData.getString("orderNo");
		final Boolean result = pcInstance.cancleSalesOrder(orderCode);

		return JsonApiResult.ofSuccessResult(result);
	}

	/**
	 * 订单隐藏接口
	 */
	// @ApiAuth
	@RequestMapping("/orderDelete")
	@ResponseBody
	public JsonApiResult orderDelete(@RequestParam(value = "CODE", required = false) final String code,
			@RequestParam("DATA") final String data) {
		logger.info("execute orderDelete");
		final JSONObject jsonData = JSON.parseObject(data);
		// 订单code
		final String orderCode = jsonData.getString("orderCode");
		final String memberCode = jsonData.getString("memberCode");

		if (StringUtils.isEmpty(orderCode) || StringUtils.isEmpty(memberCode)) {
			return JsonApiResult.ofErrorResult(ErrorCode.PARAMS_ILLEGAL.getCode(),
					ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		final Integer status = pcInstance.deleteSalesOrder(memberCode, orderCode, "用户主动删除订单");

		return buildOrderDeleteResult(status);
	}

	private JsonApiResult buildOrderDeleteResult(final Integer status) {
		if (status == 1) {
			return JsonApiResult.ofSuccessResult(true);
		} else if (status == -1) {
			return JsonApiResult.ofErrorResult(-1, "抱歉，订单不存在");
		} else if (status == -2) {
			return JsonApiResult.ofErrorResult(-1, "抱歉,此订单信息有误,无法删除。");
		} else if (status == 2) {
			return JsonApiResult.ofErrorResult(-1, "抱歉,此订单还有商品未发货,无法删除。");
		} else if (status == 3) {
			return JsonApiResult.ofErrorResult(-1, "抱歉,等待支付状态的订单无法删除,请先取消订单。");
		} else if (status == 4) {
			return JsonApiResult.ofErrorResult(-1, "抱歉，订单不可删除");
		} else {
			return JsonApiResult.ofErrorResult(-1, "抱歉，订单不可删除");
		}
	}

	private Integer getPaymentType(final String payMethod) {
		Integer paymentType = null;
		if ("CASH".equals(payMethod)) {
			paymentType = PegasusConstants.Payment.TYPE_CASH;
		} else if ("BANK".equals(payMethod)) {
			paymentType = PegasusConstants.Payment.TYPE_DEBIT_CARD;
		} else if ("CRDT".equals(payMethod)) {
			paymentType = PegasusConstants.Payment.TYPE_CREDIT_CARD;
		} else if ("WXSQ".equals(payMethod)) {
			paymentType = PegasusConstants.Payment.TYPE_WEIXIN;
		} else if ("ZFBA".equals(payMethod)) {
			paymentType = PegasusConstants.Payment.TYPE_ALIPAY;
		} else if ("CMB".equals(payMethod)) {
			paymentType = PegasusConstants.Payment.TYPE_CMB;
		} else if ("TRANSFER".equals(payMethod)) {
			paymentType = PegasusConstants.Payment.TYPE_TRANSFER;
		}

		return paymentType;

	}

	/***
	 * 订单创建接口
	 *
	 * @param code
	 *            渠道编码
	 * @param data
	 *            业务参数
	 * @return 对应原/beast_site/order/confirm
	 * @throws Exception
	 */
	// @ApiAuth
	// @RequestMapping("/createFlower")
	// @ResponseBody
	// @Deprecated
	// public JsonApiResult createFlower(@RequestParam("CODE") final String
	// code, @RequestParam("DATA") final String data) throws Exception {
	// logger.info("execute createFlower");
	// final OrderCreateVO orderCreateVO = JSON.parseObject(data,
	// OrderCreateVO.class);
	// MemberVO member =
	// memberQueryService.getById(orderCreateVO.getCustomerId());
	// // 礼品卡时不支技vip
	// if (!StringUtils.isBlank(orderCreateVO.getPresentCards())) {
	// member.setMemberLevel(MemberLevelEnum.NORMAL.getCode());
	// }
	//
	// OpChannelVO opChannel = mcOpChannelService.findByCode(code);
	// AccessWay accessWay = AccessWay.PC;
	// List<CartProductPack> snapshotPacks = null;// 用于订单快照
	// orderCreateVO.setChannelCode(code);
	// try {
	//
	// final OpSalesOrderVO opSalesOrderVO =
	// comOorderAdapter.orderWebsite2Common2(orderCreateVO,
	// AccessWay.PC,member,opChannel);
	// LOGGER.info("返回的 订单vo 信息 opSalesOrderVO={}", opSalesOrderVO);
	// final OpSalesOrderResponseVO orderResp =
	// pcInstance.editOrder(opSalesOrderVO,accessWay);
	//
	// if (orderResp != null) {
	// final OrderCreateResponseVO vo = new OrderCreateResponseVO();
	// vo.setAmount(orderResp.getAmount().doubleValue());
	// vo.setOrderNo(orderResp.getOrderCode());
	// vo.setId(orderResp.getId());
	//
	// // 保存订单快照
	// if (StringUtils.isNotBlank(orderResp.getOrderCode()) &&
	// CollectionUtils.isNotEmpty(snapshotPacks)) {
	// OrderSnapshotDTO snapshotDTO = new OrderSnapshotDTO();
	// snapshotDTO.setAccessWay(accessWay);
	// snapshotDTO.setOpChannel(opChannel);
	// snapshotDTO.setMember(member);
	// snapshotDTO.setOrderId(orderResp.getId());
	// snapshotDTO.setPacks(snapshotPacks);
	// if (StringUtils.isNotBlank(orderCreateVO.getCouponCode())) {
	// snapshotDTO.setCouponId(Long.valueOf(orderCreateVO.getCouponCode()));
	// }
	// orderSnapshotService.saveSnapshot(snapshotDTO);
	// }
	//
	// return JsonApiResult.ofSuccessResult(vo);
	// }
	// LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" +
	// ErrorCode.DEFAULT_EXCEPTION.getMesage());
	// return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),
	// ErrorCode.DEFAULT_EXCEPTION.getMesage());
	// } catch (Exception e) {
	// LOGGER.error(ErrorCode.DEFAULT_EXCEPTION.getCode() + ":" +
	// ErrorCode.DEFAULT_EXCEPTION.getMesage());
	// LOGGER.error("系统异常 e={}", e);
	// return JsonApiResult.ofErrorResult(ErrorCode.DEFAULT_EXCEPTION.getCode(),
	// e.getMessage());
	// }
	// }
}
