package com.thebeastshop.pegasus.channelservice.controller.operation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.configuration.service.AppDownloadService;
import com.thebeastshop.configuration.service.FissionRedEnvelopeService;
import com.thebeastshop.configuration.service.ReceiveCouponService;
import com.thebeastshop.configuration.vo.AppDownloadVO;
import com.thebeastshop.configuration.vo.FissionRedEnvelopVO;
import com.thebeastshop.configuration.vo.ReceiveCouponVO;
import com.thebeastshop.configuration.vo.ShareVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.support.vo.operation.ConfigAppDownloadVO;
import com.thebeastshop.support.vo.operation.ConfigCouponVO;
import com.thebeastshop.support.vo.operation.ConfigRedEnvelopeVO;
import com.thebeastshop.support.vo.operation.Share;

import javax.annotation.Resource;

@Deprecated
@Controller
@RequestMapping(value = "/api/operation")
public class OperationController {

	@Resource
	private ReceiveCouponService receiveCouponService;

	@Resource
	private AppDownloadService appDownloadService;

	@Resource
	private FissionRedEnvelopeService fissionRedEnvelopeService;

	protected Logger logger = LoggerFactory.getLogger(getClass());

	/**
	 * 获取优惠券配置
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getCouponConfig", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getCouponConfig(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		String id = jsonData.getString("id");
		logger.info("getCouponConfig：id=", id);
		ConfigCouponVO configCouponVO = new ConfigCouponVO();

		ReceiveCouponVO couponConfig = new ReceiveCouponVO();
		ServiceResp<ReceiveCouponVO> couponVOServiceResp = receiveCouponService
				.getCanUseReceiveCouponByEncryptionId(id);
		if (couponVOServiceResp.isSuccess()) {
			couponConfig = couponVOServiceResp.getBean();
			logger.info("优惠券配置信息 couponConfig{}", couponConfig);
			configCouponVO = convertCouponDetails(couponConfig);
		} else {
			configCouponVO.setError(couponVOServiceResp.getRespCode());
			// throw new WrongArgException(couponVOServiceResp.getRespCode() +
			// couponVOServiceResp.getRespMsg(), "id", id);
		}

		return JsonApiResult.ofSuccessResult(configCouponVO);
	}

	/**
	 * 获取app下载页配置
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getDownloadConfig", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getDownloadConfig(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long id = jsonData.getLong("id");
		ConfigAppDownloadVO configAppDownloadVO = new ConfigAppDownloadVO();
		logger.info("getDownloadConfig：id=", id);
		AppDownloadVO appDownloadVO = new AppDownloadVO();
		ServiceResp<AppDownloadVO> appDownloadServiceResp = appDownloadService.getCanUseAppDownloadById(id);
		if (appDownloadServiceResp.isSuccess()) {
			appDownloadVO = appDownloadServiceResp.getBean();
			logger.info("下载页配置信息 appDownloadVO{}", appDownloadVO);
			configAppDownloadVO = convertAppDownloadDetails(appDownloadVO);
		} else {
			configAppDownloadVO.setError(appDownloadServiceResp.getRespCode());
			// throw new WrongArgException(appDownloadServiceResp.getRespCode()
			// + appDownloadServiceResp.getRespMsg(), "id", id);
		}
		return JsonApiResult.ofSuccessResult(configAppDownloadVO);
	}

	/**
	 * 获取红包配置
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getRedEnvelopeConfig", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getRedEnvelopeConfig(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long id = jsonData.getLong("id");
		logger.info("getRedEnvelopeConfig：id=", id);
		ConfigRedEnvelopeVO configRedEnvelopeVO = new ConfigRedEnvelopeVO();
		FissionRedEnvelopVO fissionRedEnvelopVO = new FissionRedEnvelopVO();
		ServiceResp<FissionRedEnvelopVO> RedEnvelopServiceResp = fissionRedEnvelopeService.getCanUseFissionById(id);
		if (RedEnvelopServiceResp.isSuccess()) {
			fissionRedEnvelopVO = RedEnvelopServiceResp.getBean();
			logger.info("列表红包配置信息 fissionRedEnvelopVO{}", fissionRedEnvelopVO);
			configRedEnvelopeVO = convertRedEnvelopeDetails(fissionRedEnvelopVO);
		} else {
			configRedEnvelopeVO.setError(RedEnvelopServiceResp.getRespCode());
			// throw new WrongArgException(RedEnvelopServiceResp.getRespCode() +
			// RedEnvelopServiceResp.getRespMsg(), "id", id);
		}
		return JsonApiResult.ofSuccessResult(configRedEnvelopeVO);
	}

	/**
	 * 优惠券配置对象转换
	 * 
	 * @return
	 */
	public ConfigCouponVO convertCouponDetails(ReceiveCouponVO receiveCouponVO) {
		ConfigCouponVO configCouponVO = new ConfigCouponVO();
		Share share = new Share();
		ShareVO shareVO = receiveCouponVO.getShare();
		share.setContent(shareVO.getContent());
		share.setImage(shareVO.getImage());
		share.setTitle(shareVO.getTitle());
		share.setUrl(shareVO.getLink());
		configCouponVO.setId(receiveCouponVO.getEncryId());
		configCouponVO.setShare(share);
		configCouponVO.setAndroidTD(receiveCouponVO.getAndroidTD());
		configCouponVO.setDataPack(receiveCouponVO.getDataPack());
		configCouponVO.setIosTD(receiveCouponVO.getIosTD());
		configCouponVO.setName(receiveCouponVO.getName());
		configCouponVO.setPurpose(receiveCouponVO.getPurpose());
		configCouponVO.setRelatedId(receiveCouponVO.getRelatedId());
		configCouponVO.setRelatedLink(receiveCouponVO.getRelatedLink());
		configCouponVO.setRelatedType(receiveCouponVO.getRelatedTypeId());
		configCouponVO.setTitle(receiveCouponVO.getTitle());
		configCouponVO.setSkip(receiveCouponVO.getSkip());
		return configCouponVO;
	}

	/**
	 * app下载页配置对象转换
	 * 
	 * @return
	 */
	public ConfigAppDownloadVO convertAppDownloadDetails(AppDownloadVO appDownloadVO) {
		ConfigAppDownloadVO configAppDownloadVO = new ConfigAppDownloadVO();
		Share share = new Share();
		ShareVO shareVO = appDownloadVO.getShare();
		share.setContent(shareVO.getContent());
		share.setImage(shareVO.getImage());
		share.setTitle(shareVO.getTitle());
		share.setUrl(shareVO.getLink());
		configAppDownloadVO.setShare(share);
		configAppDownloadVO.setAndroidTD(appDownloadVO.getAndroidTD());
		configAppDownloadVO.setDataPack(appDownloadVO.getDataPack());
		configAppDownloadVO.setIosTD(appDownloadVO.getIosTD());
		configAppDownloadVO.setName(appDownloadVO.getName());
		configAppDownloadVO.setPurpose(appDownloadVO.getPurpose());
		configAppDownloadVO.setTitle(appDownloadVO.getTitle());
		return configAppDownloadVO;
	}

	/**
	 * 红包页配置对象转换
	 * 
	 * @return
	 */
	public ConfigRedEnvelopeVO convertRedEnvelopeDetails(FissionRedEnvelopVO fissionRedEnvelopVO) {
		ConfigRedEnvelopeVO configRedEnvelopeVO = new ConfigRedEnvelopeVO();
		Share share = new Share();
		ShareVO shareVO = fissionRedEnvelopVO.getShare();
		share.setContent(shareVO.getContent());
		share.setImage(shareVO.getImage());
		share.setTitle(shareVO.getTitle());
		share.setUrl(shareVO.getLink());
		configRedEnvelopeVO.setShare(share);
		configRedEnvelopeVO.setAndroidTD(fissionRedEnvelopVO.getAndroidTD());
		configRedEnvelopeVO.setDataPack(fissionRedEnvelopVO.getDataPack());
		configRedEnvelopeVO.setIosTD(fissionRedEnvelopVO.getIosTD());
		configRedEnvelopeVO.setName(fissionRedEnvelopVO.getName());
		configRedEnvelopeVO.setRelatedId(fissionRedEnvelopVO.getRelatedId());
		configRedEnvelopeVO.setRelatedLink(fissionRedEnvelopVO.getRelatedLink());
		configRedEnvelopeVO.setRelatedType(fissionRedEnvelopVO.getRelatedType());
		configRedEnvelopeVO.setTitle(fissionRedEnvelopVO.getTitle());
		configRedEnvelopeVO.setSkip(fissionRedEnvelopVO.getSkip());
		return configRedEnvelopeVO;
	}
}
