package com.thebeastshop.pegasus.channelservice.controller.message;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.cond.MessageRecordAppItnCond;
import com.thebeastshop.message.enums.AppItnReadEnum;
import com.thebeastshop.message.service.MessageRecordService;
import com.thebeastshop.message.vo.MessageRecordAppItnVO;
import com.thebeastshop.message.vo.Pagination;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.message.MessageAdapter;
import com.thebeastshop.pegasus.channelservice.controller.order.app.OrderController;
import com.thebeastshop.support.enums.MessageType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.message.MessageVO;

/**
 * 消息中心
 * 
 * @author WangYawei
 *
 */
@Controller
@RequestMapping(value = "/api/message")
public class MessageControllor {

	@Autowired
	private MessageAdapter adapter;

	private final Logger logger = LoggerFactory.getLogger(OrderController.class);

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private MessageRecordService messageRecordService;

	/**
	 * 获取消息列表
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getList", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getList(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		Integer offset = jsonData.getInteger("offset");
		Integer limit = jsonData.getInteger("limit");
		MessageType type = jsonData.getObject("type", MessageType.class);

		MemberVO member = memberQueryService.getById(memberId);

		MessageRecordAppItnCond messageRecordAppItnCond = new MessageRecordAppItnCond();
		messageRecordAppItnCond.setOffset(offset);
		messageRecordAppItnCond.setPagenum(limit);
		messageRecordAppItnCond.setMsgTo(member.getCode());
		messageRecordAppItnCond.setPublishType(type.getType());
		messageRecordAppItnCond.setUnread(AppItnReadEnum.ALL);
		Pagination<MessageRecordAppItnVO> records = messageRecordService.findMessageRecordByMemberAndPublishType(messageRecordAppItnCond);
		MessageVO messageVO = adapter.getMessageList(records, member);

		return JsonApiResult.ofSuccessResult(messageVO);
	}

	/**
	 * 获取当前用户的未读消息数量
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/getUnreadSize", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult getUnreadSize(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		MemberVO member = memberQueryService.getById(memberId);

		Integer size = adapter.returnUnreadMessage(MessageType.ALL.getType(), member);
		return JsonApiResult.ofSuccessResult(size);
	}

	/**
	 * 删除一条数据
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/delete", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult delete(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		Long memberId = jsonData.getLong("memberId");
		Long messageId = jsonData.getLong("messageId");
		MemberVO member = memberQueryService.getById(memberId);
		ServiceResp<Boolean> receive = messageRecordService.deleteByMessageId(messageId, member.getCode());
		if (receive.isSuccess()) {
			return JsonApiResult.ofSuccessResult(true);
		} else {
			throw new WrongArgException(receive.getRespCode() + receive.getRespMsg(), "messageId=", messageId);
		}
	}

	/**
	 * 标记消息已读
	 * 
	 * @param code
	 * @param data
	 * @return
	 */
	@RequestMapping(path = "/read", method = RequestMethod.GET)
	@ResponseStatus(HttpStatus.OK)
	@ResponseBody
	public JsonApiResult markMessagesRead(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		List<Long> ids = JSON.parseArray(jsonData.getString("ids"), Long.class);
		Long memberId = jsonData.getLong("memberId");
		MemberVO member = memberQueryService.getById(memberId);

		ServiceResp<Boolean> receive = messageRecordService.updateReadByMessageId(ids, member.getCode());
		if (receive.isSuccess()) {
			return JsonApiResult.ofSuccessResult(true);
		} else {
			throw new WrongArgException(receive.getRespCode() + receive.getRespMsg(), "ids=", ids);
		}
	}

}
