package com.thebeastshop.pegasus.channelservice.controller.member;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.thebeastshop.member.enums.LoginTypeEnum;

public class MemberVO implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// 会员编号（code）
	private String id;

	private Long memberId;
	// 创建时间
	private Date createTime;
	// 基础信息
	private ProfileVO profile = new ProfileVO();
	// 手机号区号
	private String mobileAreaCode = "+86";
	// 登录手机号
	private String mobile;
	// 等级
	private LevelVO level = new LevelVO();
	// 积分
	private BigDecimal point;
	// 所有登录方式
	private List<LoginMethod> loginMethods = new ArrayList<LoginMethod>();

	public String getMobileAreaCode() {
		return mobileAreaCode;
	}

	public void setMobileAreaCode(String mobileAreaCode) {
		this.mobileAreaCode = mobileAreaCode;
	}

	public List<LoginMethod> getLoginMethods() {
		return loginMethods;
	}

	public void setLoginMethods(List<LoginMethod> loginMethods) {
		this.loginMethods = loginMethods;
	}

	public MemberVO() {
		super();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public ProfileVO getProfile() {
		return profile;
	}

	public void setProfile(ProfileVO profile) {
		this.profile = profile;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public LevelVO getLevel() {
		return level;
	}

	public void setLevel(LevelVO level) {
		this.level = level;
	}

	public BigDecimal getPoint() {
		return point;
	}

	public void setPoint(BigDecimal point) {
		this.point = point;
	}

	public Long getMemberId() {
		return memberId;
	}

	public void setMemberId(Long memberId) {
		this.memberId = memberId;
	}

	@Override
	public String toString() {
		return "MemberVO [id=" + id + ", createTime=" + createTime + ", profile=" + profile + ", mobileAreaCode="
				+ mobileAreaCode + ", mobile=" + mobile + ", level=" + level + ", point=" + point + ", loginMethods="
				+ loginMethods +",memberId = "+memberId+ "]";
	}

	// ===============inner classes============

	public static class TitleVO {
		public int id;
		public String name;

		public int getId() {
			return id;
		}

		public void setId(int id) {
			this.id = id;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}
	}

	public static class ProfileVO {
		// 用户昵称
		private String nickName = "";
		// 头像链接
		private String avatarUrl = "";
		// 称谓
		private TitleVO title;
		// 生日
		private String birthday;
		// true 可编辑 false 不可编辑
		private Boolean birthdayEditable = false;

		public Boolean getBirthdayEditable() {
			return birthdayEditable;
		}

		public void setBirthdayEditable(Boolean birthdayEditable) {
			this.birthdayEditable = birthdayEditable;
		}

		public String getNickName() {
			return nickName;
		}

		public void setNickName(String nickName) {
			this.nickName = nickName;
		}

		public String getAvatarUrl() {
			return avatarUrl;
		}

		public void setAvatarUrl(String avatarUrl) {
			this.avatarUrl = avatarUrl;
		}

		public TitleVO getTitle() {
			return title;
		}

		public void setTitle(TitleVO title) {
			this.title = title;
		}

		public String getBirthday() {
			return birthday;
		}

		public void setBirthday(String birthday) {
			this.birthday = birthday;
		}

		@Override
		public String toString() {
			return "ProfileVO [nickName=" + nickName + ", avatarUrl=" + avatarUrl + ", title=" + title + ", birthday="
					+ birthday + ", birthdayEditable=" + birthdayEditable + "]";
		}

	}

	public static class LevelVO {
		// 等级
		private Integer id;
		// 等级描述
		private String name;

		public Integer getId() {
			return id;
		}

		public void setId(Integer id) {
			this.id = id;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		@Override
		public String toString() {
			return "LevelVO [id=" + id + ", name=" + name + "]";
		}

	}

	public static class LoginMethod {
		private LoginTypeEnum type;
		private String principal;
		private String unionId;
		private String mobileAreaCode;

		public LoginMethod() {
			super();
		}

		public LoginMethod(LoginTypeEnum type, String principal, String unionId, String mobileAreaCode) {
			super();
			this.type = type;
			this.principal = principal;
			this.unionId = unionId;
			this.mobileAreaCode = mobileAreaCode;
		}

		public LoginTypeEnum getType() {
			return type;
		}

		public void setType(LoginTypeEnum type) {
			this.type = type;
		}

		public String getPrincipal() {
			return principal;
		}

		public void setPrincipal(String principal) {
			this.principal = principal;
		}

		public String getUnionId() {
			return unionId;
		}

		public void setUnionId(String unionId) {
			this.unionId = unionId;
		}

		public String getMobileAreaCode() {
			return mobileAreaCode;
		}

		public void setMobileAreaCode(String mobileAreaCode) {
			this.mobileAreaCode = mobileAreaCode;
		}

		@Override
		public String toString() {
			return "LoginMethod [type=" + type + ", principal=" + principal + ", unionId=" + unionId
					+ ", mobileAreaCode=" + mobileAreaCode + "]";
		}

	}
}
