package com.thebeastshop.pegasus.channelservice.controller.member;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.member.cron.MemberPointFlowCond;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.point.MemberShipIntegralService;
import com.thebeastshop.member.vo.MemberResponseVO;
import com.thebeastshop.member.vo.point.MemberIntegralVO;
import com.thebeastshop.pegasus.channelservice.ApiAuth;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.adapter.member.MemberPointAdapter;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.page.Pagination;
import com.thebeastshop.support.vo.member.ScoreRecordVO;

/**
 * 会员积分服务接口入口
 * 
 * @author Paul-xiong
 *
 */
@Controller
@RequestMapping("/api/point")
@ResponseBody
public class MemberPointController {

	@Autowired
	private MemberShipIntegralService memberShipIntegralService;

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private MemberPointAdapter memberPointAdaptor;

	/**
	 * 获取会员积分记录
	 * 
	 * @return
	 */
	@ApiAuth
	@RequestMapping(value = "/history")
	public JsonApiResult getHistory(@RequestParam("CODE") String code, @RequestParam("DATA") String data) {
		JSONObject jsonData = JSONObject.parseObject(data);
		final Long memberId = jsonData.getLong("memberId");
		final Integer offset = jsonData.getInteger("offset");
		final Integer limit = jsonData.getInteger("limit");
		Page<ScoreRecordVO> rt = new Page<>(new Pagination(offset, limit));

		MemberPointFlowCond cond = new MemberPointFlowCond();
		cond.setCurrentPage(offset / limit + 1);
		cond.setMemberId(memberId);
		cond.setPageSize(limit);
		MemberResponseVO response = memberShipIntegralService.findMemberIntegralsByPage(cond);
		if (response != null && response.getResult() != null && response.getResult().getPage() != null) {
			@SuppressWarnings("unchecked")
			List<MemberIntegralVO> items = (List<MemberIntegralVO>) response.getResult().getData();
			com.thebeastshop.member.vo.MemberResponseVO.Page page = response.getResult().getPage();
			rt.setTotal(page.getTotalCount());
			rt.setItems(memberPointAdaptor.getScoreRecord(items));
		}
		return JsonApiResult.ofSuccessResult(rt);
	}
}
